/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#import "WiiRemoteManager.h"

#import "IOBluetoothDevice_Wiiremote.h"
#import "DebugLog.h"

#include <assert.h>

@implementation WiiRemoteManager
- initWithInquiryLength:(int)inquiry_length_in_sec
{
	DebugLog("Hello\n");

	self = [super init];
	[self setStatus:WiiRemoteManagerStatusInquiryStoped];
	wiiRemoteArray = [NSMutableArray new];
	inquiry = [[IOBluetoothDeviceInquiry inquiryWithDelegate:self] retain];

	// set parameters 
	[inquiry setInquiryLength:inquiry_length_in_sec];
#ifdef WRMT_DEVICE_NAME_CHECK
	[inquiry setUpdateNewDeviceNames:YES];
#else
	[inquiry setUpdateNewDeviceNames:NO];
#endif

	[inquiry setSearchCriteria:WRMT_SERVICE_CLASS_MAJOR
		majorDeviceClass:WRMT_DEVICE_CLASS_MAJOR
		minorDeviceClass:WRMT_DEVICE_CLASS_MINOR];

	DebugLog("Bye\n");
	return self;
}

- (void)dealloc
{
	[self closeAllWiiRemotes];
	[wiiRemoteArray autorelease];
	[inquiry autorelease];
	[super dealloc];
}

- (void)startInquiry
{
	DebugLog("Hello\n");

	if ([self status] == WiiRemoteManagerStatusInquiryStoped)
	{
		[self setStatus:WiiRemoteManagerStatusInquiryStarting];
		[inquiry start];
	}

	DebugLog("Bye\n");
}

- (void)stopInquiry
{
	DebugLog("Hello\n");

	if (status == WiiRemoteManagerStatusInquiryRunning)
	{
		[self setStatus:WiiRemoteManagerStatusInquiryStopping];
		[inquiry stop];
	}

	DebugLog("Bye\n");
}

- (WiiRemoteManagerStatus)status
{
	return status;
}

- (void)setStatus:(WiiRemoteManagerStatus)newStatus;
{
	status = newStatus;
}

- (WiiRemoteImplement *)wiiRemoteAt:(int)index
{
	assert(index >= 0 && index < [wiiRemoteArray count]);
	return [wiiRemoteArray objectAtIndex:index];
}

- (void)closeAllWiiRemotes
{
	DebugLog("Hello\n");

	id wiiremote;
	NSEnumerator *enumerator = [wiiRemoteArray objectEnumerator];
	while ((wiiremote = [enumerator nextObject]))
	{
		[wiiremote close];
	}

	DebugLog("Bye\n");
}

- (void)clear
{
	DebugLog("Hello\n");

	[self closeAllWiiRemotes];
	[wiiRemoteArray removeAllObjects];
	[inquiry clearFoundDevices];

	DebugLog("Bye\n");
}

- (int)numberOfWiiRemotes
{
	int result;

	result = [wiiRemoteArray count];

	assert(result <= WRMT_MAX_DEVICES); 
	return result;
}

// callbacks NSObject (IOBluetoothDeviceInquiryDelegate)
- (void) deviceInquiryStarted:(IOBluetoothDeviceInquiry*)sender
{
	DebugLog("Hello\n");

	[self setStatus:WiiRemoteManagerStatusInquiryRunning];

	DebugLog("Bye\n");
}

- (void) deviceInquiryDeviceFound:(IOBluetoothDeviceInquiry*)sender
	device:(IOBluetoothDevice*)device
{
	DebugLog("Hello\n");
	DebugLog("device == %p\n", device);

	if ([wiiRemoteArray count] < WRMT_MAX_DEVICES)
	{
		id wiiremote = [[[WiiRemoteImplement alloc] initWithDevice:device] autorelease];
		[wiiRemoteArray addObject:wiiremote];
		DebugLog("wiiremote == %p\n", wiiremote);
	}

	DebugLog("Bye\n");
}

- (void) deviceInquiryUpdatingDeviceNamesStarted:(IOBluetoothDeviceInquiry*)sender
	devicesRemaining:(int)devicesRemaining
{
	DebugLog("Hello\n");
}

- (void) deviceInquiryDeviceNameUpdated:(IOBluetoothDeviceInquiry*)sender
	device:(IOBluetoothDevice*)device
	devicesRemaining:(int)devicesRemaining
{
	DebugLog("Hello\n");
}

- (void) deviceInquiryComplete:(IOBluetoothDeviceInquiry*)sender
	error:(IOReturn)error
	aborted:(BOOL)aborted
{
	DebugLog("Hello\n");

	[self setStatus:WiiRemoteManagerStatusInquiryStoped];

	DebugLog("Bye\n");
}
@end

