/*
	<libnet.c>>
ңУǺץ
	 ꥨ ͥåȥңУǥ <ͥåȥط饤֥>
	 Version 0.001, October 2000
    $Id: libnet.c,v 0.63 2004/05/31 10:17:49 yamakawa Exp $
	 ------------------------------------------------------------
	 Copyright (C) 2000,2001,2002,2003ǯ naoki kuwamori<naoki@kuwamori.com>

	 ܥץϥե꡼եȥǤʤϡFree Software Foundation
	 ɽGNU ̸ͭѵΡ֥С󣲡װϤʹߤγƥС
	 椫餤줫򤷡ΥС˽äܥץ
	 ۤޤѹ뤳ȤǤޤ

	ʳΥ饤󥹤˾ξϡ᡼뤯.
	<naoki@kuwamori.com>


	Laurier Net work RPG server<game network library>
	Version 0.001, October 2000
    $Id: libnet.c,v 0.63 2004/05/31 10:17:49 yamakawa Exp $
	Copyright (C) 2000,2001,2002,2003 Naoki Kuwamori <naoki@kuwamori.com>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or any
	later version.

	If you wish another license . 
	mail me <naoki@kuwamori.com> .

/etc/servicese game_rpgrpg_chatrpg_clientΥȥɬפ롣
*/
static char cvs_id[] = "$Id: libnet.c,v 0.63 2004/05/31 10:17:49 yamakawa Exp $";


/*
Υ饤֥礭ä

ͥåȥ̿

ͭ

ʬޤ
*/


#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <ctype.h>
#include "libnet.h"

/* fdơ֥δ˻Ѥѿ */
static int LP_fdinitflag = 0;	/* fdơ֥뤬ѤߤǤ뤳Ȥ򼨤ե饰 */
static int LP_fdnum = 0; 	/* ߴƤfdθĿ */
/* fdơ֥(ưfdκʬưŪ˳ݤ롣*/
static int * LP_FDS = NULL;		/* fd */
static int * LP_IDS = NULL;
static int * LP_FDTYPE = NULL;
static int * LP_IDSR = NULL;
static struct sockaddr_in * LP_UDPAD = NULL;
struct pollfd *s_Poll = NULL;	/* poll()ؿ */

struct rlimit fdlim;
#undef LIBNET_DBG_DEBUG
#define  LIBNET_DBG_DEBUG 1000
#define  LIBNET_DBG_DEBUG2 2000

/*local function place*/
static int _serveropen(int type ,   char * service_name, int polltype );
static int _tcp_client_open( char * hostname , char * service_name );
static int _tcp_client_open_port( char * hostname , int port );
static int read_packet (int FD     , int requestlen , int *read_len , char * buf , int bufsizei , int timeout);

#define LP_perror( msg ) LP_log( LIBNET_DBG_ERR, "%s: %s\n", msg, strerror( errno ) )

/**************************************************************************
 *     
 *                 ѥ»Хåؿ
 *
			:()
				ѥפȤʤɤ˸ƤӽФ
				Хåؿ
				äˤʤˤ⤷ʤǵ

			:
				ʤ

			:
				ʤ
*/
static      void brakepipe(int data);

/*
 *             FD¸߳ǧؿ

    ()
        ǡǡ١ˤΣƣĤäƤ뤫ǧ
        ơΥȥ꡼ֹ֤

    :
        int fd      I   Ĵ٤ƣ

    :
      0<
          䥨ȥ꡼ֹ
        0>
          顼
                LIBNET_STAT_NOFDȥ꡼¸ߤʤ
*/
static  int test_fd(int fd );

/**************************************************************************
		FDϿؿ

    :()
        FDǡ١˿ȥä
        Υȥֹ֤
        Ρȥξˣ򥪡ץ󤷤
        ƣĤ롣

    
        ʤ

    ͡
        Ƥƣĥǡ١ȥ
*/

static int getfdnewentry(void);

/**************************************************************************
		ǡ١ؿ
    
        ǡ١
        ǽΰƤӽФ줿˽򤷤Ƥʹ
        ˽򤹤Ȥ̤δؿƤӽФ

    
        ʤ

*/
static int clear_fddatabase(void);



static void brakepipe(int data){
	LP_log (LIBNET_DBG_DEBUG ,"libnet:get broken pipe\n");
	/*ïΥʥ뤫Ϥ狼ʤҤȤޤfʤˤ⤷ʤ*/
	/*Υ顼Ǥ롣*/

	return;
 
}	 

void  LP_childdeth(int data){
int status;
	LP_log(LIBNET_DBG_DEBUG , "libnet:Is child prosess die?\n");
	while (waitpid (-1,&status,WNOHANG)>0){
		if (signal (SIGCHLD , LP_childdeth) == SIG_ERR){/*ʥľ*/
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal error\n");
			exit (1);
		}
	}
	return ;
}

void LP_endproc(int data){
	int cnt;
 
	/*줬ʤȡåȤĤäƤޤʥФ
	äƤ⥽åȤХɤǤʤ*/
	/*Ǥ⤦ޤʤ*/
	LP_log(LIBNET_DBG_DEBUG , "libnet:Got end signal or got end request \n");
	/*˻ҥץʤɤ˽λΤｪλƱƤ餦Τɤ*/

	/*ƤΣƣĤĤ*/
	for (cnt = 0 ; cnt < LP_fdnum ; cnt ++){
		if (LP_FDS[cnt] == 0)continue;
		LP_closefd (LP_FDS[cnt]);
	}
	if (LP_FDS != NULL){free (LP_FDS);LP_FDS= NULL;}
	if (s_Poll != NULL){free (s_Poll);s_Poll= NULL;}
	if (LP_IDS != NULL){free (LP_IDS);LP_IDS= NULL;}
	if (LP_FDTYPE != NULL){free (LP_FDTYPE);LP_FDTYPE= NULL;}
	if (LP_IDSR != NULL){free (LP_IDSR);LP_IDSR= NULL;}
	if (LP_UDPAD != NULL){free (LP_UDPAD);LP_UDPAD= NULL;}
	
	LP_shm_detach();
	LP_mallclose();
	#if 0
	exit (1);
	#endif
}
/*
	ƣĤơ֥¸ߤ뤫ǧ롣
*/
static int test_fd(int fd ){
int cnt;

	/*for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){*/
	for (cnt = 0 ; cnt < LP_fdnum ; cnt ++){
		if (LP_FDS[cnt] == fd){
			return cnt;
		}
	}
	return LIBNET_STAT_NOFD;
}

/*ƣĤΥǡ١餢Ƥõ֤*/
static int getfdnewentry(){
int cnt;
	/*ޤƤʤä*/
	clear_fddatabase();
	
	/*ƤȤܤ*/
	for (cnt = 0 ; cnt < LP_fdnum ; cnt ++ ){
		if (LP_FDS[cnt] == 0){
			LP_IDS[cnt] = (int)NULL;
			LP_FDTYPE[cnt] = (int)NULL;
			LP_IDSR[cnt] = (int)NULL;
    		LP_UDPAD[cnt].sin_family = (int)NULL;
    		LP_UDPAD[cnt].sin_port = (int)NULL;

			return cnt;
		}
	}
	/*Ǥ˳ƤȤ̵ȤϿΰ֤*/
	LP_IDS[LP_fdnum]= 0;
	LP_FDTYPE[LP_fdnum]=0;
	LP_IDSR[LP_fdnum]=0;
	LP_UDPAD[LP_fdnum].sin_family = (int)NULL;
	LP_UDPAD[LP_fdnum].sin_port = (int)NULL;
	LP_fdnum++;
	/*ƣĿƥΥߥåȤˤʤäϥ顼֤*/
	if (LP_fdnum >= fdlim.rlim_cur ){
		return LIBNET_STAT_CANTCREATEFD;
	}
	return (LP_fdnum-1);
}

/*ΣƣĤ򥯥ơǡ١*/
void	LP_closefd(int FD){
int cnt;

	for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
		if (LP_FDS[cnt] == FD){
			close (LP_FDS[cnt]);
			LP_FDS[cnt] = (int)NULL;
			LP_IDS[cnt] = (int)NULL;
			LP_FDTYPE[cnt] = (int)NULL;
			LP_IDSR[cnt] = (int)NULL;
			LP_UDPAD[cnt].sin_family = (int)NULL;
			LP_UDPAD[cnt].sin_port = (int)NULL;
		}
	}
}

/*ƤΣƣĤ򥯥
ơǡ١⥯ꥢ
Ƴݤ*/

void LP_fd_allclose(){
int cnt;
	for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
		if (LP_FDS[cnt] != 0){
			close (LP_FDS[cnt]);
			LP_FDS[cnt] = ( int )NULL;
			LP_IDS[cnt] = ( int )NULL;
			LP_FDTYPE[cnt] = ( int )NULL;
			LP_IDSR[cnt] = ( int )NULL;
			LP_UDPAD[cnt].sin_family = (int)NULL;
			LP_UDPAD[cnt].sin_port = (int)NULL;
		}
	}
	LP_fdinitflag = 0;/*ΰƳݤΤΥե饰򥯥ꥢ*/
	/*ݤ줿򥯥ꥢ*/
	if (LP_FDS != NULL){free (LP_FDS);LP_FDS= NULL;}
	if (s_Poll != NULL){free (s_Poll);s_Poll= NULL;}
	if (LP_IDS != NULL){free (LP_IDS);LP_IDS= NULL;}
	if (LP_FDTYPE != NULL){free (LP_FDTYPE);LP_FDTYPE= NULL;}
	if (LP_IDSR != NULL){free (LP_IDSR);LP_IDSR= NULL;}
	if (LP_UDPAD != NULL){free (LP_UDPAD);LP_UDPAD= NULL;}
	/*δؿͤʤΤͤϸʤ*/
	/*clear_fddatabase();*/

}

/*ƤΣƣĤ򥯥
ơǡ١⥯ꥢ
Ƴݤ*/

void LP_fd_allclosewithout(int FD){
int cnt;
	for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
		if (LP_FDS[cnt] == FD)continue;
		if (LP_FDS[cnt] != 0){
			close (LP_FDS[cnt]);
			LP_FDS[cnt] = ( int )NULL;
			LP_IDS[cnt] = ( int )NULL;
			LP_FDTYPE[cnt] = ( int )NULL;
			LP_IDSR[cnt] = ( int )NULL;
			LP_UDPAD[cnt].sin_family = (int)NULL;
			LP_UDPAD[cnt].sin_port = (int)NULL;
		}
	}
}

/*ǡ١
ǽΰ󤷤򤷤ʤΤǤޤäˤˤ
LP_fd_allcloseȤɬפ*/

static int clear_fddatabase(){
int cnt;
	
	/*ǽλϣƣĤޤƽ򤹤*/
	if (LP_fdinitflag==0){
		LP_log ( LIBNET_DBG_DEBUG , "libnet:init net lib\n");
		/*ƣĤκ򥷥ƥफåȤ*/
		getrlimit(RLIMIT_NOFILE , & fdlim);
		LP_log ( LIBNET_DBG_DEBUG , "libnet:max file open [%d]\n" , fdlim.rlim_cur);
		/*ǡ١ݤƽ*/
		if (LP_FDS == NULL )LP_FDS = malloc( sizeof (int) * fdlim.rlim_cur );
		if (LP_FDS == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error [%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
			LP_FDS[cnt] = 0;
		}
		/*ѤΣǡ١ݤƽ*/
		if (s_Poll == NULL )s_Poll = malloc( sizeof (int) * fdlim.rlim_cur );
		if (s_Poll == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error s_Poll[%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		bzero (s_Poll , sizeof (int) * fdlim.rlim_cur);
		/*񤭽ФѤΣֹ̤*/
		if (LP_IDS == NULL )LP_IDS = malloc( sizeof (int) * fdlim.rlim_cur );
		if (LP_IDS == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error [%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
			LP_IDS[cnt] = 0;
		}
		/*䥿פ*/
		if (LP_FDTYPE == NULL )LP_FDTYPE = malloc( sizeof (int) * fdlim.rlim_cur );
		if (LP_FDTYPE == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error [%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
			LP_FDTYPE[cnt] = 0;
		}
		/*ɤ߹ߤ褦Σֹ̤*/
		if (LP_IDSR == NULL )LP_IDSR = malloc( sizeof (int) * fdlim.rlim_cur );
		if (LP_IDSR == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error [%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
			LP_IDSR[cnt] = 0;
		}
		/*udp б*/
		if (LP_UDPAD == NULL )LP_UDPAD = malloc( sizeof (struct sockaddr_in) * fdlim.rlim_cur );
		if (LP_UDPAD == NULL){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:malloc error [%d]\n" , errno );
			return LIBNET_STAT_MALLOCERR;
		}
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
			LP_UDPAD[cnt].sin_family = (int)NULL;
			LP_UDPAD[cnt].sin_port = (int)NULL;
		}
		LP_fdnum = 0;
		/*ѥפ»ƥХåؿ򥻥åȤ롣*/
		if (signal (SIGPIPE , brakepipe) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
		/*ҥץȤӲΤɤ
			ҥץȤȤϥ(wait3)ư
			Ʊˡ̵¥֥åδ⤢ΤǤϼʤ*/
		if (signal (SIGCHLD , LP_childdeth) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
		/*λʥ˥åȤ򥯥򤹤롢Ĥεư
		åȤΥХɤ򤹤ˤǤ褦ˡʤʤɤС*/
#if 0
		if (signal (SIGHUP , LP_endproc) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
		if (signal (SIGTERM , LP_endproc) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
		if (signal (SIGQUIT , LP_endproc) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
		if (signal (SIGINT , LP_endproc) == SIG_ERR){
			LP_log ( LIBNET_DBG_DEBUG , "libnet:Set signal errror\n");
			exit (1);
		}
#endif
		LP_fdinitflag = 1;
		return (LIBNET_STAT_OK);
	}
	return LIBNET_STAT_ERR;
}

/*ƣĥǡ١˥ݡ󥰤볰ƣĤϿ*/
int LP_addRawPollFD(int FD){
int ent;
	LP_log (LIBNET_DBG_DEBUG , "LP_addRawPollFD:set RAW fd[%d]\n" ,FD );
	if (test_fd(FD)!=LIBNET_STAT_NOFD){
		LP_log ( LIBNET_DBG_DEBUG , "libnet:The FD aleady seted\n");
		return LIBNET_STAT_FDALREADYSET;
	}
	ent = getfdnewentry();

	LP_FDS[ent]=FD;
	LP_IDS[ent] = -1;
	LP_FDTYPE[ent] = POLLTYPE_RAW;
	LP_IDSR[ent] = -1;

	return LIBNET_STAT_OK ;
}

/*ФȤƥåȤ򥪡ץ󤹤*/
int LP_RawServerOpen(int type ,	char * service_name ){

	return _serveropen (type,service_name,POLLTYPE_RAW);
}
/*ФȤƥåȤ򥪡ץ󤹤*/
int LP_serveropen(int type ,	char * service_name ){
	return _serveropen (type,service_name,POLLTYPE_LAUREL);

}	
static int _serveropen(int type ,	char * service_name, int polltype ){

struct servent *serv=NULL;
struct sockaddr_in		saddrt;
struct sockaddr_un		saddru;
int newfdent;

	/*ǽλϣƣĤޤƽ򤹤*/
	LP_log (100 , "LP_serveropen:open server with servicename[%d][%s]\n" , type , service_name);
	if (LP_fdinitflag==0){
		clear_fddatabase();
	}

	if (strlen (service_name) < 3)return LIBNET_STAT_ERR;
	/*åȥפ˥ååȤξ礫ĥå̾Ȥ*/

	if (type == AF_UNIX){
		newfdent = getfdnewentry();
		/*åȤ롣ΥåȤUNIXɥᥤǡȥ꡼෿åȡ*/
		if ((LP_FDS[newfdent] = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
			LP_perror("socket");
			LP_log(LIBNET_DBG_DEBUG,"libnet:make socket with UNIX domain and STREAM type\n" );
			return LIBNET_STAT_MAKESOCKETERR;
		}
		LP_log(200,"libnet:if dont set 0 in saddr it may error on bind()\n" );

		/*saddrȤ0ˤƤʤȡbind()ǥ顼뤳Ȥ*/
		bzero((char *)&saddru, sizeof(saddru));
		LP_log(LIBNET_DBG_DEBUG,"libnet:set socket name\n" );


		saddru.sun_family = AF_UNIX;
		strcpy(saddru.sun_path, service_name);
	
		LP_log(LIBNET_DBG_DEBUG,"libnet:bind socket address\n" );
		/*åȤ˥ɥ쥹Хɤ롣bind()Ԥʤ褦ǽunlink()
		ѤơåȤбեõ롣*/
		unlink(service_name);
		if (bind(LP_FDS[newfdent], (struct sockaddr *)&saddru,
				 sizeof(saddru.sun_family) + strlen(service_name)) < 0){
			LP_perror("bind");
			LP_log(LIBNET_DBG_DEBUG,"libnet:bind error %s\n" , strerror(errno) );
			close (LP_FDS[newfdent]);
			return LIBNET_STAT_SOCKETBINDERR;
		}
	
		LP_log(LIBNET_DBG_DEBUG,"libnet:listen to socket\n" );
		/*listen򥽥åȤФȯԤ*/
		if (listen(LP_FDS[newfdent], 1) < 0) {
			LP_perror("listen");
			LP_log(LIBNET_DBG_DEBUG,"libnet:listen error [%s]\n"	 , strerror(errno) );
			return LIBNET_STAT_LISTENERR;
		}
		if (polltype == POLLTYPE_RAW){
			LP_IDS[newfdent] = -1;
			LP_FDTYPE[newfdent] = POLLTYPE_URAWSERV;
			LP_IDSR[newfdent] = -1;
		}else{
			LP_FDTYPE[newfdent] = POLLTYPE_USERV;
		}
		return LP_FDS[newfdent];

	}else if (type == AF_INET){
		int cnt;
		newfdent = getfdnewentry();
		/*TCPåȤξ*/
		/* åȤ̾Ƥ*/
		/*ϣ𥽥åȤѤ롣*/
		saddrt.sin_family = AF_INET;
		saddrt.sin_addr.s_addr = INADDR_ANY;

		for (cnt=0;cnt<strlen(service_name);cnt++){
			int testd;
			testd = service_name[cnt];
			if (!isdigit(testd)){

				/*ӥ̾ݡֹ롣*/
				if ( (serv = getservbyname( service_name , "tcp" ) ) == NULL){
					LP_perror ("getservbyname");
					LP_log (LIBNET_DBG_DEBUG , "libnet:getservbyname %s error\n" , getservbyname);
					return LIBNET_STAT_GETPORTERR ;
				}
				saddrt.sin_port = serv->s_port;
				break;
			}else{
				saddrt.sin_port = htons((short)atoi(service_name));
			}
		}

		/*åȤ롣ΥåȤUNIXɥᥤǡȥ꡼෿åȡ*/
		if ((LP_FDS[newfdent] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			LP_perror("socket");
			LP_log (LIBNET_DBG_DEBUG , "libnet:socket error : socket make error \n" );
			return LIBNET_STAT_MAKESOCKETERR;
		}

		/*åȤ˥ɥ쥹Хɤ롣*/
		if (bind(LP_FDS[newfdent], (struct sockaddr *)&saddrt, sizeof(saddrt)) < 0){
			LP_perror("bind");
			LP_log ( 200 , "libnet:socket error : socket bind error port [%d]\n" , ntohs( saddrt.sin_port ) );
			close (LP_FDS[newfdent]);
			return LIBNET_STAT_SOCKETBINDERR;
		}

		/* listen򥽥åȤФȯԤ*/
		if (listen(LP_FDS[newfdent], 1) < 0) {
			LP_perror("listen");
			LP_log (LIBNET_DBG_DEBUG , "libnet:listen socket error\n");
			return LIBNET_STAT_LISTENERR;
		}
		if (polltype == POLLTYPE_RAW){
			LP_IDS[newfdent] = -1;
			LP_FDTYPE[newfdent] = POLLTYPE_TRAWSERV;
			LP_IDSR[newfdent] = -1;
		}else{
			LP_FDTYPE[newfdent] = POLLTYPE_TSERV;
		}
		LP_log(LIBNET_DBG_DEBUG , " libnet:success init \n");
		return LP_FDS[newfdent];
	}else if(type == LIBNET_UDP) {
		int cnt;
		newfdent = getfdnewentry();
		/*TCPåȤξ*/
		/* åȤ̾Ƥ*/
		/*ϣ𥽥åȤѤ롣*/
		saddrt.sin_family = AF_INET;
		saddrt.sin_addr.s_addr = INADDR_ANY;
		for (cnt=0;cnt<strlen(service_name);cnt++){
			int testd;
			testd = service_name[cnt];
			if (!isdigit(testd)){

				/*ӥ̾ݡֹ롣*/
				if ( (serv = getservbyname( service_name , "udp" ) ) == NULL){
					LP_perror ("getservbyname");
					LP_log (LIBNET_DBG_DEBUG , "libnet:getservbyname %s 顼\n" , getservbyname);
					return LIBNET_STAT_GETPORTERR ;
				}
				saddrt.sin_port = serv->s_port;
				break;
			}else{
				saddrt.sin_port = htons((short)atoi(service_name));
			}
		}

		/*åȤ롣ΥåȤIPɥᥤǡDGRAM åȡ*/
		if ((LP_FDS[newfdent] = socket(AF_INET, SOCK_DGRAM , 0)) < 0) {
			LP_perror("socket");
			LP_log (LIBNET_DBG_DEBUG , "libnet:socket error : make socket error\n" );
			return LIBNET_STAT_MAKESOCKETERR;
		}

		/*åȤ˥ɥ쥹Хɤ롣*/
		if (bind(LP_FDS[newfdent], (struct sockaddr *)&saddrt, sizeof(saddrt)) < 0){
			LP_perror("bind");
			LP_log ( LIBNET_DBG_DEBUG , "libnet:socket error : socket bind error port [%d]\n" , ntohs( saddrt.sin_port ) );
			close (LP_FDS[newfdent]);
			return LIBNET_STAT_SOCKETBINDERR;
		}

		LP_log(LIBNET_DBG_DEBUG , " libnet:UDP sucsess init\n");
		if (polltype == POLLTYPE_RAW){
			LP_IDS[newfdent] = -1;
			LP_FDTYPE[newfdent] = POLLTYPE_RAW;
			LP_IDSR[newfdent] = -1;
		}else{
			LP_FDTYPE[newfdent] = POLLTYPE_LAUREL;
		}
		return LP_FDS[newfdent];

	}else{
		LP_log(LIBNET_DBG_DEBUG , " libnet:You miss SOCtype . didnt open server yet[%d]\n" , AF_INET);

	}
	
	return (LIBNET_STAT_ERR);
}

/*饤ȤȤƣϩ򥪡ץ󤹤*/
int LP_tcp_client_open( char * hostname , char * service_name ){
int FD;
	FD = _tcp_client_open( hostname , service_name );
	if (FD<=0){
		return FD;
	}
	/*ңУǤȤƤ̿򤷤¾Υץफ³ǤʤȤΤ餻*/
	if (write (FD , LIBNET_STR_ACCEPT , strlen(LIBNET_STR_ACCEPT))< 0){
		close (FD);
		LP_FDS[test_fd(FD)] = 0;
		return LIBNET_STAT_CONNECTERR;
	}
	LP_FDTYPE[test_fd(FD)] = POLLTYPE_LAUREL;
	return FD;

}

/*饤ȤȤƣϩ򥪡ץ󤹤(Raw⡼)*/
int LP_tcp_raw_client_open( char * hostname , char * service_name ){
int FD;
	FD = _tcp_client_open( hostname , service_name );
	if (FD<=0){
		return FD;
	}
	LP_FDTYPE[test_fd(FD)] = POLLTYPE_RAW;
	return FD;

}

/*饤ȤȤƣϩ򥪡ץ󤹤*/
static int _tcp_client_open( char * hostname , char * service_name ){
	int FD;
	struct servent *serv;
	struct hostent *hp;
	struct sockaddr_in	  addr;

	if (LP_fdinitflag==0){
		clear_fddatabase();
	}
	/*åȤκ*/
	if ((FD = socket(AF_INET, SOCK_STREAM, 0)) < 0) {	
		LP_perror("socket");
		LP_log (LIBNET_DBG_DEBUG , "libnet:error make socket\n");
		return LIBNET_STAT_MAKESOCKETERR;
	}

	 /* addrȤ0ˤƤʤȡbind()ǥ顼뤳Ȥ*/
	bzero((char *)&addr, sizeof(addr));


	 /* åȤ̾Ƥ*/
	if ((hp = gethostbyname(hostname)) == NULL) {
		LP_perror("gethostbyname");
		LP_log (LIBNET_DBG_DEBUG , "libnet:miss socket name \n");
		return LIBNET_STAT_SETHOSTNAMEERR;
	}
	bcopy(hp->h_addr, &addr.sin_addr, hp->h_length);
	addr.sin_family = AF_INET;

	/*ӥ̾ݡֹ롣*/
	{
		int testd;
		/*ǽΣʸܤ򻲾Ȥƿʸ󤫤ѤƤ뤬ɤ*/
		testd = service_name[0];
		if (!isdigit(testd)){

			/*ӥ̾ݡֹ롣*/
			if ( (serv = getservbyname( service_name , "tcp" ) ) == NULL){
				LP_perror ("getservbyname");
				LP_log (LIBNET_DBG_DEBUG , "libnet:libnet:getservbyname %s error\n" , getservbyname( service_name , "tcp"));
				return LIBNET_STAT_GETPORTERR ;
			}
			addr.sin_port = serv->s_port;
			LP_log (LIBNET_DBG_DEBUG ,"libnet:param port[%d]\n" , serv->s_port);
		}else{
			addr.sin_port = htons((short)atoi(service_name));
		}
	}


	/*СȤ³ߤ롣*/
	if (connect(FD, (struct sockaddr *)&addr, sizeof(addr)) < 0){
		LP_perror("connect");
		LP_log (LIBNET_DBG_DEBUG , "libnet:Try open socket fault [%d]\n" , errno);
		close(FD);
		return LIBNET_STAT_CONNECTERR;
	}
	/*ץ󤷤ƣĤȤ*/
	LP_FDS[getfdnewentry()] = FD;
	
	return FD;
}

int LP_udp_client_open( char * hostname , char * service_name ){
struct servent *serv;
unsigned short port = 0;

/*ӥ̾ݡֹ롣*/
	{
		int testd;
		/*ǽΣʸܤ򻲾Ȥƿʸ󤫤ѤƤ뤬ɤ*/
		testd = service_name[0];
		if (!isdigit(testd)){

			/*ӥ̾ݡֹ롣*/
			if ( (serv = getservbyname( service_name , "tcp" ) ) == NULL){
				LP_perror ("getservbyname");
				LP_log (LIBNET_DBG_DEBUG , "libnet:getservbyname %s error\n" , getservbyname);
				return LIBNET_STAT_GETPORTERR ;
			}
			port = serv->s_port;
			LP_log (LIBNET_DBG_DEBUG ,"param port[%d]\n" , serv->s_port);
		}else{
			port = htons((short)atoi(service_name));
		}
	}

	return LP_udp_client_open_port ( hostname , ntohs(port));

}
int LP_udp_client_open_port( char * hostname , int port ){
	int FD , tmp;
	struct hostent *hp;
	struct sockaddr_in	  addr;

	if (LP_fdinitflag==0){
		clear_fddatabase();
	}
	/*åȤκ*/
	if ((FD = socket(AF_INET, SOCK_DGRAM , 0)) < 0) {	
		LP_perror("socket");
		LP_log (LIBNET_DBG_DEBUG , "libnet:miss make socket\n");
		return LIBNET_STAT_MAKESOCKETERR;
	}

	 /* addrȤ0ˤƤʤȡbind()ǥ顼뤳Ȥ*/
	bzero((char *)&addr, sizeof(addr));

	 /* åȤ̾Ƥ*/
	if ((hp = gethostbyname(hostname)) == NULL) {
		LP_perror("No such host");
		LP_log (LIBNET_DBG_DEBUG , "libnet:input socket name miss\n");
		return LIBNET_STAT_SETHOSTNAMEERR;
	}

	/*ץ󤷤ƣĤȤ*/
	tmp=getfdnewentry();
	LP_FDS[tmp] = FD;
	bcopy(hp->h_addr, &LP_UDPAD[tmp].sin_addr, hp->h_length);
	LP_UDPAD[tmp].sin_family = AF_INET;
	LP_UDPAD[tmp].sin_port = htons(port);
	
	return FD;
}

/*饤ȤȤƣϩ򥪡ץ󤹤*/
int LP_tcp_client_open_port( char * hostname , int port ){
int FD;
	FD = _tcp_client_open_port( hostname , port );
	if (FD<=0){
		return FD;
	}
	/*ңУǤȤƤ̿򤷤¾Υץफ³ǤʤȤΤ餻*/
	if (write (FD , LIBNET_STR_ACCEPT , strlen(LIBNET_STR_ACCEPT))< 0){
		close (FD);
		LP_FDS[test_fd(FD)] = 0;
		return LIBNET_STAT_CONNECTERR;
	}
	LP_FDTYPE[test_fd(FD)] = POLLTYPE_LAUREL;
	return FD;

}

/*饤ȤȤƣϩ򥪡ץ󤹤(Raw⡼)*/
int LP_tcp_raw_client_open_port( char * hostname , int port ){
int FD;
	FD = _tcp_client_open_port( hostname , port );
	if (FD<=0){
		return FD;
	}
	LP_FDTYPE[test_fd(FD)] = POLLTYPE_RAW;
	return FD;

}

int _tcp_client_open_port( char * hostname , int port ){
	int FD;
/*	struct servent *serv;*/
	struct hostent *hp;
	struct sockaddr_in	  addr;

	if (LP_fdinitflag==0){
		clear_fddatabase();
	}
	/*åȤκ*/
	if ((FD = socket(AF_INET, SOCK_STREAM, 0)) < 0) {	
		LP_perror("socket");
		LP_log (LIBNET_DBG_DEBUG , "libnet:miss make socket\n");
		return LIBNET_STAT_MAKESOCKETERR;
	}

	 /* addrȤ0ˤƤʤȡbind()ǥ顼뤳Ȥ*/
	bzero((char *)&addr, sizeof(addr));

	 /* åȤ̾Ƥ*/
	if ((hp = gethostbyname(hostname)) == NULL) {
		LP_perror("No such host");
		LP_log (LIBNET_DBG_DEBUG , "libnet:miss input socket name\n");
		return LIBNET_STAT_SETHOSTNAMEERR;
	}
	bcopy(hp->h_addr, &addr.sin_addr, hp->h_length);
	addr.sin_family = AF_INET;
	addr.sin_port = htons (port);
	LP_log (LIBNET_DBG_DEBUG ,"param port[%d]\n" , port);


	/*СȤ³ߤ롣*/
	if (connect(FD, (struct sockaddr *)&addr, sizeof(addr)) < 0){
		LP_perror("connect");
		LP_log (LIBNET_DBG_DEBUG , "libnet:try server connection [%d]\n" , errno);
		close(FD);
		return LIBNET_STAT_CONNECTERR;
	}
	/*ץ󤷤ƣĤȤ*/
	LP_FDS[getfdnewentry()] = FD;
	
	return FD;
}

/*Υ˥ååȤΥ饤³򤹤*/
int LP_usoc_client_open(char * socketname){
	int FD;
	struct sockaddr_un	  addr;

	/*ƤΥץλϥǡ١*/
	if (LP_fdinitflag==0){
		clear_fddatabase();
	}
	if (strlen(socketname)>MAXPATHLEN){
		LP_log(LIBNET_DBG_DEBUG,"libnet:sock name over MAXPATHLEN\n");
		return LIBNET_STAT_MAKESOCKETERR;
	}
	LP_log(LIBNET_DBG_DEBUG,"libnet:connect to child process[%s] \n" , socketname);
	/*åȤ롣ΥåȤUNIXɥᥤǡȥ꡼෿åȡ*/
	if ((FD = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
		LP_perror("socket");
		LP_log(LIBNET_DBG_DEBUG , "libnet:connecttol:socket error [%s] [%s]\n" ,strerror( errno) , socketname );
		return LIBNET_STAT_MAKESOCKETERR;
	}
	LP_log(LIBNET_DBG_DEBUG,"libnet:make socket\n" );

	/*addrȤ0ˤƤʤȡbind()ǥ顼뤳Ȥ*/
	bzero((char *)&addr, sizeof(addr));

	/*åȤ̾Ƥ*/
	LP_log(LIBNET_DBG_DEBUG,"libnet:input sock name\n" );
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, socketname);

	/*СȤ³ߤ롣*/
	LP_log(LIBNET_DBG_DEBUG,"libnet:try server open\n" );
	if (connect(FD, (struct sockaddr *)&addr,
			 sizeof(addr.sun_family) + strlen(socketname)) < 0){
		int cnt;
		LP_perror("connect");
		LP_log(LIBNET_DBG_DEBUG , "libnet:connecttol:connect error [%d] [%s]\n" , errno , socketname );
		sleep (1);
		/*ԤȤϥȥ饤򤫤ƱưƤΤǽޤ⤷ʤ*/
		for (cnt = 0 ; cnt < 5 ; cnt++){
			if (connect(FD, (struct sockaddr *)&addr,
			 sizeof(addr.sun_family) + strlen(socketname)) < 0){
				LP_perror("connect");
				LP_log(LIBNET_DBG_DEBUG , "libnet:connecttol:connect error [%d] [%s]\n" ,
									errno , socketname );
				sleep(1);
			}else{
				break;
			}
		}
		if (cnt > 4)return (LIBNET_STAT_CONNECTERR);
	}
	LP_log(LIBNET_DBG_DEBUG,"libnet:sucess conneck to client\n" );

	LP_FDS[getfdnewentry()] = FD;
	return FD;
}



/*ңУǴĶȤäƤ򤹤*/
int LP_send_all(char * command ,  char * senddata , int len){
int cnt;

	for (cnt = 1 ; cnt < LP_fdnum ; cnt ++){
		LP_log(LIBNET_DBG_DEBUG , "libnet:LP_send_all: [%d]-[%d]\n" , cnt , LP_FDS[cnt]);
		if (LP_FDS[cnt] > 0){
			LP_send(LP_FDS[cnt],command,senddata,len);
		}
	}
	return LIBNET_STAT_NOFD;

}
/*UDPˤ*/
int LP_send_udp(int FD ,char * command ,  char * senddata , int len){
/*int stat;*/
int cnt;
int ret ;
libnet_send_st send_st;	

	if (LP_fdinitflag==0){
		clear_fddatabase();
	}

	LP_log(LIBNET_DBG_DEBUG+100 , "libnet:LP_send_udp FD[%d]\n",FD);
	if (FD == 0){
		LP_log(LIBNET_DBG_DEBUG , "libnet: Need FD nomber\n");
		return LIBNET_STAT_NOFD;
	}
	if (command == NULL ){
		return LIBNET_STAT_EFAULT;
	}
	if (senddata == NULL){
		len = 0;
	}
	/*udp ΣƣĤȽꤹ*/
	if ( LP_UDPAD[test_fd(FD)].sin_port == (int)NULL){
		LP_log(LIBNET_DBG_DEBUG , "libnet: this FD not for UDP\n");
		return LIBNET_STAT_EFAULT;
	}
	/*ΣƣĤϿƤ뤫γǧ*/
	if ((cnt = test_fd(FD))< 0)return LIBNET_STAT_NOFDENT;
	/*ѥåȤȤ*/
	sprintf (send_st.head , LIBNET_STR_PHEADER);/*ңУǥѥåȤǤ뤳Ȥ򼨤ʸ򤤤*/
	/*ץΣɣ*/
	send_st.from_pid=htonl(getpid());
	/*ɣġ꤬Ϣ³ǧ뤿*/
	send_st.ID=htonl(LP_IDS[cnt]++);
	send_st.length=htonl(len);
	send_st.status = 0;/*ơ*/
	memset (send_st.command , 0 , COMMANDLEN);
	memcpy (send_st.command , command , COMMANDLEN);
	/*إåΰ*/
	ret =sendto(FD,  &send_st , sizeof (libnet_send_st), 0, (struct sockaddr *)&LP_UDPAD[test_fd(FD)], sizeof(LP_UDPAD[test_fd(FD)]));

	if (ret < 0){
		LP_log(LIBNET_DBG_DEBUG , "libnet: head fault send message errno[%n]\n" , errno);
		if (errno == EPIPE ){
			LP_log(LIBNET_DBG_DEBUG , "libnet:got socket close\n");
			LP_closefd(FD);
		}
		send_st.status = LIBNET_STAT_SENDERR;
		return LIBNET_STAT_SENDERR;
	}
	/*ǡΰ*/
	if (senddata != NULL){
		ret =sendto(FD,  senddata , len , 0, (struct sockaddr *)&LP_UDPAD[test_fd(FD)], sizeof(LP_UDPAD[test_fd(FD)]));
		if (ret < 0){
			LP_log(LIBNET_DBG_DEBUG , "libnet:fault send message errno[%n]\n" , errno);
			if (errno == EPIPE ){
				LP_log(LIBNET_DBG_DEBUG , "libnet:got socket close \n");
				LP_closefd(FD);
			}
			send_st.status = LIBNET_STAT_HEADSENDERR;
			return LIBNET_STAT_HEADSENDERR;
		}
	}
	send_st.status = ret;
	return (LIBNET_STAT_OK);
}

/*ңУǴĶȤäƤ򤹤*/
int LP_send(int FD ,char * command ,  char * senddata , int len){
/*int stat;*/
int cnt;
int ret ;
libnet_send_st send_st;	

	if (LP_fdinitflag==0){
		clear_fddatabase();
	}

	if (FD == 0){
		LP_log(LIBNET_DBG_DEBUG , "libnet:need FD nom tu operate\n");
		return LIBNET_STAT_NOFD;
	}
	if (command == NULL ){
		return LIBNET_STAT_EFAULT;
	}
	if (senddata == NULL){
		len = 0;
	}
	/*գģХåȤäգģ*/
    if ( LP_UDPAD[test_fd(FD)].sin_port != (int)NULL){
		return LP_send_udp (FD,command,senddata,len);
	}

	/*ΣƣĤϿƤ뤫γǧ*/
	if ((cnt = test_fd(FD))< 0)return LIBNET_STAT_NOFDENT;
	/*ѥåȤȤ*/
	sprintf (send_st.head , LIBNET_STR_PHEADER);/*ңУǥѥåȤǤ뤳Ȥ򼨤ʸ򤤤*/
	send_st.from_pid=htonl(getpid());
	/*ɣġ꤬Ϣ³ǧ뤿*/
	send_st.ID=htonl(LP_IDS[cnt]++);
	send_st.length=htonl(len);
	send_st.status = 0;/*ơ*/
	
	memset (send_st.command , 0 , COMMANDLEN);
	memcpy (send_st.command , command , COMMANDLEN);
	/*إåΰ*/
	ret = write ( FD , &send_st , sizeof (libnet_send_st));
	if (ret < 0){
		LP_log(LIBNET_DBG_DEBUG , "libnet:head faulr send errno[%n]\n" , errno);
		if (errno == EPIPE ){
			LP_log(LIBNET_DBG_DEBUG , "libnet:got socket close \n");
			LP_closefd(FD);
			return LIBNET_STAT_LENGTHZERO;
		}
		send_st.status = LIBNET_STAT_SENDERR;
		return LIBNET_STAT_SENDERR;
	}
	/*ǡΰ*/
	if (senddata != NULL){
		ret = write ( FD ,senddata , len);
		if (ret < 0){
			LP_log(LIBNET_DBG_DEBUG , "libnet:fault send errno[%n]\n" , errno);
			if (errno == EPIPE ){
				LP_log(LIBNET_DBG_DEBUG , "libnet:got socket close\n");
				LP_closefd(FD);
				return LIBNET_STAT_LENGTHZERO;
			}
			send_st.status = LIBNET_STAT_HEADSENDERR;
			return LIBNET_STAT_HEADSENDERR;
		}
	}
	send_st.status = ret;
	return (LIBNET_STAT_OK);
}


/**********************************

		
				ѥåȥإåɡNRPGHEAD
				ѥåʬ
						  ĹãʤϣƣĤФơ
						ǽ䤤碌
						ǽǤʤȤϥ顼֤
				ѥåȹή
						  ѥåȥإå򻲹ͤ˰ĤΥѥåȤ
						礭ȽǤơ꥿󤹤롢
						  ݡ󥰻ϥݡ󥰤餺ˡ
						ѥåȽ¹Ԥʣإå꥿
				ѥåȴ
						ѥåȤˤɣĤޤޤƤ롢Τᡣ
						ΣɣĤϢ³ƤмϢ³Ƥȹͤ뤬
						ä˽ϹԤʤڤͤˤϥѥåȴ֤
						饤֥ǤνϤʤ
						饤¦ȴ¿ѥå¿
						ͥåȥ֤ȤͤΤǡ
						֤κɹ䡢˥󥰤Ρ³Υȥ饤ʤɤͤ
						ɬפХ饤֥경롣
				ץȥ
						  ѥåȥإåΥɤʤȤ
						ʥѥåȤȽǤʤΤ褦ʼ
						ץȥξϤβμ˴롣
						󥰵ڤӡͤˤΤ򤹤롣
				Хåեꥢ­
						  ˼Хåե礭ʤΤ줿Ȥ
						顼֤ơХåեʬƳǼ
						Ĥʬ˴롣
						  ѥåȤϢ³ƤȻפ֤ϡν
						ԤХåեϤ߽Фʬ˴롣
						ʣإå꥿
						󥰵ڤͤˤΤԤ

*************************************/
/*ǡ׵᥵ʬɤ߹*/
static int read_packet(int FD	 , int requestlen , int *read_len , char * buf , int bufsizei , int timeout){
	struct pollfd pollFD;		/*ݡ󥰤Τ˻Ȥ¤*/
	int stat;					/*ͤ򸫤뤿*/
	int ret;					/**/
	int lessofbuf = 0;
	int count;

	if (requestlen==0){
		*read_len=0;
		return LIBNET_STAT_OK;
	}
	stat = LIBNET_STAT_OK;
	*read_len = 0;
	LP_log(LIBNET_DBG_DEBUG+100 , "libnet:read_packet start\n");
	if (timeout <= 0)timeout= 1000;

	/*Хåեǡ礭*/
	lessofbuf = 0;
	if (requestlen > bufsizei){
		/* ϥХåեȤϤ߽ФФƤ(Ȥɤ߼ΤƤ) */
		lessofbuf = requestlen - bufsizei;
		requestlen = bufsizei;
		stat = LIBNET_STAT_LOSTDATA;
	}

	count = 3;
	while ( *read_len < requestlen && --count >= 0 ) {

		#if 0
		LP_log( 100 , "count=%d,read_len=%d,requestlen=%d\n",count, *read_len, requestlen  );
		#endif

		pollFD.fd = FD;
		pollFD.events = (POLLIN | POLLPRI );
		/*٥ȥ롼*/

		if ((ret = poll (&pollFD , 1 , timeout))< 0){
			if (errno == ENOMEM)stat = LIBNET_STAT_MALLOCERR;
			if (errno == EFAULT)stat = LIBNET_STAT_EFAULT;
			if (errno == EINTR )stat = LIBNET_STAT_WTIMEUP;
			LP_log(LIBNET_DBG_DEBUG , "read_packet: poll call error (%d:%s)\n" , errno, strerror( errno ) );
			return (stat);
		} 
		if ((pollFD.revents & (POLLIN | POLLPRI))== 0){
			/*ɤ߹߼Ԥʤ*/
			/*ɤ߹߼Իϥ꥿󤹤롣*/
			if (pollFD.revents & POLLERR)stat = LIBNET_STAT_POLLERR;
			if (pollFD.revents & POLLHUP)stat = LIBNET_STAT_POLLHUP;
			if (pollFD.revents & POLLNVAL)stat = LIBNET_STAT_POLLNVAL;
			/*ǡʤȤϥǡڤǵ*/
			LP_log(LIBNET_DBG_DEBUG , "read_packet: poll event error (%d)\n", stat );
			return (stat);
		}
		/*ɤ߹ߤγ*/
		LP_log(LIBNET_DBG_DEBUG+100 , "libnet:read_packet:start read[%d] requestlen[%d] *read_len[%d]\n", 
			requestlen - *read_len,requestlen,*read_len);
		ret = read (FD , &buf[*read_len] , requestlen - *read_len);
		if (ret< 0){
			LP_log( LIBNET_DBG_DEBUG , "read_packet: read error (%d:%s)\n" , errno, strerror( errno ) );
			stat = LIBNETBASEERR - errno;
			return (stat);
		} 
		/*Хȼ*/
		if (ret == 0){
			LP_closefd (FD);
			return LIBNET_STAT_LENGTHZERO;
		}
		*read_len += ret;
		#if 0
		LP_log( 100 , "read_len=%d\n", *read_len );
		#endif
	}
	if ( *read_len != requestlen ) {
		return LIBNET_STAT_READLENLESS;
	}

	/* Хåեۤǡɤ߼ΤƤ롣 */
	if (lessofbuf> 0){
		char * tmpbuf;

		tmpbuf = malloc (lessofbuf);
		if (tmpbuf == NULL ){
			return stat;
		}
		pollFD.fd = FD;
		pollFD.events = (POLLIN | POLLPRI );
		if ((ret = poll (&pollFD , 1 , timeout))< 0){
			if (errno == ENOMEM)stat = LIBNET_STAT_MALLOCERR;
			if (errno == EFAULT)stat = LIBNET_STAT_EFAULT;
			if (errno == EINTR )stat = LIBNET_STAT_WTIMEUP;
			LP_log(LIBNET_DBG_DEBUG , "read_packet: poll call error (%d:%s)\n" , errno, strerror( errno ) );
			free (tmpbuf);
			return (stat);
		} 
		if ((pollFD.revents & (POLLIN | POLLPRI))== 0){
			/*ɤ߹߼Ԥʤ*/
			/*ɤ߹߼Իϥ꥿󤹤롣*/
			if (pollFD.revents & POLLERR)stat = LIBNET_STAT_POLLERR;
			if (pollFD.revents & POLLHUP)stat = LIBNET_STAT_POLLHUP;
			if (pollFD.revents & POLLNVAL)stat = LIBNET_STAT_POLLNVAL;
			/*ǡʤȤϥǡڤǵ*/
			LP_log(LIBNET_DBG_DEBUG , "read_packet: poll event error (%d)\n", stat );
			free (tmpbuf);
			return (stat);
		}
		/*ɤ߹ߤγ*/
		ret = read (FD ,tmpbuf ,lessofbuf );
		if (ret< 0){
			LP_log(LIBNET_DBG_DEBUG , "libnet:read error [%d]\n" , errno);
			free (tmpbuf);
			return (stat);
		}
		/*Хȼ*/
		if (ret == 0){
			LP_closefd (FD);
			return LIBNET_STAT_LENGTHZERO;
		}
		free (tmpbuf);
	}

	#if 0
	LP_log(  LIBNET_DBG_DEBUG  ,"libnet:not enouf data\n");

	/*ǡƤʤ硢ȥ饤ߥॢʬɤ߹ߤ»ܤơ*/
	LP_log(  LIBNET_DBG_DEBUG  , "libnet:read_packet:if not have data . try to read (retrytime * timeout) \n" );
	return LIBNET_STAT_ERR;
	#endif
	
	return stat;
}

/*
٥ȥݡ

δؿ1θƤӽФˤĤͭfdϤ1Ĥ롣

*/
int LP_Poll( char * command , char * data , int buf_length , int *length , int	 timeout  , int *resfd){
	
	int cnt;
	int nStat;
	int i = 0;
	int requestlen;
	libnet_send_st packet_head;
	int stat = LIBNET_STAT_OK;
	int ret ;
	int read_len;
	int new_fd;
	int len;
	int cnt2;
	LP_log(LIBNET_DBG_DEBUG+100 , "libnet:LP_Poll\n");

	/* Ωǡ롣 */
	*length = 0;
	bzero (command,COMMANDLEN);

	/* ƻԤfdꤹ롣 */
	for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt ++){
		if (LP_FDS[cnt] != 0 || LP_FDTYPE[cnt] ==POLLTYPE_RAW ){
			s_Poll[i].events = POLLIN | POLLPRI;
			s_Poll[i].fd = LP_FDS[cnt];
			i++;
			LP_log(LIBNET_DBG_DEBUG2 , "libnet:set fd [%d] type [%d]\n",LP_FDS[cnt],LP_FDTYPE[cnt]);
		}else{
			LP_log(LIBNET_DBG_DEBUG2 , "libnet:not set  fd [%d] type [%d]\n",LP_FDS[cnt],LP_FDTYPE[cnt]);
		}
	}

	/*٥Ȥμ*/
	LP_log(LIBNET_DBG_DEBUG+100 , "libnet:LP_Poll:poll\n");
	if ( ( nStat = poll( s_Poll, i , timeout ) ) < 0 ) {
		if (errno == ENOMEM)stat = LIBNET_STAT_MALLOCERR;
		if (errno == EFAULT)stat = LIBNET_STAT_EFAULT;
		if (errno == EINTR )stat = LIBNET_STAT_WTIMEUP;
		LP_log(LIBNET_DBG_DEBUG , "LP_Poll: poll call error (%d:%s)\n" , errno, strerror( errno ) );
		return (stat);
	} 

	/* 1İʾͭfd(Ĥޤꥤ٥)ȯ */
	if ( nStat > 0 )
	{
		/* ٥Ȥǥѥå롣 */
		for (cnt = 0 ; cnt < fdlim.rlim_cur ; cnt++){
			cnt2 = test_fd(s_Poll[cnt].fd);

			/* fdϤä */
			if ( s_Poll[cnt].revents & ( POLLIN | POLLPRI | POLLERR | POLLHUP | POLLNVAL ) ){

				*resfd = s_Poll[cnt].fd;

				/* fd㳰ȯ */
				if ((s_Poll[cnt].revents & (POLLIN | POLLPRI))== 0){
					/*ɤ߹߼Ԥʤ*/
					/*ɤ߹߼Իϥ꥿󤹤롣*/
					stat = LIBNET_STAT_POLLERR;
					if (s_Poll[cnt].revents & POLLERR)stat = LIBNET_STAT_POLLERR;
					if (s_Poll[cnt].revents & POLLHUP)stat = LIBNET_STAT_POLLHUP;
					if (s_Poll[cnt].revents & POLLNVAL)stat = LIBNET_STAT_POLLNVAL;
					/*ǡʤȤϥǡڤǵ*/
					LP_log(LIBNET_DBG_DEBUG , "LP_Poll: poll event error (fd=%d,stat=%d)\n", *resfd, stat );
					memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					return (stat);
				}

				/* ٥ȥǥѥå(1Ĥƥ꥿󤹤롣) */

				/*UNIXåȤ³׵*/
				if (POLLTYPE_USERV == LP_FDTYPE[cnt2] || POLLTYPE_URAWSERV == LP_FDTYPE[cnt2]){
					struct sockaddr_un	  caddr;
					LP_log(LIBNET_DBG_DEBUG , "libnet:LP_Poll:got connection request \n");
					len = sizeof(caddr);
					new_fd = getfdnewentry();
					if ((LP_FDS[new_fd] = accept(s_Poll[cnt].fd ,	
						(struct sockaddr *)&caddr, &len)) < 0) {
						LP_perror("accept");
						LP_log(LIBNET_DBG_DEBUG , "libnet:acept error WHY!![%d]\n" , errno);
						if (LP_FDS[new_fd] > 0)LP_closefd(LP_FDS[new_fd]);
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_CONNECTIONERR;/*exit(1);*/
					}
					/*ƣĤϥǡ˳Ǽ*/
					memcpy (command , LIBNET_CMD_CONNECTREQ , COMMANDLEN);
					memcpy (data , &LP_FDS[new_fd] , sizeof (int));
					memcpy (&(data[sizeof (int)]),&caddr,sizeof(caddr));
					*resfd = LP_FDS[new_fd];
					*length = sizeof (int);
					/*׵ƥץȤ饳ͥȤȤ֤*/
					LP_log (LIBNET_DBG_DEBUG , "libnet:return that have  connect [%d]-[%d] \n"
					, new_fd , LP_FDS[new_fd] );
					if (POLLTYPE_URAWSERV == LP_FDTYPE[cnt2]){
						LP_FDTYPE[new_fd]=POLLTYPE_RAW;
						memcpy (command , LIBNET_CMD_RAWCONNECTREQ , COMMANDLEN);
						return LIBNET_STAT_CONNECTREQUESTRAWU;
					}
					LP_FDTYPE[new_fd]=POLLTYPE_LAUREL;
					return (LIBNET_STAT_CONNECTREQUESTU);
				}
				/*³׵ץȤơƣĤϿ*/
				if (POLLTYPE_TSERV == LP_FDTYPE[cnt2] || POLLTYPE_TRAWSERV == LP_FDTYPE[cnt2]){
					struct sockaddr_in	  caddr;
					LP_log (LIBNET_DBG_DEBUG , "libnet:conection request\n");
					len = sizeof(caddr);
					new_fd = getfdnewentry();
					/*ץȤ򤹤*/
					if ((LP_FDS[new_fd] = accept(s_Poll[cnt].fd ,	
						(struct sockaddr *)&caddr, &len)) < 0) {
						/*ԤФƼԤ֤*/
						LP_log (LIBNET_DBG_DEBUG , "libnet:acept error WHY!![%d]\n" , errno);
						if (LP_FDS[new_fd] > 0)LP_closefd(LP_FDS[new_fd]);
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_CONNECTIONERR;
					}
					/*ץ׵᤬ΣţԣңУǤƤ뤫ǧ*/
					if (timeout < 1000 )timeout=1000;
					ret=read_packet(LP_FDS[new_fd] , 12 , length , data , buf_length , timeout);
					/*³夹ˣΣţԣңУǤΥץ׵Ǥ뤳Ȥ򼨤ѥåȤϤ*/
					if (ret < 0 ){
						/*ǡʤȤϥͥ󥨥顼Ȥƽ*/
						LP_log (LIBNET_DBG_DEBUG , "libnet:it must have packet[%d]-[%d]\n" , ret , timeout);
						LP_closefd (LP_FDS[new_fd]);
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_CONNECTIONDATAERR;
					}
					/*Ƥǧ*/
					if (memcmp (data , LIBNET_STR_ACCEPT , strlen(LIBNET_STR_ACCEPT))!=0){
						LP_log (LIBNET_DBG_DEBUG , "libnet:test is is true\n");
						LP_closefd (LP_FDS[new_fd]);
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_CONNECTIONDATAERR;
					}
					/*³λΤ³ƣĤǡ
					³Ȥ֤*/
					memcpy (data , &LP_FDS[new_fd] , sizeof (int));
					memcpy (&(data[sizeof (int)]),&caddr,sizeof(caddr));
					*resfd = LP_FDS[new_fd];
					*length = sizeof (int);
					memcpy (command , LIBNET_CMD_CONNECTREQ , COMMANDLEN);
					LP_log (LIBNET_DBG_DEBUG , "libnet:return connect if it was sucsess[%d]-[%d] from[%s]\n"
					, new_fd , LP_FDS[new_fd],inet_ntoa(caddr.sin_addr));
					if (POLLTYPE_TRAWSERV == LP_FDTYPE[cnt2]){
						LP_FDTYPE[new_fd]=POLLTYPE_RAW;
						memcpy (command , LIBNET_CMD_RAWCONNECTREQ , COMMANDLEN);
						return LIBNET_STAT_CONNECTREQUESTRAWT;
					}
					LP_FDTYPE[new_fd]=POLLTYPE_LAUREL;
					return LIBNET_STAT_CONNECTREQUESTT;
				}
				cnt2 = test_fd(s_Poll[cnt].fd);
				/*POLLTYPE_RAW==LP_FDTYPEäңףƣļȤƽ*/
				if (POLLTYPE_RAW==LP_FDTYPE[cnt2]){
					/*RAW data äϤΤޤ޼ʤǤ*/
					*length=0;
					*resfd=s_Poll[cnt].fd;
					memcpy (command , LIBNET_CMD_RAWDATARECEVE , COMMANDLEN);
					LP_log (LIBNET_DBG_DEBUG , "libnet:Raw data receve FD%d length%d\n",
						*resfd,*length);
					return LIBNET_STAT_RAWRESEVE;
				}
				LP_log(LIBNET_DBG_DEBUG+100 , "libnet:read data head[%d]\n",sizeof (libnet_send_st));
				/*ǡξ硢إåᤷƽ*/
				ret = read_packet(
					s_Poll[cnt].fd, sizeof (libnet_send_st), &read_len,
					(char*)&packet_head, sizeof (libnet_send_st),
					timeout
				);
				if (ret != LIBNET_STAT_OK ) {
					if ( ret == LIBNET_STAT_LENGTHZERO ) {
						memcpy (command , LIBNET_CMD_CLOSEFD, COMMANDLEN);
					}
					else {
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					}
					return ret;
				}
				#if 0
				ret = read (s_Poll[cnt].fd , &packet_head , sizeof (libnet_send_st));
				if (ret < 0){
					if (errno == EINTR){
						LP_closefd(s_Poll[cnt].fd);
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_READBREAK;
					}
					memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					return (LIBNETBASEERR-errno);
				}
				/*Хȼ*/
				if (ret == 0){
					LP_closefd(s_Poll[cnt].fd);
					memcpy (command , LIBNET_CMD_CLOSEFD , COMMANDLEN);
					return LIBNET_STAT_LENGTHZERO;
				}
				/*Ĺإå礭ʤ*/
				if (ret < sizeof (libnet_send_st)){
					/*Ĺإåʬ礭*/
					if (ret > strlen (LIBNET_STR_PHEADER)){
						/*ӤƥإåǤϤʤäȤϼ*/
						if (memcmp(LIBNET_STR_PHEADER , &packet_head , strlen (LIBNET_STR_PHEADER))!=0){
							memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
							return LIBNET_STAT_HEADSENDERR;
						}else{
							/*ӤƱϤɤ߹뤫󥸤Ƥߤ롣*/
							if (read_packet (s_Poll[cnt].fd	 , (sizeof (libnet_send_st)-ret) ,
							&read_len , &((char *)&packet_head)[ret] ,(sizeof (libnet_send_st)-ret),
							timeout)!=LIBNET_STAT_OK){
								/*ǤäȤϥ顼ǵ*/
								memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
								return LIBNET_STAT_HEADRECVERR;
							}
						}
					}else {
						/*Ĺإåʬ꾮*/
						memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
						return LIBNET_STAT_HEADSENDERR;
					}
				}
				#endif
				/*ĹʬʤإåǤ뤫ȽǤ*/
				if (memcmp(LIBNET_STR_PHEADER , &packet_head , strlen (LIBNET_STR_PHEADER))!=0){
					/*㤦Ȥϥ顼֤*/
					memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					LP_log( LIBNET_DBG_DEBUG, "LIBNET_STAT_HEADSENDERR(in receive)\n" );
					return LIBNET_STAT_HEADSENDERR;
				}
				/*׵Ĺ*/
				requestlen = ntohl(packet_head.length);
				if (requestlen < 0){
					/*ͤλϥ顼֤*/
					memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					return LIBNET_STAT_NOREQLEN;
				}
				LP_log(LIBNET_DBG_DEBUG+100 , "libnet:read data [%d]\n",requestlen);
				/*μν򤹤롣*/
				if (cnt2 < 0)return LIBNET_STAT_ERROTHER;
				
				if (LP_FDS[cnt2] <= 0){
					
					memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
					return LIBNET_STAT_ERROTHER;
				}
				/*ɣĤäȤϥơ˿ä*/
				if (++LP_IDSR[cnt2] != ntohl(packet_head.ID)){
					stat = LIBNET_STAT_NOIDCONTINUE;
					LP_log (LIBNET_DBG_DEBUG , "libnet:The ID was fault[%d]-[%d]\n" , 
						LP_IDSR[cnt2] ,ntohl(packet_head.ID));
					LP_IDSR[cnt2] = ntohl(packet_head.ID);
				}
				memcpy (command	 ,packet_head.command , COMMANDLEN );
				/*ѥåȤɤ߹*/
				if (timeout < 1000 )timeout=1000;
				ret = read_packet (s_Poll[cnt].fd  , requestlen , length , data , buf_length , timeout);
				if (ret != LIBNET_STAT_OK )stat = ret;
				return stat;
			}
		}
	}
	else if ( nStat == 0 )	/* ٥Ȥȯ˥ॢȤ */
	{
		/* 顼 */
		memcpy (command , LIBNET_CMD_POLLTIMEUP , COMMANDLEN);
		return LIBNET_STAT_WTIMEUP;
	}
	else if ( errno == EAGAIN  ) /* ׵ǽʤ */
	{
		memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
		return (LIBNETBASEERR-errno);
	}
	else if ( errno == EINTR)
	{
		memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
		return LIBNET_STAT_OTHERSIG;
	}
	if ( nStat <= 0 )	/* Ԥ */
	{
		/* ԤΥåȤ򥯥 */
		memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
		return LIBNET_STAT_ERROTHER;

	}	
	memcpy (command , LIBNET_CMD_RECEIVEERROR , COMMANDLEN);
	return LIBNET_STAT_ERROTHER;
}

/*٥ȥ롼ΡδؿϻȤʤʤä*/
int LP_eventloop( char * data , int * leng	 , struct  timeval timeout ){
/*
char	*		data	ǡɤ߹ХåեؤΥݥ
int		*		leng	ǡХåեĹ
struct	timeval timeout	ॢȻ
*/
/*δؿϻȤʤΤȤʤ*/
int stat;
	stat= LIBNET_STAT_OK;
	return stat;
}

int LP_logfd = 0;
int logconnect = 0;
char LP_Pname[20];
/**********************************************************


ϥ¦֤ƤϥФˤĤʤǴ򤹤
ΥФ餫ͳǻ̾硢ơ٥
ƥλ٤Ǥ롣

饤¦˱Ƥϥե
˥ǥХå롣

ФˤȤäƽʥ顼ˤĤƤϥФؤ
ͤƤǤ礦

int loginit( char * pname );		СȤ³
int LP_loginit( char * pname  , char * sockname);	ФȤ³å̾
int LP_dbglvl(int dbglvl);
int LP_log(int DBlev , char * errbuf , ...);СäƤƤ餦
char *  LP_setlogfile(char * filename){ Ф³ʤȤϤδؿǥե̾Ͽ
int LP_gamelog();  ˽񤭽Ф 	
int LP_logclose(){	եΥ

ФΤߤȤΤ
char *  LP_setlogfile(char * filename){ ץ̾Ͽ
int LP_gamelog( int dbglvl ,char * msg ); ΥϤ
줿ǥХå٥ȥ٤ƤȤƤ錄
int LP_receveLogwrite(char * readbuf);	ǡ񤭽Ф
int LP_dbglvl(int dbglvl);
int LP_logclose(){	եΥ
ˤäƥ󥰥٥򥻥åȤ롣



饤ȤϤޤ

int loginit( char * pname );  ФȤ³
ޤ
int LP_loginit( char * pname  , char * sockname);	ФȤ³å̾

ˤơФ³򤹤
饤Ȥξ³˼ԤΤǥե˽񤭹褦ˤʤ
СФ³ԤȤϥե˽
Τȡ

int LP_log(int DBlev , char * errbuf , ...);

ˤƥϤ
⤷եˤȤ䡢ɸϤ˽Ф

int LP_dbglvl(int dbglvl);

ȤοˤɸϤˤɽ
Ф³Ԥƥե˽񤭽ФȤ
ǥХå٥ʲΤΤ񤭹ޤ롢
ΤǥХå٥夲Ⱦܺ٤ˤʤꡢȽפʤΤ
񤫤ʤʤ롣
	   #define LIBNET_DBG_EMERG	10	 system is unusable				
	   #define LIBNET_DBG_ALERT	20	 action must be taken immediately 
	   #define LIBNET_DBG_CRIT		30	 critical conditions				
	   #define LIBNET_DBG_ERR		40	 error conditions					
	   #define LIBNET_DBG_WARNING	50	 warning conditions				
	   #define LIBNET_DBG_NOTICE	60	 normal but significant condition /
	   #define LIBNET_DBG_INFO		70	 informational					/
	   #define LIBNET_DBG_DEBUG	20	 debug-level messages				/
ΥǥեȤռФ褦ˤ
饤֥ϤΥ٥˱äƥ󥰤褦˥ǥ󥰤롣

ܺ٤˽Ф褦ʥ٥ˤȤϡνϤȼ
پ徺θ٤Ǥ롣

ƥ٥˱ƵưѤ٤

**********************************************************/

static char * LP_logsockname(char * socname){
    static char gsockname[MAXPATHLEN];
    static int LP_fdinitflag=0;
    if (LP_fdinitflag==0){
        bzero(gsockname,MAXPATHLEN);
		#if 0
        strncpy(gsockname,LIBNETLOGSOCNAME,MAXPATHLEN);
		#endif
        LP_fdinitflag=1;
    }
    if (socname!=NULL) strncpy(gsockname,socname,MAXPATHLEN);
	if ( *gsockname == '\0' ) {
    	return NULL;
	}
	else {
    	return gsockname;
	}
}

/*ե̾ꡡե̾*/
char *  LP_setlogfile(char * filename){
	static int fl=0;
	static char gfln[MAXPATHLEN];
	if (fl==0){
		strncpy (gfln , LOGFILENAME , MAXPATHLEN);
		fl = 1;
	}
	if (filename != NULL){
		strncpy (gfln , filename , MAXPATHLEN);
	}
	return gfln;
}

/* С
 * 饤ȤΡRPGLOGREQ򤦤
 * ΥǡȤϤ
 * ǥХå٥򥻥åȤƥ󥰤*/
int LP_receveLogwrite(char * readbuf){
	int dbglev;

	dbglev=ntohl(*((int *)readbuf));
	return LP_gamelog(dbglev, &(readbuf[sizeof(int)]));
}

/* 񤭽ФΥǥХå
 * LP_setlogfile()ˤƥåȤե̾Ф
 * УɣĤղäƥϤ롣
 * ߤϤΥåڤӥơȵǽ̵*/
int LP_gamelog(int dbglvl ,char * tmpbuf ){
	
static FILE *FD =NULL;
static int linecnt = 0;
time_t timeb;
struct tm *timebuf;
char errerbufffer[LOGBUFFSIZE];
char filename[LOGBUFFSIZE];

	memset (errerbufffer ,(int) NULL , LOGBUFFSIZE);
	memset (filename , (int)NULL , LOGBUFFSIZE);
	if ( time (&timeb) < 0){
		perror ("time");
		printf ("cant get time\n");
	}else{
		timebuf = localtime(&timeb);
		sprintf (errerbufffer , "%02d/%02d %02d:%02d:%02d " , timebuf->tm_mon +1 ,
		timebuf->tm_mday , timebuf->tm_hour , timebuf->tm_min , timebuf->tm_sec );
	}
	if (dbglvl <= LP_dbglvl(0)){
		if (FD == NULL){
			/*ǥХåե뤬Ƥʤг*/
			sprintf (filename ,	 "%s.%d" , LP_setlogfile(NULL) , getpid());
			FD = fopen (filename , "w+");
			if (FD == NULL ){
				/*եΥץ*/
				perror ("open ");	
				write(2,"cant open errlog file\n" , strlen("cant open errlog file\n"));
				write(2,filename , strlen(filename));
				write(2,errerbufffer , strlen(errerbufffer));
				write(2,tmpbuf , strlen (tmpbuf));	/*ʤΤ
							ɸϤ˽Ф*/
			}else{
				/*Τǥե˽Ф*/
				linecnt = 0;
				strncat (errerbufffer , tmpbuf , LOGBUFFSIZE - strlen(errerbufffer) );
				fprintf ( FD , errerbufffer);
				fflush (FD);
				if (LP_dbglvl(0)%2)write(2,errerbufffer , strlen(errerbufffer));
				linecnt++;
			}
		}else{
			/*ե˵롣*/
			strncat (errerbufffer , tmpbuf, LOGBUFFSIZE - strlen(errerbufffer));
			fprintf ( FD , errerbufffer);
			fflush (FD);
			if (LP_dbglvl(0)%2)write ( 2 , errerbufffer , strlen(errerbufffer));
			linecnt++;
			
			if (linecnt > LOGLINEMAX){
				if( fseek (FD , 0 , SEEK_SET)< 0){
					fclose (FD);
					FD = NULL;
				}
				linecnt = 0;
			}
		}
	}
	if (dbglvl == -1){
		fclose (FD);
		FD=NULL;
	}
	return LP_OK ;
}

/*եΥ*/
int LP_logclose(){
	LP_gamelog(-1,"");
	return LP_OK;
}


/*顼ν򤹤*/
int LP_loginit( char * pname  , char * sockname){
	int ret = 0;
	if (sockname != ""){
		LP_logsockname(sockname);

		if ( logconnect == 0){/*⤷Ф³Ƥʤä³򤹤*/
			if ( LP_logfd == 0){
				if ( (ret = LP_usoc_client_open(sockname)) < 0){
					LP_log (LIBNET_DBG_DEBUG , "libnet:cant connect log server\n");
					return ret;
				}
				LP_logfd = ret;
			}
			if (pname != NULL){
				memset (LP_Pname , 0 , 20);
				memcpy (LP_Pname , pname , 15);
			}
			logconnect = 1;
		}else{
			LP_log (LIBNET_DBG_DEBUG , "libnet:log server already connected \n");
			/*ФΣƣĤ֤*/
			return LP_logfd;
		}
	}else{
		LP_log (LIBNET_DBG_DEBUG , "libnet:log server sockname not abuveable\n");
	}
	return ret;
}
/*顼ν򤹤*/
int loginit( char * pname ){
	int ret = 0;
	if (LP_dbglvl(0) > 2000)printf( "libnet:loginit:initial log server[%s]\n",pname);
	if (LP_logsockname(NULL)!=NULL){
		if ( logconnect == 0){/*⤷Ф³Ƥʤä³򤹤*/
			if ( LP_logfd == 0){
				if ( (ret = LP_usoc_client_open(LP_logsockname(NULL))) < 0 ){
					printf ("libnet:cant connect log server\n");
					return ret;
				}
				LP_logfd = ret;
			}
			if (pname != NULL){
				memset (LP_Pname , 0 , 20);
				memcpy (LP_Pname , pname , 10);
			}
			logconnect = 1;
		}else{
			printf("libnet:log server already connected \n");
			/*ФΣƣĤ֤*/
			return LP_logfd;
		}
	}
	return ret;
}


/*ǥХå٥򥻥åȤƼ*/
int LP_dbglvl(int dbglvl){
	static int LP_dbglvl1 = 0;

	if (dbglvl > 0){
		LP_dbglvl1 = dbglvl;
	}
	return LP_dbglvl1;
}

/*ν񤭽Ф*/
int LP_log(int DBlev , char * errbuf , ...){
time_t timeb;
int ret , n;
struct tm *timebuf;
char errerbufffer[LOGBUFFSIZE];
char tmpbuf[LOGBUFFSIZE];
char filename[sizeof(int) +LOGBUFFSIZE];
va_list ap;
	ret =0;
	if (LP_dbglvl(0) <DBlev)return LP_OK;
	if (LP_dbglvl(0) > 3000)printf ("libnet:LP_log:start   LP_logfd[%d]\n",LP_logfd);
	/*ХåեΥꥢ򤹤*/
	memset (errerbufffer ,(int) NULL , LOGBUFFSIZE);
	memset (tmpbuf , (int)NULL , LOGBUFFSIZE);
	memset (filename , (int)NULL ,sizeof(int) +LOGBUFFSIZE);
	/*֤Υå*/
	if ( time (&timeb) < 0){
		printf ("libnet:cant got time[%s]\n" , strerror (errno));
	}else{
		/*֤򥻥åȤ*/
		timebuf = localtime(&timeb);
		snprintf (errerbufffer ,LOGBUFFSIZE, "%02d/%02d %02d:%02d:%02d " , timebuf->tm_mon +1 ,
		timebuf->tm_mday , timebuf->tm_hour , timebuf->tm_min , timebuf->tm_sec );
	}
	/*դ᤹*/
	va_start(ap, errbuf);
	(void) vsnprintf(tmpbuf, LOGBUFFSIZE - strlen(errerbufffer) , errbuf , ap );
	va_end(ap);
	/*ФȤ³򤷤ƤʤȤϡ*/
	if (logconnect == 0){
		if (LP_dbglvl(0) > 3000)printf ("not connect to log server\n");
		if (LP_dbglvl(0) > DBlev){
			if (LP_dbglvl(0)%2)printf (errerbufffer);
			if (LP_dbglvl(0)%2)printf (tmpbuf);
		}
		LP_gamelog(DBlev , tmpbuf);
		return LIBNET_STAT_NOTOPENLOG;
	}
	/*ƣĤϿƤ뤫ǧ*/
	if (test_fd(LP_logfd) < 0){
		printf ("log server FD not registered\n");
		if ((ret = loginit (LP_Pname)) < 0){
			logconnect = 0 ;
			LP_gamelog(DBlev , tmpbuf);
			loginit( LP_Pname);
			return (ret);
		}
	}
	n=1;
	/*ФФ򤹤*/
	*((int *)filename)=htonl(DBlev);
	if (LP_logfd > 0&& ((LP_dbglvl(0) > DBlev) || DBlev < 1000)){
#if 0
		strncpy (&filename[sizeof (int)] , errerbufffer , strlen (errerbufffer));
		strcat (&filename[sizeof (int)] , LP_Pname);	/*襻ơۡˤʤǽ*/
#endif
		strncpy (&filename[sizeof (int)] , LP_Pname,LOGBUFFSIZE-1);	
		strcat (&filename[sizeof (int)] , ":" );
		if (LOGBUFFSIZE-strlen(LP_Pname)-1>0){
			strncat (&filename[sizeof (int)] , tmpbuf ,LOGBUFFSIZE-strlen(LP_Pname)-1);
		}
		ret = LP_send(LP_logfd , RPGLOGREQ , filename	, sizeof(int)+strlen (&filename[sizeof (int)]));
		if (ret <0){
			printf ("LP_log:LP_send:error [%d] %s\n",ret,LP_Pname);
			LP_closefd(LP_logfd);
			LP_logfd=0;
			logconnect=0;
			loginit( LP_Pname);
		}
	}else if (LP_logfd < 0){
		LP_gamelog(DBlev , tmpbuf);
		logconnect=0;
		loginit( LP_Pname);
		return LIBNET_STAT_NOFD;
	}
	/*ǥХå٥뤬λɸ२顼ˤФ*/
	if (LP_dbglvl(0) > DBlev){
		if (LP_dbglvl(0)%2)write (2, errerbufffer,strlen (errerbufffer));
		if (LP_dbglvl(0)%2)write (2,tmpbuf,strlen (tmpbuf));
	}
	return (ret);
}

/**********************************************************
ͭ

ͭѤϺ¦ץ¦ץʬޤ
¦ϰʲΥץȤ
char *	LP_shmctl_init(shment * shmentry , int entrynom  , int *ctlshmid );
char *	LP_shmctl_addentry(int shmNO  , int size );
void LP_shmctl_destroy();


¦ϰʲΥץȤ
LP_shmunit * LP_shm_init(int ctlshmid);
LP_shmunit * LP_shm_all_attach(int ctlshmid );
char * LP_shm_attach(int shmNO);
void  LP_shm_all_detach();


ͭ깽¤
typedef struct {
	int shm_id;			ͭɣġʣ
	int size;			ͭ礭
	char * adder;		ͭꥳȥ¦ݥ

}LP_shmunit;
ι¤Τˤ뤳ι¤ΤΥ쥳ֹ椬
ΤޤޣңУǶֹͭȤʤ롢¦⤳ֹѤ
å򤹤롣
LP_shmunit * LP_shm = NULL;
γѿ饤֥ͭƤ롣
ι¤ΤΥ쥳ɿ
#define LIBNETSHMIDMAX			20			ͭ票ȥ꡼
ȤơͤңУǶֹͭκͤȤʤ
Τ᥷ƥˤꡢ¿ζͭꥨȥȤˤ
ͤѹɬפ롣

ͭϿѹ¤
typedef struct{
	int	shmNO;			ңУǶֹͭ椳ֹϿ
	int	size;			ͭ礭
}shment;
ϿΣңУǶֹͭ礭롣


**********************************************************/


LP_shmunit *LP_shm = NULL;
/*ͭطνʥå*/
LP_shmunit * LP_shm_init(int ctlshmid){
char * adder;
static int opLP_fdinitflag = 0;

	if (opLP_fdinitflag == 1){
		return LP_shm;
	}
	if (ctlshmid ==0)return NULL;
	/*ͭΥå*/
	adder = shmat ( ctlshmid , NULL , (int)NULL);
	if (adder < 0){
		LP_log(LIBNET_DBG_DEBUG , "libnet:faule attatch shm[%s]\n" , strerror(errno));
		adder = NULL;
		return (LP_shmunit * )(LIBNET_STAT_SHMATTACHERR);
		/*ͭؤΥåʤ*/
	}
	(char *)LP_shm = adder;
	opLP_fdinitflag = 1;
	/*ͭꥳȥؤΥݥ󥿤֤*/
	return (LP_shmunit *)adder;
}

/*ͭνʺ*/
char *	LP_shmctl_init(shment * shmentry , int entrynom  , int *ctlshmid ){
	char * ret3;
	int ret1;
	int cnt;
	
	static int  open_LP_fdinitflag= 0;
	
	if (open_LP_fdinitflag > 0){
		return (char *)LIBNET_STAT_ALREADYOPEN;
	}
	/*ͭΰμ*/
	if (LP_shm == NULL){
		ret1 = shmget (IPC_PRIVATE, LIBNETSHMIDMAX * sizeof(LP_shmunit) , IPC_CREAT | 0666);
		if (ret1 > 0){
			*ctlshmid = ret1;
			LP_shm = shmat ( *ctlshmid, NULL , (int)NULL );
			if (LP_shm < 0){
				LP_log(LIBNET_DBG_DEBUG , "libnet:rpg_shmget:%s\n" , gettext("falure memory attatch"));
				LP_shm = NULL;
				return ((char *)LIBNET_STAT_SHMATTACHERR);
			}
		}
	}
	/*ͭΥꥢ*/
	/*ޤ衪*/
	memset (LP_shm , (int)NULL , LIBNETSHMIDMAX * sizeof(LP_shmunit));
	LP_shm[0].shm_id = *ctlshmid;
	LP_shm[0].size = LIBNETSHMIDMAX * sizeof(LP_shmunit);
	LP_shm[0].adder = (char *)LP_shm;
	open_LP_fdinitflag = 1;
	/*¾ͭκ*/
	for (cnt = 0 ; cnt < entrynom ;cnt++){
		/*ͭΰ򤷤٤ƥǡ*/
		if ((shmentry[cnt].shmNO == (int)NULL) || (shmentry[cnt].size == (int)NULL) || 
		(shmentry[cnt].shmNO > LIBNETSHMIDMAX)){
			continue;
		}
		/**/
		ret3 = LP_shmctl_addentry( shmentry[cnt].shmNO, shmentry[cnt].size );
		if ((int)(ret3) < (int)NULL){
			char * buf = NULL;
			LP_log (LIBNET_DBG_DEBUG , "libnet:shmaddentry error [%d] [%s]\n" , ret3 ,(char *) LP_net_perror((int)ret3 , &buf));
			LP_shmctl_destroy();
			return (ret3);
		}else{
			memset ((char *)ret3,0,shmentry[cnt].size);
		}
	}
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_shmctl_init end [%d]\n" , LP_shm);
	return ((char *)LP_shm);
}
/*ͭΥȥɲáʺ*/
char *	LP_shmctl_addentry(int shmNO  , int size ){
int ret;
	
	if (shmNO >= LIBNETSHMIDMAX){
		return (char *)LIBNET_STAT_SHMIDERR;
	}
	if (LP_shm==NULL){
		return (char *)LIBNET_STAT_SHMNOINIT;

	}
	if (LP_shm[shmNO].shm_id != (int)NULL && LP_shm[shmNO].size != (int)NULL){
		return (char *)LIBNET_STAT_SHMALREADYATTACH;
	}
	ret = shmget(IPC_PRIVATE, size, IPC_CREAT | 0666);
	if (ret > 0){

		LP_shm[shmNO].shm_id = ret;
		LP_shm[shmNO].adder = shmat ( LP_shm[shmNO].shm_id , NULL , (int)NULL );
		if (LP_shm[shmNO].adder < 0){
			LP_log(LIBNET_DBG_DEBUG , "libnet:rpg_shmget:fault attatch shm\n");
			LP_shm[shmNO].adder = NULL;
			return (char*)(LIBNET_STAT_SHMATTACHERR);
		}
	}else{
		LP_log(LIBNET_DBG_DEBUG , "libnet:cant got memory[%d] [%d] [%d] [%s]\n" , ret , size , shmNO , strerror(errno));
		LP_shm[shmNO].adder = NULL;
		return (char *)(LIBNET_STAT_SHMGETERR);
	}
	LP_shm[shmNO].size = size;
	return LP_shm[shmNO].adder;
}

/*ͭ˴*/
void LP_shmctl_destroy(){
	int cnt;
	
	if (LP_shm==NULL){
		return ;
	}
	for (cnt = 0 ; cnt < LIBNETSHMIDMAX ; cnt++){
		if (LP_shm[cnt].shm_id != (int)NULL && LP_shm[cnt].size != (int)NULL){
			if (LP_shm[cnt].adder !=NULL){
				shmdt(LP_shm[cnt].adder);
				shmctl ( LP_shm[cnt].shm_id , IPC_RMID , NULL); /*ͭҤŤ*/
				LP_shm[cnt].shm_id = 0;
				LP_shm[cnt].size = 0;
				LP_shm[cnt].adder = NULL;
			}
		}
	}
	FREE (LP_shm);
}

/*ͭΥå򤹤*/

char * LP_shm_attach(int shmNO){
char * adder;
	if (LP_shm==NULL){
		return (char *)LIBNET_STAT_SHMNOINIT;
	}
	if (LP_shm[shmNO].shm_id== (int)NULL){
		
		return (char *)LIBNET_STAT_SHMNOSHMID;
	}
	adder = shmat ( LP_shm[shmNO].shm_id , NULL , (int)NULL);
	if (adder < 0){
		LP_log (LIBNET_DBG_DEBUG , "libnet:fault atatch shm[%s]\n" , strerror(errno));
		adder = NULL;
		return (char *)(LIBNET_STAT_SHMATTACHERR);
	}
	return (char *)adder;

}
/*Ƥζͭ˥å*/
LP_shmunit * LP_shm_all_attach(int ctlshmid ){
int cnt;
LP_shmunit * ret;
static LP_shmunit * ctladder= NULL;
	if (ctlshmid == 0)return ctladder;
	if (ctlshmid == -1)FREE(ctladder);
	if ((void *)(ret = LP_shm_init(ctlshmid)) < NULL){
		return (LP_shmunit *)ret;
	}
	if (ctladder != NULL){
		free (ctladder);
	}
	(void *)ctladder = malloc (LIBNETSHMIDMAX * sizeof(LP_shmunit) );
	if ((void *)ctladder <= NULL){
		return	((LP_shmunit *)LIBNET_STAT_SHMMALLOCERR);
	}
	if (LP_shm==NULL){
		return (LP_shmunit *)LIBNET_STAT_SHMNOINIT;
	}
	memcpy (ctladder , LP_shm , LIBNETSHMIDMAX * sizeof(LP_shmunit) );
	
	for (cnt = 0 ; cnt < LIBNETSHMIDMAX ; cnt++){
		if ((LP_shm[cnt].shm_id == (int)NULL) || (LP_shm[cnt].size == (int)NULL)){
			ctladder[cnt].adder =	 LP_shm_attach(cnt);
			if (ctladder[cnt].adder <= (int)NULL){
				ctladder[cnt].adder = NULL;
				ctladder[cnt].shm_id = (int)NULL;
				ctladder[cnt].size = (int)NULL;
			}
		}
	}
	return (LP_shmunit *)(ctladder);
}

/*ƤΥǥå*/

void  LP_shm_all_detach(){
	int cnt;
	LP_shmunit * ctladder;
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_shm_all_detach start\n");
	ctladder = LP_shm_all_attach((int)NULL);
	if (ctladder == NULL)return; 
	for (cnt = 0 ; cnt < LIBNETSHMIDMAX ; cnt++)
		LP_log (LIBNET_DBG_DEBUG , "libnet:LP_shm_all_detach[%d][%d]\n" , cnt , ctladder[cnt].adder);
		if (ctladder[cnt].adder != NULL)shmdt(ctladder[cnt].adder);
	if (LP_shm != NULL)shmdt(LP_shm);
	LP_shm = NULL;
	LP_shm_all_attach (-1);
}

/*ƤΥǥå*/

void  LP_shm_detach(){
	LP_shmunit * ctladder;
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_shm_detach start\n");
	ctladder = LP_shm_init((int)NULL);
	if (ctladder == NULL){
		return;
	}
	LP_shmctl_destroy();
}
/**********************************************************
ͭmmapؤ

static 

char * LP_mopen(char * filepath );

void LP_memclose (char *filepath );
**********************************************************/
static libnet_mmaps libnet_mmap[MAXMEMNOM];

static int LP_mmatnom = 0;

char * LP_mopen(char * filepath ){
int nom = -1;
struct stat statbuf;
int ret,cnt ;

	/*ǤϿƤ餽ΣģģţҤ֤*/
	for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
		if (strncmp ( filepath , libnet_mmap[cnt].fpath , MAXPATHLEN)==0){
			LP_log (200 , "libnet:LP_mopen:alredy opend \n");
			return libnet_mmap[cnt].addr;
		}
	}
	for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
		if (libnet_mmap[cnt].addr <= 0){
			nom=cnt;
			break;
		}
	}
	if (nom == -1 ){
		nom = ++LP_mmatnom;
	}
	/*ͤΤĹեѥӽ*/
	if (strlen (filepath) > MAXPATHLEN){
		LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mopen:too long file path\n");
		return NULL;
	}
	/*꡼ĥդե򥪡ץ󤹤*/
	libnet_mmap[nom].FD=open (filepath , O_RDWR );
	if (libnet_mmap[nom].FD ==1 ){
		LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mopen:cant open file[%s]\n" , filepath);
		return NULL;
	}
	/*եΥåȤ*/
	ret = fstat (libnet_mmap[nom].FD , &statbuf );
	if (ret < 0){
		LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mopen:cant get stat of file[%s]\n" , filepath);
		return NULL;
	}
	libnet_mmap[nom].length=statbuf.st_size;
	/*åȤ򸵤˥ե륵礭ǣͣͣФstatbuf.st_size */
#ifdef _POSIX_MAPPED_FILES
	libnet_mmap[nom].addr = 
		mmap (NULL,statbuf.st_size,PROT_WRITE|PROT_READ,MAP_SHARED,libnet_mmap[nom].FD,0);
#endif
	if (libnet_mmap[nom].addr == (void *)-1){
		LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mopen:mmap error errno[%d]\n",errno);
		return NULL;
	}
	return libnet_mmap[nom].addr ;
}

void LP_mclose(char * filepath){
int ret,cnt ;
	/*Ͽ򸡺Ƥ*/
    for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
        if (strncmp ( filepath , libnet_mmap[cnt].fpath , MAXPATHLEN)==0){
            LP_log (200 , "libnet:LP_mclose:found entry \n");
#ifdef _POSIX_MAPPED_FILES
            ret = munmap (libnet_mmap[cnt].addr ,libnet_mmap[cnt].length );
			if (ret < 0)LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mclose:munmap error \n");
#endif
			libnet_mmap[cnt].addr=NULL;
			libnet_mmap[cnt].FD=0;
			libnet_mmap[cnt].length=0;
			bzero (libnet_mmap[cnt].fpath , MAXPATHLEN);
			return ;
        }
    }
	/*ϿƤʤХ顼åϤ*/
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mclose:cant find map to close\n");
}
int LP_mlength(char * filepath){
int cnt ;
	/*Ͽ򸡺Ƥ*/
    for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
        if (strncmp ( filepath , libnet_mmap[cnt].fpath , MAXPATHLEN)==0){
            LP_log (200 , "libnet:LP_mlength:found entry \n");
			return libnet_mmap[cnt].length;
        }
    }
	/*ϿƤʤХ顼åϤ*/
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mclose:cant find map to close\n");
	return LP_NG;
}

void LP_mallclose(){
int ret,cnt ;

    for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
        if (strlen (libnet_mmap[cnt].fpath)>0 ){
            LP_log (200 , "libnet:LP_mclose:found entry \n");
#ifdef _POSIX_MAPPED_FILES
            ret = munmap (libnet_mmap[cnt].addr ,libnet_mmap[cnt].length );
			if (ret < 0)LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mclose:munmap error \n");
#endif
			libnet_mmap[cnt].addr=NULL;
			libnet_mmap[cnt].FD=0;
			libnet_mmap[cnt].length=0;
			bzero (libnet_mmap[cnt].fpath , MAXPATHLEN);
        }
    }

}

void LP_msync(char * filepath){
int ret,cnt ;
    for (cnt = 0 ; cnt < LP_mmatnom;cnt++){
        if (strncmp ( filepath , libnet_mmap[cnt].fpath , MAXPATHLEN)==0){
            LP_log (200 , "libnet:LP_msync:found entry \n");
#ifdef _POSIX_MAPPED_FILES
#ifdef _POSIX_SYNCHRONIZED_IO
            ret = msync (libnet_mmap[cnt].addr ,libnet_mmap[cnt].length  , MS_ASYNC);
			if (ret < 0)LP_log (LIBNET_DBG_DEBUG , "libnet:LP_mclose:munmap error \n");
#endif
#endif

			return ;
        }
    }
	/*ϿƤʤХ顼åϤ*/
	LP_log (LIBNET_DBG_DEBUG , "libnet:LP_msync:cant find map to close\n");
}

/**********************************************************
ơط

Ǥνϸ§ȤƣģϣӹФнȤ

ư
ƥνλ

#define RPGSECLOGSAFE1		0x000001	ե򤤤ĤХååפ/
#define RPGSECLOGSAFE2		0x000002	ե뤬񤭽ФʤȤϥƥȤ/
#define RPGSECLOGSAFE3		0x000004	äѤˤʤä᡼뤷ä/
#define RPGSEC

#define RPGSECLOGING1		0x000010	ơ٥Υͭˤ/
#define RPGSECLOGING2		0x000020	ơ٥Υʳӽ/
#define RPGSEC
#define RPGSEC

#define RPGSEC				0x000100	/
#define RPGSEC
#define RPGSEC
#define RPGSEC

#define RPGSECNOMCONECT		0x001000	ͥ¤롣/

#define RPGSECWORNINNGDOWN	0x800000	˥󥰥٥ǥƥȤ/

**********************************************************/
/**/
int LP_seclevel( int level1){
	static int level= 0;
	if (level1 > 0)level = level1;
	if (level1 < 0 ) level= 0;
	return level;
}

/**/
int LP_secdisksp(int alarm_size){
	int size =0;
	
	
	
	return size;
}

/**/
int LP_secmailtoadmin(){
	
	
	
	return (LIBNET_STAT_OK);
}

/**/
int LP_secbeepmachine(){
	
return LP_OK;	
}

int LP_secallwerninng(){
	
	
return LP_OK;	
}

/**/
int LP_secall_shutdown(){
	
	
	
return LP_OK;	
}

/**/
int LP_savedata(){/*ߤΥǡ򥻡֤*/
	
	
	
return LP_OK;	
}

int LP_gethash ( unsigned short * data , int len){
	int cnt;
	int ret = 0;
	for (cnt = 0 ; cnt < len ; cnt++){
		ret = ret * (int)data[cnt];
	}
	return ret;
}


/**********************************************************

		顼åط

**********************************************************/
typedef struct{
	int		lperrno;
	char	title[256];
	char	message[1024]; 
}errtable;

errtable errmessage[MAXERRNOM] = {
/*顼ֹ*/
		{20001 ,

/*ȥ*/ 
		"memory aredy open", 
		/*꤬˥ץ󤵤Ƥ*/

/*н*/
	"The memory was alredy open on same ID \n Dont warry you dont have to do any thing.i\nthis is worninng." } 	,
	/*Ǥ˶꤬ͭץ󤵤Ƥ*/

{  20002,"poll fd alredy open",""},		/*ǤˣƣĤоݤȤϿƤ*/
{  10012,"TCP RAWSERVER connection receive",""},		/*TCP RAWSERVER ³׵*/
{  10011,"UNIX SOC RAWSERVER connection receive",""},		/*UNIX SOC RAWSERVER³׵*/
{  10010,"receive from raw fd",""},		/*RAWFDȯ*/
{  10009,"Got connection request",""},		/*³׵*/
{  10008,"Got connection request",""},		/*³׵*/
{  10007,"Open FD",""},		/*ƣĤ򥪡ץ󤷤*/
{  10006,"FD was not open",""},		/*ץ󤵤Ƥʤ*/
{  10005,"Got signal befor wait event",""},		/*׵ᤵ줿٥ȤΤɤ줫˥ʥ뤬ȯ*/
{  10004,"Lost part of data",""},		/*ʬŪ˥ǡ򼺤ä*/
{  10003,"ID isn't continued",""},		/*ɣĤϢ³Ƥʤ*/
{  10002,"Data buffer shorter than input data",""},		/*ǡХåեξ꾮*/
{  10001,"success",""},		/**/
{ -10001,"FD was not enterd",""},		/*ƣĤäƤʤ*/
{ -10002,"It was no FD entry",""},		/*ƣĤΥȥ꤬ʤ*/
{ -10003,"send error",""},		/**/
{ -10004,"header cant read compleate",""},		/*إåɤ߹ޤʤä*/
{ -10005,"cant alloc memory",""},		/*γݼ*/
{ -10006,"falt make socket",""},		/*åȤκ顼*/
{ -10007,"port nom get error",""},		/*ݡֹμ顼*/
{ -10008,"host name error",""},		/*ۥȥ͡Υåȼ*/
{ -10009,"connect error",""},		/*ͥȥ顼*/
{ -10010,"signal set error",""},		/*ʥΥåȥ顼*/
{ -10011,"Error condition",""},		/* Error condition */
{ -10012,"Hung up",""},		/* Hung up */
{ -10013,"Invalid request: fd not open",""},		/* Invalid request: fd not open */
{ -10015,"Invalid argument",""},		/*Ȥƻꤷ󤬡ƤӽФץΥɥ쥹֤˴ޤޤƤʤ*/
{ -10014,"Other error",""},		/*¾Υ顼*/
{ -10015,"Broken header",""},		/*إåʬƤ*/
{ -10016,"read break with signal",""},		/*ɤ߹ߤΥʥˤ*/
{ -10017,"Invalid request len",""},		/*׵Ĺޤϥޥʥ*/
{ -10018,"break with Invalid signal",""},		/* ͽʤʥˤ*/
{ -10019,"server aredy opened",""},		/*Ǥ˥Хץ󤷤Ƥ*/
{ -10020,"Zero read len",""},		/*Ĺξ*/
{ -10021,"falt to connection",""},		/*³μ*/
{ -10022,"cant read connection stringth",""},		/*³³ʸǤʤä*/
{ -10023,"Full of system max FD nom",""},		/*ƥ¤ǤʾƣĤ򥪡ץǤʤ*/
{ -10024,"read length to short",""},		/*ɤ߹Ĺ*/
{ -10100,"Invalid error",""},		/*¾ͽʤ顼*/
{ -20001,"aredy opend ID",""},		/*Ǥ˥ץ󤵤줿ɣ*/
{ -20002,"aredy opend ID",""},		/*Ǥ˥ץ󤵤줿ɣ*/
{ -20003,"memory attatch error",""},		/*ͭꥢå顼*/
{ -20004,"memory get error",""},		/*ͭꥲåȥ顼*/
{ -20005,"no memory ID entry",""},		/*ͭɣĤϿƤޤ*/
{ -20006,"falt malloc",""},		/*Υޥå˼Ԥޤ*/
{ -20007,"no memory ID entry",""},		/*ͭɣĤϿƤޤ*/
{ -20008,"shared memory not initialized",""},		/*ͭꥳȥ뤬Ƥʤ*/
{ -30001,"",""},
{0,"",""}
};


/*
 *	CSVɤ߹ߴؿ
 *	yamakawa yamakawa@users.sourceforge.jp
 * Copyright (C) 2002
 * */
#if 0
/* CSVɤ߹ */

typedef struct {
    int iOffset;        /* ¤ΤγФؤΥեå(ñ̥Х) */
    void* (*pfConv)( void* pMem, char* pcCSV, int iParam ); /* CSV -> Ѵؿ */
    int iParam;         /* pfConvؿ裳 */
    int iRepeat;        /* ֤ */
    
} CCSVTemplate;
#define CSVTRECORD( iOffset, pfFunc, iParam ) { iOffset, pfFunc, iParam, 1 }
#define CSVTRECORD_ARRAY( iOffset, pfFunc, iParam, iRepeat ) { iOffset, pfFunc, iParam, iRepeat }
#define EndOfCSVTemplate { 0, NULL, 0, 0 }
#define IsEndOfCSVTemplate( p ) ( (p)->pfConv == (void*(*)(void*,char*,int))NULL )

/* ƥץ졼Ȥǻꤵ줿CSVΥǡߤ򤹤롣 */
/* »:CSV1ܤ1024ХȰʲǤ뤳 */
extern int/**/ GetCSV(
    void* pMem,
    char* pcCSV,
    CCSVTemplate* pTemplate
);  
    
/* ƥץ졼Ȥǻꤵ줿CSVΥǡߤ򤹤롣(ƥݥХåեʬѰդ) */
extern int/**/ GetCSV_tmpbuff(
    void* pMem,
    char* pcCSV,
    CCSVTemplate* pTemplate,
    char* pcTmp,    /* CSVɤ߹߻˻Ѥ */
    int sizeTmp
);

/* CSV -> Ѵؿ(CCSVTemplate¤ΤΡpfConv˻ꤹؿ) */
/* ̤δؿͤȤƼΤ褦ʤΤꤵƤ롣 */
/* : */
/*   pMem: */
/*   pCSV:CSV */
/*   iParam:ƴؿͭǽʥѥ᡼ */
/*  */
/*   Υ(iRepeatѻΤ) */
/*   NULLξ硢 */
extern void* CSV_discard( void* pMem, char* pcCSV, int iParam/**/ );  /* CSVʸΤƤ */
extern void* CSV_int( void* pMem, char* pcCSV, int iParam/**/ );      /* CSVʸintѿȤƼ>
 */
extern void* CSV_short( void* pMem, char* pcCSV, int iParam/**/ );    /* CSVʸshortѿȤ>
 */
extern void* CSV_char( void* pMem, char* pcCSV, int iParam/**/ );     /* CSVʸcharѿȤƼ
 */
extern void* CSV_float( void* pMem, char* pcCSV, int iParam/**/ );    /* CSVʸfloatѿȤ>
 */
extern void* CSV_double( void* pMem, char* pcCSV, int iParam/**/ );   /* CSVʸdoubleѿȤ
 */
extern void* CSV_string( void* pMem, char* pcCSV, int iParam/*'\0'ޤʸ*/ ); /* CSVʸʸ
˥ԡ(ü'\0') */
extern void* CSV_memory( void* pMem, char* pcCSV, int iParam/*Хȿ*/ ); /* Τޤޥԡ */
/* ...ޥؿ򼫺ơѤ뤳Ȥǽ (^^)v */

/*Ȥ

Ȥ
typedef struct{
	short nomber1;
	char somestring[30];
}testst;
Τ褦ʹ¤Τä
---------------file start------------------
125,some nomber name
345,string some thing
--------------file end--------------------
ʤդ뤬ä
ƥץ졼Ȥ
static CCSVTemplate tmpl_templateofcsvrec[] = { 
	CSVTRECORD( offsetof( testst, nomber1),CSV_short,0), 
	CSVTRECORD( offsetof( testst,somestring),CSV_string,30),
	EndOfCSVTemplate
};
ä
testst testval;
ե򳫤Ƥ 
ɤ߹ߤʤ饻åȤޤ
while ( fgets( buff, sizeof( buff ), fp ), !feof( fp ) ) {
	memset (&testval , 0 ,sizeof(testst));
	if (FALSE==GetCSV( &testval, buff, tmpl_templateofcsvrec )){
		printf("error of read cvs file\n");
	}   
	printf("print nom[%d] string[%s]\n", testval.nomber1 , testval.somestring);
}
ʴǻȤޤ
*/
#endif

char *LP_net_perror(int l_errno ,char ** message){
char *ret = NULL;
int cnt;

	for (cnt = 0 ; errmessage[cnt].lperrno != 0 ;cnt++){
		if (errmessage[cnt].lperrno == l_errno){
			ret=errmessage[cnt].title;
			if (message !=NULL){
				*message=errmessage[cnt].message;
			}
			break;
		}
	}
	return ret;
}

static char* EscapeCSV( char* pcTmp, char* pcCSV, int sizeTmp )
{
    int count = 0;

    while ( *pcCSV != '\0' && *pcCSV != ',' ) {

        if ( count >= sizeTmp ) {
            /* Ѱդ줿ƥݥХåե礭򤳤硢Ԥ */
            return NULL;
        }
        /* '\'(ʸ) */
        if ( *pcCSV == '\\' ) {
            /* '\'μʸ롣 */
            *pcTmp++ = *( pcCSV + 1 );
            pcCSV += 2;
        }
        else {
            /* ̾ʸϤΤޤޥԡ롣 */
            *pcTmp++ = *pcCSV++;
        }
        ++count;
    }
    *pcTmp = '\0';

    return ++pcCSV;
}

/*
 *  * ãӣʸ󤫤鹽¤Τ˥쥳ɤ򥻥åȤ */
int GetCSV( void* pMem, char* pcCSV, CCSVTemplate* pTemplate )
{
    char pcTmp[ 1024 ];

    return GetCSV_tmpbuff( pMem, pcCSV, pTemplate, pcTmp, sizeof( pcTmp ) );
}

/*
 *  *  */
int GetCSV_tmpbuff(
    void*           pMem,
    char*           pcCSV,
    CCSVTemplate*   pTemplate,
    char*           pcCSVTmp,
    int             sizeCSVTmp )
{
    while ( !IsEndOfCSVTemplate(pTemplate) ) {

        int     i;
        char*   pMemTmp = (char*)pMem + pTemplate->iOffset;

        for ( i = 0 ; i < pTemplate->iRepeat ; ++i ) {
            pcCSV = EscapeCSV( pcCSVTmp, pcCSV, sizeCSVTmp );
            if ( !pcCSV ) {
                return FALSE;
            }
            pMemTmp = pTemplate->pfConv( (char*)pMemTmp, pcCSVTmp,
                pTemplate->iParam );
            if ( !pMemTmp ) {
                return FALSE;
            }
        }
        ++pTemplate;
    }

    return TRUE;
}

/*
 *  * ɤФȤ˻Ѥޤ */
void* CSV_discard(
    void*   pMem/*ߡ*/,
    char*   pcCSV/*ߡ*/,
    int     iParam/*ߡ*/
)
{
    return pMem;
}

/*
 *  * ѴСintegerλ˻Ѥޤ */
void* CSV_int( void* pMem, char* pcCSV, int iParam/**/ )
{

    *(int*)pMem = atoi( pcCSV );
    return (int*)pMem + 1;
}

void* CSV_uint( void* pMem, char* pcCSV, int iParam/**/ )
{

    *(int*)pMem = atoi( pcCSV );
    return (unsigned int*)pMem + 1;
}

/*
 *  * ѴСintegerλ˻Ѥޤ */
void* CSV_short( void* pMem, char* pcCSV, int iParam/**/ )
{

    *(short*)pMem = atoi( pcCSV );
    return (short*)pMem + 1;
}

void* CSV_ushort( void* pMem, char* pcCSV, int iParam/**/ )
{

    *(short*)pMem = atoi( pcCSV );
    return (unsigned short*)pMem + 1;
}
/*
 *  * ѴСcharλ˻Ѥޤ */
void* CSV_char( void* pMem, char* pcCSV, int iParam/**/ )
{
    *(char*)pMem = atoi( pcCSV );
    return (char*)pMem + 1;
}

void* CSV_uchar( void* pMem, char* pcCSV, int iParam/**/ )
{
    *(char*)pMem = atoi( pcCSV );
    return (unsigned char*)pMem + 1;
}

/*
 *  * ѴСʸ(NULLȥå)λ˻Ѥޤ */
void* CSV_string( void* pMem, char* pcCSV, int iParam/*ʸ*/ )
{
    strncpy( pMem, pcCSV, iParam );
    return (char*)pMem + iParam;
}

/*
 *  * ѴСʸ(NULLȥåפʤ)λ˻Ѥޤ */
void* CSV_memory( void* pMem, char* pcCSV, int iParam/*ʸ*/ )
{
    memcpy( pMem, pcCSV, iParam );
    return (char*)pMem + iParam;
}

/*
 *  * ѴСfloatλ˻Ѥޤ */
void* CSV_float( void* pMem, char* pcCSV, int iParam/*ʸ*/ )
{
    *(float*)pMem = (float)atof( pcCSV );
    return (float*)pMem + 1;
}

/*
 *  * ѴСdoubleλ˻Ѥޤ */
void* CSV_double( void* pMem, char* pcCSV, int iParam/*ʸ*/ )
{
    *(double*)pMem = atof( pcCSV );
    return (double*)pMem + 1;
}



