<?php
	global $Ktai_Style, $Redir; // passed from ktai_style/redir.php
?>
<html><head>
<meta http-equiv="Content-Type" content="<?php ks_mimetype(); ?>; charset=<?php ks_charset(); ?>" />
<title><?php _e('Redirect', 'spanner'); ?></title>
</head><body>
<?php if (is_object($Redir) && isset($Redir->full_url)) : ?>
	<p><?php _e('You are about to jump to an external website.', 'spanner'); ?>
	<?php if (! isset($Redir->mobile_url) || empty($Redir->mobile_url)) { ?>
		<p><?php _e('Click below', 'spanner'); ?><br />
		<a href="<?php echo attribute_escape($Redir->url); ?>"><?php echo htmlspecialchars($Redir->full_url, ENT_QUOTES); ?></a>
	<?php } else { ?>
		<br /><?php _e('A URL for cellphones/mobile terminals is found.', 'spanner'); ?></p>
		<p><?php _e('Click below', 'spanner'); ?><br />
		<a href="<?php echo attribute_escape($Redir->mobile_url); ?>"><?php echo htmlspecialchars($Redir->mobile_url, ENT_QUOTES); ?></a>
		<?php if (! $Redir->same_host) { ?>
			<br /><font color="red"><?php _e('The host is diffrent from the origial. Make sure the valid mobile site.', 'ktai_style'); ?></font>
		<?php }
		if ($Redir->full_url != $this->mobile_url) { ?>
			</p><p><?php _e('The original URL is below. If you can not view the site properly with the above address, please try the below URL.', 'spanner'); ?></p>
			<p><?php _e('Click below', 'spanner'); ?><br />
			<a href="<?php echo attribute_escape($Redir->url); ?>"><?php echo htmlspecialchars($Redir->full_url, ENT_QUOTES); ?></a>
		<?php }
	}

	if ($Ktai_Style->is_ktai() == 'KDDI' && $Ktai_Style->get('type') == 'WAP2.0') {
		echo '<br />'. sprintf(__('(<a %s>View the site by PC Site Viewer.</a>)', 'ktai_style'), ' href="device:pcsiteviewer?url=' . attribute_escape($Redir->full_url) . '"');
	} elseif ($Ktai_Style->is_ktai() == 'DoCoMo' && $Ktai_Style->get('type') == 'FOMA') {
		echo '<br />'. sprintf(__('(<a %s>View the site by Full Browser.</a>)', 'ktai_style'), 'href="' . attribute_escape($Redir->full_url) . '" ifb="' . attribute_escape($Redir->full_url) . '"');
	} ?></p><?php 

	if (! isset($Redir->mobile_url) || ! $Redir->mobile_url) :
		$sjk_link = 'http://www.sjk.co.jp/c/w.exe?y=' . rawurlencode(preg_replace('|^http://|', '', $Redir->full_url));
		_e('The website of above URL may not be displayed properly with mobile phones. But, it could be shown better with below URL.', 'spanner'); ?></p>
		<p><?php _e('Click below', 'spanner'); ?><br />
		<a href="<?php echo $sjk_link; ?>"><?php echo $sjk_link; ?></a></p>
	<?php endif; // can't use brace
else: // $Redir ?>
	<p><?php _e("A certain time has elapsed since you viewed the page, the link to exteral sites has became invalid.<br />¥nGo back the previous page and reload it. After that, retry clicking the link.", 'ktai_style'); ?></p>
<?php endif; ?>
<hr />
<p><?php _e('Please return to the previous page with Back button of mobile phone.', 'spanner'); ?></p><hr />
<?php ks_footer(); ?>