<?php if (! ks_is_comments()) {
	return;
}
$need_password = ks_check_password(ks_is_comments_list() ?
	__('Enter your password to view comments.') : 
	__('Enter your password to post a comment.', 'ktai_style'));
if ($need_password && ! is_user_logged_in()) {
	echo $need_password;
	return;
}

function ks_comment_content() {
	global $comment; ?>
	<a name="comment-<?php comment_ID(); ?>"><?php comment_author(); ?>(<?php comment_date('Y-m-d H:i:s'); ?>)</a><br />
	<?php comment_text();
}

global $post_count;
if (ks_is_comments_list()) : ?>
	<h2><?php printf(__('%1$d. Comments for %2$s(%3$s)', 'spanner'), $post_count, get_the_title(), ks_get_time()); ?></h2>
	<?php 
	if (ks_option('ks_separate_comments')) {
		$sep_comments = ks_separete_comments($comments);
		$label = array('comment' => __('Comments'), 'pings' => __('Pings', 'ktai_style'));
	} else {
		$sep_comments[] = $comments;
		$label = array();
	}
	foreach ($sep_comments as $type => $_comments) :
		if (isset($label[$type])) {
			echo '<hr /><h3>' . $label[$type] . '</h3>';
		}
		if (count($_comments)) :
			foreach ($_comments as $comment) : ?>
				<hr /><?php ks_comment_content();
				if (function_exists('comment_reply_link')) {
					comment_reply_link('before=[%20&after=%20]&depth=1&max_depth=999', $comment);
				}
			endforeach;
		else : // If there are no comments yet ?>
			<p><?php echo ($type == 0) ? __('No comments yet.') : __('No pings yet.', 'ktai_style'); ?></p>
		<?php endif;
	endforeach; 
	ks_comments_post_link(NULL, '<hr />', '<hr />', ks_pict_number(8), '8');
	ks_back_to_post(ks_pict_number(0), __('Back to the article', 'spanner'), '0'); ?>
	<hr /><div><a href="<?php ks_blogurl(); ?>?menu=comments"><?php _e('Back to recent comments', 'spanner'); ?></a></div>
<?php elseif (ks_is_comment_post()) : ?>
	<h2><?php printf(__('Post a comment for %1$d. %2$s(%3$s)', 'spanner'), $post_count, get_the_title(), ks_get_time()); ?></h2>
	<hr />
	<?php if (! comments_open()) { ?>
		<p><?php _e('Sorry, the comment form is closed at this time.'); ?></p>
	<?php } elseif ( get_option('comment_registration') && ! is_user_logged_in() ) {
		if (ks_admin_url(false)) { ?>
			<p><?php printf(__('You must be <a href="%s">logged in</a> to post a comment.'), ks_plugin_url(false) . 'login.php?redirect_to=' . urlencode(ks_comments_post_url()));?></p>
		<?php } else { ?>
			<p><?php _e("Can't post a comment from mobile phones. You must logged in from PC to make a comment.", 'ktai_style'); ?></p>
		<?php }
	} else {
		$replytocom = isset($_GET['replytocom']) ? abs(intval($_GET['replytocom'])) : NULL;
		if ($replytocom) {
			$comment = get_comment($replytocom);
			if (! $comment || $comment->comment_approved != 1) {
				return;
			}
			ks_comment_content(); ?>
			<hr />
			<h3><?php _e('Reply to the above comment', 'ktai_style'); ?></h3><?php 
		}
		global $ks_commentdata;
		if (isset($ks_commentdata['message']) && $ks_commentdata['message']) {
			$comment_author       = $ks_commentdata['author'];
			$comment_author_email = $ks_commentdata['email'];
			$comment_author_url   = $ks_commentdata['url'];
			$comment_content      = $ks_commentdata['content'];
			?><p><font color="red"><?php echo implode("<br />", array_map('wp_specialchars', explode("\n", $ks_commentdata['message']))); ?></font></p><?php 
		}
		ks_require_term_id_form(ks_plugin_url(false) . 'comments-post.php');
		ks_fix_encoding_form();
		if ( is_user_logged_in() ) {
			ks_session_id_form(); ?>
			<p><?php printf(__('Logged in as %s.', 'ktai_style'), wp_specialchars($user_identity));
			?> [<a href="<?php echo attribute_escape(ks_get_logout_url()); ?>"><?php _e('Log out'); ?></a>]<br />
			<small><?php _e('Note: Ater posting a comment, you are automatically logged out.', 'ktai_style'); ?></small><br />
		<?php } else {
			if (ks_admin_url(false)) {
				?><div align="right"><?php printf(__('<a href="%s">Log in</a> and post a comment.', 'ktai_style'), ks_plugin_url(false) . 'login.php?redirect_to=' . urlencode(ks_comments_post_url()));?></div><?php 
			}
			?><p><?php _e('Name'); if ($req) { _e('(required)', 'spanner'); } ?><br />
			<input type="text" name="author" value="<?php echo attribute_escape($comment_author); ?>" /><br />
			<?php _e('E-mail', 'spanner'); if ($req) { _e('(required)', 'spanner'); } ?><br />
			<input type="text" name="email" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_email); ?>" /><br />
			<?php _e('URL', 'spanner'); ?><br />
			<input type="text" name="url" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_url); ?>" /><br />
		<?php } // is_user_logged_in()
		_e('Comment (required)', 'spanner'); ?><br />
		<textarea name="comment" cols="100%" rows="4"><?php echo wp_specialchars($comment_content); ?></textarea><br />
		<?php _e('There is a moment after pressing "Send"<br />
You might meet a time-out according to the environment. But, writing is completed.<br />
Please never push "Send" twice.', 'spanner'); ?><br />
		<input type="submit" name="submit" value="<?php _e('Send', 'spanner'); ?>" />
		<?php if (function_exists('comment_id_fields')) {
			comment_id_fields();
		} else { ?>
			<input type="hidden" name="comment_post_ID" value="<?php echo intval($id); ?>" />
		<?php } 
		ks_do_comment_form_action(); ?>
		</form>
		<?php if (ks_is_required_term_id()) { ?>
			<div><?php _e('NOTE: If submit comments, your terminal ID will be sent.', 'ktai_style'); ?></div>
		<?php }
		if (! is_user_logged_in() && ks_cookie_available()) { ?>
			<div><?php _e('NOTE: Your name, e-mail and URL will be stored o your phone. (If cookie is ON)', 'ktai_style'); ?></div>
		<?php }
	} // comments_open, comment_registration ?>
	<hr /><?php ks_back_to_post(ks_pict_number(0), __('Back', 'spanner'), '0');
endif; // $need_password, ks_is_comments_list, ks_is_comments_post
?>