/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdsender.h"

#include <kapplication.h>
#include <kio/job.h>
#include <kdebug.h>
#include <klocale.h>
#include <qfile.h>
#include <qstring.h>
#include <qcstring.h>
#include <qdatastream.h>

#define EOL "\r\n"
using namespace KKDSubscribeTemplate;

KKDSender::KKDSender( QObject* parent )
	: QObject( parent )
	, m_strResult( 0 )
{
}

KKDSender::~KKDSender()
{
}

QString KKDSender::addText( const QString& name, const QString& value )
{
	QString str = "Content-Disposition: form-data; name=\"" + KURL::encode_string( name ) + "\"" + EOL
				+ EOL
				+ KURL::encode_string( value )
				;
	QCString cstr( "" );
	cstr += str;
	m_strsFormData += cstr;
	return QString::null;
}

QString KKDSender::addFile( const QString& name, const QString& value )
{
kdDebug() << "QString KKDSender::addFile( const QString& name, const QString& value )" << endl;
	QCString cstr( "Content-Disposition: form-data; name=\"" + KURL::encode_string( name ) + "\"; filename=\"" + KURL::encode_string( value ) + "\"" + EOL
				+ "Content-Type: application/octet-stream" + EOL
				+ EOL );

	QFile file( value );
	if( !file.open( IO_ReadOnly ) )
	{
		return i18n( "Can not open %1" ).arg( value );
	}
	QByteArray cbuf( 0 );
	cbuf.resize( file.size() + 1 );
	const int i = file.readBlock( cbuf.data(), file.size() );
	cbuf[i] = '\0';
	file.close();

	const uint old_size = cstr.length();
	cstr.resize( old_size + cbuf.size() );
	memcpy( cstr.data() + old_size, cbuf.data(), cbuf.size() );
	kdDebug() << i << "\t" << file.size() << "\t" << cstr.size() << endl;
	m_strsFormData += cstr;
kdDebug() << "QString KKDSender::addFile( const QString& name, const QString& value )" << endl;
	return QString::null;
}

bool KKDSender::send()
{
kdDebug() << "bool KKDSender::send()" << endl;
	// decide boundary string
	QString strBoundary =  "----------" + KApplication::randomString( 42 + 13 );
	while( 1 )
	{
		bool bl = false;
		for( QCStringList::Iterator it = m_strsFormData.begin(); it != m_strsFormData.end(); ++it )
		{
			if( (*it).find( strBoundary ) >= 0 )
			{
				bl = true;
				break;
			}
		}
		if( !bl ) break;
		strBoundary =  "----------" + KApplication::randomString( 42 + 13 );
	}
	QCString cstr( 0 );
	for( QCStringList::Iterator it = m_strsFormData.begin(); it != m_strsFormData.end(); ++it )
	{
		QCString hstr( "--" );
		hstr += strBoundary;
		hstr += EOL;
		const uint old_size = cstr.size();
		cstr.resize( old_size + hstr.length() + (*it).size() + 1 );
		memcpy( cstr.data() + old_size, hstr.data(), hstr.length() );
		memcpy( cstr.data() + old_size + hstr.length(), *it, (*it).size() );
		cstr[cstr.size()-2] = '\r';
		cstr[cstr.size()-1] = '\n';
kdDebug() << cstr.size() << endl;
	}

	QCString endstr( "--" + strBoundary + "--" + EOL );
	const uint old_size = cstr.size();
	cstr.resize( old_size + endstr.length() );
	memcpy( cstr.data() + old_size, endstr.data(), endstr.length() );

kdDebug() << cstr << endl;
kdDebug() << cstr.size() << endl;
	KURL url( "http://linux-life.net/program/cc/kde/app/kreetingkard/" );
	KIO::Job* job = KIO::http_post( url, cstr, true );
	job->addMetaData( "content-type", "Content-Type: multipart/form-data; boundary=" + strBoundary );
	connect( job, SIGNAL( data( KIO::Job*, const QByteArray& ) ), this, SLOT( data( KIO::Job*, const QByteArray& ) ) );
	connect( job, SIGNAL( result( KIO::Job* ) ), this, SLOT( result( KIO::Job* ) ) );
kdDebug() << "bool KKDSender::send()" << endl;
	return true;
}

void KKDSender::data( KIO::Job*, const QByteArray& arr )
{
kdDebug() << "void KKDSender::data( KIO::Job*, const QByteArray& arr )" << endl;
	m_strResult += arr;
kdDebug() << "void KKDSender::data( KIO::Job*, const QByteArray& arr )" << endl;
}

void KKDSender::result( KIO::Job* job )
{
kdDebug() << "void KKDSender::result( KIO::Job* job )" << endl;
	if( job->error() ) job->showErrorDialog( 0L );
kdDebug() << "void KKDSender::result( KIO::Job* job )" << endl;
}
