/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdcategoryitem.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKDSubscribeTemplate;

KKDCategoryItem::KKDCategoryItem( QDomElement elem )
	: m_title( QString::null )
	, m_path( QString::null )
{
	if( elem.hasAttribute( "path" ) )
	{
		m_path = elem.attribute( "path" );
	}
	QString lang = KGlobal::locale()->language();
	for( QDomNode node = elem.firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		QDomElement e = node.toElement();
		if( e.tagName() == "title" )
		{
			if( ( e.attribute( "lang" ) == "C" && m_title.isNull() ) || e.attribute( "lang" ) == lang )
			{
				m_title = e.text();
			}
		}
		else if( e.tagName() == "category" )
		{
			m_list.append( new KKDCategoryItem( e ) );
		}
	}
	m_list.setAutoDelete( true );
}
