/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KKDPAPER_H_
#define _KKDPAPER_H_

#include "kkdimageitem.h"

#include <qptrlist.h>

// #define SIZE 379, 567

namespace KKDesigner
{
	/**
	 * @short Paper class
	 * It has paper's property and child items.
	 * @author SUZUKI Tasuku <tasuku@linux-life.net>
	 * @see KKDImageItem
	 */
	class KKDPaper : public KKDImageItem, public QPtrList<KKDItemBase>
	{
		Q_OBJECT
		Q_PROPERTY( bool imagePrint READ imagePrint WRITE setImagePrint )
	public:
		enum PrintType
		{
			Plain,
			Insert,
		};
		KKDPaper( const QPoint& l, const QSize& s, QObject* parent = 0 );
		KKDPaper( QDomElement e, QObject* parent = 0 );
		KKDPaper( KKDPaper* paper, QObject* parent = 0 );
		~KKDPaper();

		static const QString tagName(){ return QString( "Paper" ); }
		QDomElement toElement( QDomDocument& doc, const QString& t = tagName() );

		//BEGIN Properties
		virtual ItemType type() const { return Paper; }

		virtual bool imagePrint() const { return m_imagePrint; }
		//END   Properties

		PrintType printType();
	public slots:
		//BEGIN Properties
		void setImagePrint( bool p );
		//END   Properties

	signals:
		//BEGIN Properties
		void imagePrintChanged();
		//END   Properties

	protected:
		virtual void drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );
		virtual void drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );

	private:
		bool m_imagePrint;
	};
}

#endif /* _KKDPAPER_H_ */
