/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdaddress.h"
#include "../kkaddressbook/kkacontactdata.h"

#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>

using namespace KKDesigner;

KKDAddress::KKDAddress( const QPoint& l
					  , const QSize& s
					  , const QFont& f
					  , const QColor& c
					  , Orientation o
					  , QObject* parent
					  )
	: KKDTextBase( l, s, f, c, o, parent )
{
}

KKDAddress::KKDAddress( QDomElement e, QObject* parent )
	: KKDTextBase( e, parent )
{
}

KKDAddress::KKDAddress( const KKDAddress* item, QObject* parent )
	: KKDTextBase( (KKDTextBase*)item, parent )
{
}

KKDAddress::~KKDAddress()
{
}

QDomElement KKDAddress::toElement( QDomDocument& doc, const QString& t )
{
	QString tag( t == QString::null ? tagName() : t );
	return KKDTextBase::toElement( doc, tag );
}

void KKDAddress::drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDTextBase::drawItemBefore( r, p, m, d );
	switch( m )
	{
		case AddressMode:
		case PrintMode:
			if( d != NULL )
			{
				if( d->const_current()->country() == "jp" )
				{
					drawTextJP( r, p, d );
				}
				else
				{
					p.drawText( r, AlignCenter, d->const_current()->address() );
				}
			}
			break;
		default:
			drawText( r, p, AlignCenter, i18n( "@Address" ) );
			break;
	}
}

void KKDAddress::drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d )
{
	KKDTextBase::drawItemAfter( r, p, m, d );
	switch( m )
	{
		case DesignMode:
		{
			QPixmap pxm = SmallIcon( "kk_address" );
			p.drawPixmap( QRect( rect().topLeft(), pxm.size() ), pxm );
			break;
		}
		default:
			break;
	}
}

void KKDAddress::drawTextJP( QRect& r, QPainter& p, const KKAddressBook::KKAContactData* d )
{
	QString str = d->const_current()->address();
	switch( orientation() )
	{
		case Horizontal:
		{
			QStringList line = QStringList::split( "\n", str, true );
			while( line.count() > 0 && line.last() == "" )
			{
				line.pop_back();
			}
			QRect rct( r );
			int size_decrease = 0;
			while( 1 )
			{
				QSize totalSize;
				for( QStringList::Iterator it = line.begin(); it != line.end(); ++it )
				{
					QSize s = calcSize( *it, size_decrease );
					if( totalSize.width() < s.width() ) totalSize.setWidth( s.width() );
					totalSize.setHeight( totalSize.height() + s.height() );
				}
				if( rct.width() < totalSize.width() || rct.height() < totalSize.height() )
				{
					size_decrease++;
				}
				else
				{
					break;
				}
			}
			for( QStringList::Iterator it = line.begin(); it != line.end(); ++it )
			{
				QSize s = calcSize( *it, size_decrease );
				rct.setHeight( s.height() );
				drawText( rct, p, it == line.begin() ? AlignLeft : AlignRight, *it, size_decrease );
				rct.moveTop( rct.top() + s.height() );
			}
			break;
		}
		case Vertical:
		{
			QStringList line = QStringList::split( "\n", str, true );
			while( line.count() > 0 && line.last() == "" )
			{
				line.pop_back();
			}
			QRect rct( r );
			int size_decrease = 0;
			while( 1 )
			{
				QSize totalSize;
				for( QStringList::Iterator it = line.begin(); it != line.end(); ++it )
				{
					QSize s = calcSize( *it, size_decrease );
					if( totalSize.height() < s.height() ) totalSize.setHeight( s.height() );
					totalSize.setWidth( totalSize.width() + s.width() );
				}
				if( rct.width() < totalSize.width() || rct.height() < totalSize.height() )
				{
					size_decrease++;
				}
				else
				{
					break;
				}
			}
			int right = rct.right();
			for( QStringList::Iterator it = line.begin(); it != line.end(); ++it )
			{
				QSize s = calcSize( *it, size_decrease );
				rct.setWidth( s.width() );
				rct.moveRight( right );
				drawText( rct, p, it == line.begin() ? AlignTop : AlignBottom, *it, size_decrease );
				right -= s.width();
			}
			break;
		}
	}
}
