/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAPERSONWIDGET_H_
#define _KKAPERSONWIDGET_H_

#include <qhbox.h>
#include <kcombobox.h>
#include <klineedit.h>

namespace KKAddressBook
{
	class KKAPersonalData;
	/**
	 * @author SUZUKI Tasuku
	 */
	class KKAPersonWidget : public QHBox
	{
		Q_OBJECT
	public:
		KKAPersonWidget( QWidget* parent = 0, const char* name = 0 );
		~KKAPersonWidget();

		QString prefix() const { return m_prefix->currentText(); }
		QString name() const { return m_name->text(); }
		QString suffix() const { return m_suffix->currentText(); }

	public slots:
		void setData( KKAPersonalData* data );

	signals:
		void nameChanged( const QString& );

	private:
		KComboBox* m_prefix;
		KLineEdit* m_name;
		KComboBox* m_suffix;
		KKAPersonalData* m_data;
	};

}

#endif /* _KKAPERSONWIDGET_H_ */
