/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAPERSONALDATA_H_
#define _KKAPERSONALDATA_H_

#include <qobject.h>

class QDomDocument;
class QDomElement;

namespace KKAddressBook
{
	/**
	* @english
	* @short Personal Data
	* This class includes prefix, firstname, middlename, lastname and suffix.
	*
	* @author SUZUKI Tasuku
	* @endenglish
	*/
	class KKAPersonalData : public QObject
	{
		Q_OBJECT
		Q_PROPERTY( QString prefix READ prefix WRITE setPrefix )
		Q_PROPERTY( QString name READ name WRITE setName )
		Q_PROPERTY( QString suffix READ suffix WRITE setSuffix )

	public:
		KKAPersonalData( QObject* parent );
		KKAPersonalData( QObject* parent
					   , const QString& prefix
					   , const QString& name
					   , const QString& suffix
					   );
		KKAPersonalData( QObject* parent, QDomElement e );

		~KKAPersonalData();

		static const QString tagName(){ return "personaldata"; }
		virtual QDomElement toElement( QDomDocument& doc );

		const QString& prefix() const { return m_prefix; }
		const QString& name() const { return m_name; }
		const QString& suffix() const { return m_suffix; }
		QString familyName() const;
		QString givenName() const;
		bool isValid() const;

	public slots:
		void setPrefix( const QString& prefix );
		void setName( const QString& name );
		void setSuffix( const QString& suffix );

	signals:
		void updated();

	private:
		QString m_prefix;
		QString m_name;
		QString m_suffix;
	};
}

#endif /* _KKAPERSONALDATA_H_ */
