/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkahomeaddress.h"

#include <qdom.h>

using namespace KKAddressBook;

KKAHomeAddress::KKAHomeAddress( QObject* parent )
 : KKAAddressData( parent, Home )
{
	for( uint i = count(); i != KKAHomeAddress::JointNameCount; i++ )
	{
		KKAPersonalData* d = new KKAPersonalData( this );
		append( d );
		connect( d, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	}
}

KKAHomeAddress::KKAHomeAddress( QObject* parent
							  , const QString& c
							  , const QString& z
							  , const QString& a
							  )
 : KKAAddressData( parent
 				 , Home
 				 , c
 				 , z
 				 , a
 				 , None
 				 )
{
	for( uint i = count(); i != KKAHomeAddress::JointNameCount; i++ )
	{
		KKAPersonalData* d = new KKAPersonalData( this );
		append( d );
		connect( d, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	}
}

KKAHomeAddress::KKAHomeAddress( QObject* parent, QDomElement& e )
 : KKAAddressData( parent, e )
{
	for( QDomNode child = e.firstChild(); !child.isNull(); child = child.nextSibling() )
	{
		KKAPersonalData* d = new KKAPersonalData( this, child.toElement() );
		append( d );
		connect( d, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	}
	for( uint i = count(); i != KKAHomeAddress::JointNameCount; i++ )
	{
		KKAPersonalData* d = new KKAPersonalData( this );
		append( d );
		connect( d, SIGNAL( updated() ), this, SIGNAL( updated() ) );
	}
}

KKAHomeAddress::~KKAHomeAddress()
{
}

QDomElement KKAHomeAddress::toElement( QDomDocument& doc )
{
	QDomElement elem = KKAAddressData::toElement( doc );
	for( KKAPersonalData* child = first(); child; child = next() )
	{
		elem.appendChild( child->toElement( doc ) );
	}
	return elem;
}
