/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAADDRESSWIDGET_H_
#define _KKAADDRESSWIDGET_H_

#include <qgrid.h>

class KLanguageButton;
class KLineEdit;
class KTextEdit;
class QToolButton;

namespace KKAddressBook
{
	class KKAAddressData;
	class KKAZipcodeEdit;

	/**
	 * @author SUZUKI Tasuku
	 */
	class KKAAddressWidget : public QGrid
	{
		Q_OBJECT
	public:
		KKAAddressWidget( QWidget* parent = 0, const char* name = 0 );

		~KKAAddressWidget();

		QString country() const;

	public slots:
		void setData( KKAAddressData* data );

	signals:
		void countryChanged( const QString& );
		void zipcodeChanged( const QString& );
		void addressChanged( const QString& );

	private slots:
		void setAddress();
		void zipcode2address();
		void setup();
		void setup( const QString& country );

	private:
		void setupWidgets();
		void loadCountry();

		KLanguageButton* m_country;
		KKAZipcodeEdit* m_zipcode;
		QToolButton* m_zipcode2address;
		KTextEdit* m_address;
		QToolButton* m_setup;

		KKAAddressData* m_data;
	};
}

#endif /* _KKAADDRESSWIDGET_H_ */
