/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAADDRESSMANAGERJP_H_
#define _KKAADDRESSMANAGERJP_H_

#include "kkaaddressmanager.h"

#include <kdialogbase.h>
#include <qstring.h>

#define DATAFILE "zipcode_ja.txt"
#define JAPANPOST "http://www.post.japanpost.jp/zipcode/dl/oogaki/lzh/ken_all.lzh"

namespace KKAddressBook
{
	/**
	 * @author SUZUKI Tasuku
	 */
	class KKAAddressManagerJP : public KKAAddressManager
	{
	public:
		KKAAddressManagerJP();
		~KKAAddressManagerJP();

		virtual QString mask();
		virtual bool isEmpty( QString zipcode );
		virtual bool available();
		virtual bool setup( QWidget* parent );
		virtual QString zipcode2address( QString zipcode );

	protected:
		virtual void readConfig( KConfig* conf );
		virtual void saveConfig( KConfig* conf );

	private:
		bool checkLha( QWidget* parent );
		void cache();
		QString m_datafile;
		QStringList m_data;
	};

	class KKAAddressManagerJPDialog : public KDialogBase
	{
		Q_OBJECT
	public:
		KKAAddressManagerJPDialog( QWidget* parent = 0, const char* name = 0 );
		~KKAAddressManagerJPDialog();
	};
}

#endif /* _KKAADDRESSMANAGERJP_H_ */
