/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <stdlib.h>

#include "kkapplication.h"
#include "kreetingkard.h"
#include "kkaddressbook/kkaaddressmanager.h"

static const char description[] =
	I18N_NOOP("A Greeting Card Editor for KDE");

static const char version[] = "0.6.1";

static KCmdLineOptions options[] =
{
	{ "+file", I18N_NOOP("File"), 0 },
	KCmdLineLastOption
};

int main(int argc, char **argv)
{
	KAboutData about( "kreetingkard", I18N_NOOP("KreetingKard"), version, description,
				KAboutData::License_GPL, I18N_NOOP("(C) 2004-, KreetingKard developers"), 0, "http://linux-life.net/program/cc/kde/app/kreetingkard/", "tasuku@linux-life.net");
	about.addAuthor( I18N_NOOP("Tasuku Suzuki"), I18N_NOOP("Author"), "tasuku@linux-life.net", "http://linux-life.net/" );
	about.addAuthor( I18N_NOOP("Kazuki Ohta"), I18N_NOOP("Developer"), "mover@hct.zaq.ne.jp", "http://mover.cool.ne.jp/" );
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );
	KKApplication::addCmdLineOptions();

	if ( !KKApplication::start() )
	{
		exit(0);
	}

	KKApplication app;
// 	app.disableSessionManagement();

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	int i = app.exec();
	KKAddressBook::KKAAddressManager::destruct();
	return i;
}

