/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdview.h"
#include "kkdcanvas.h"
#include "kkddoc.h"
#include "kkdpaper.h"
#include "kkditemdialog.h"

#define MMPERPIXEL 2.6
#include <math.h>

#include <qfile.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qdom.h>

#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>


using namespace KKDesigner;

KKDView::KKDView( KKDItemBase::DrawMode m, KKDDoc* doc, QWidget* parent, const char* name )
	: QScrollView( parent, name )
	, m_zoom( 0 )
	, m_doc( doc )
	, m_mode( m )
	, m_data( NULL )
{
	connect( m_doc, SIGNAL( documentChanged() ), this, SLOT( documentChanged() ) );

	viewport()->setPaletteBackgroundColor( gray );
	QGridLayout* grid = new QGridLayout( viewport(), 3, 3 );

	wgtMain = new QWidget( viewport() );
	grid->addWidget( wgtMain, 1, 1, Qt::AlignCenter );
	addChild( wgtMain );

// 	m_canvas.setAutoDelete( true );
	wgtMain->setBackgroundMode( X11ParentRelative );
	wgtMain->hide();
}

KKDView::~KKDView()
{
}

void KKDView::documentChanged()
{
	while( m_canvas.count() > 0 )
	{
		KKDCanvas* w = m_canvas.at( 0 );
		m_canvas.removeFirst();
		delete w;
	}
	m_canvas.clear();
	wgtMain->hide();

	int i = 0;
	int iCurrent = 0;
	for( KKDPaper* paper = m_doc->first(); paper; paper = m_doc->next() )
	{
		KKDCanvas* w = new KKDCanvas( m_mode, paper, wgtMain );
		w->setContactData( m_data );
		m_canvas.append( w );
		if( m_mode == KKDItemBase::DesignMode )
		{
			connect( m_doc, SIGNAL( inserted( KKDItemBase*, KKDPaper* ) ), w, SLOT( itemInserted( KKDItemBase*, KKDPaper* ) ) );
			connect( m_doc, SIGNAL( removed( KKDItemBase*, KKDPaper* ) ), w, SLOT( itemRemoved( KKDItemBase*, KKDPaper* ) ) );
		}
		connect( w, SIGNAL( resized() ), this, SLOT( setLayout() ) );
		w->show();
		if( paper->printType() == KKDPaper::Insert )
		{
			iCurrent = i;
		}
		i++;
	}

	if( m_canvas.count() )
	{
		m_canvas.at( iCurrent )->raise();
		m_doc->setCurrentIndex( iCurrent );
		setZoom( 1 );
		wgtMain->show();
	}
}

void KKDView::setLayout()
{
	QSize size[2] = { m_canvas.at(0)->size(), m_canvas.at(1)->size() };
	double z = zoom();
	if( size[0].width() + size[1].height() != size[0].height() + size[1].width() )
	{
		// different orientation
		wgtMain->setFixedSize( (int)(1480 * z / MMPERPIXEL), (int)(1480 * z / MMPERPIXEL) );
		if( size[0].width() < size[0].height() )
		{
			// 0 - LandScape
			// 1 - Portrait
			m_canvas.at(0)->move( (int)((1480-1000) / 2 / MMPERPIXEL), 0 );
			m_canvas.at(1)->move( 0, (int)((1480-1000) / 2 / MMPERPIXEL) );
		}
		else
		{
			// 0 - LandScape
			// 1 - Portrait
			m_canvas.at(0)->move( 0, (int)((1480-1000) / 2 / MMPERPIXEL) );
			m_canvas.at(1)->move( (int)((1480-1000) / 2 / MMPERPIXEL), 0 );
		}
	}
	else
	{
		if( size[0].width() < size[0].height() )
		{
			// both - LandScape
			wgtMain->setFixedSize( (int)((1000+100) * z / MMPERPIXEL), (int)((1480+100) * z / MMPERPIXEL) );
		}
		else
		{
			// both - Portrait
			wgtMain->setFixedSize( (int)((1480+100) * z / MMPERPIXEL), (int)((1000+100) * z / MMPERPIXEL) );
		}
		m_canvas.at(0)->move( 0, 0 );
		m_canvas.at(1)->move( (int)(100 / MMPERPIXEL), (int)(100 / MMPERPIXEL) );
	}
}

void KKDView::setContactData( const KKAddressBook::KKAContactData* d )
{
	m_data = d;
	for( KKDCanvas* w = m_canvas.first(); w; w = m_canvas.next() )
	{
		w->setContactData( d );
	}
}

double KKDView::zoom()
{
	if( m_zoom < 0 )
	{
		return -1.0 / (double)m_zoom;
	}
	else
	{
		return m_zoom;
	}
}

void KKDView::setZoom( int z )
{
	m_zoom = z;
	for( KKDCanvas* w = m_canvas.first(); w; w = m_canvas.next() )
	{
		w->setZoom( m_zoom );
	}
	emit zoomupEnabledChanged( m_zoom != 7 );
	emit zoomdownEnabledChanged( m_zoom != -4 );
	setLayout();
}

void KKDView::zoomIn()
{
	int z = m_zoom + 1;
	if( z == 0 ) z+=2;
	setZoom( z );
}

void KKDView::zoomOut()
{
	int z = m_zoom - 1;
	if( z == 0 ) z-=2;
	setZoom( z );
}

void KKDView::wheelEvent( QWheelEvent* e )
{
	if( e->delta() > 0 && m_zoom != -4 )
	{
//		zoomOut();
	}
	else if( e->delta() < 0 && m_zoom != 7 )
	{
//		zoomIn();
	}
}

void KKDView::insertText()
{
/*	KKDItemDialog dlg( this );
	dlg.exec();*/
	m_canvas.at( m_doc->currentIndex() )->insertText();
}

void KKDView::insertImage()
{
	m_canvas.at( m_doc->currentIndex() )->insertImage();
}

void KKDView::insertAddressee()
{
	m_canvas.at( m_doc->currentIndex() )->insertAddressee();
}

void KKDView::insertAddress()
{
	m_canvas.at( m_doc->currentIndex() )->insertAddress();
}

void KKDView::insertZipcode()
{
	m_canvas.at( m_doc->currentIndex() )->insertZipcode();
}

