/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKALISTVIEW_H_
#define _KKALISTVIEW_H_

#include <klistview.h>

class KActionCollection;

namespace KKAddressBook
{
	class KKAGroup;
	class KKAPerson;

	class KKAListView : public KListView
	{
		Q_OBJECT
	public:
		KKAListView( QWidget* parent = 0, const char* name = 0 );
		virtual ~KKAListView();

	public slots:
		void groupChanged( QListViewItem* group );

	protected:
		KActionCollection* actionCollection();

	private:
		KKAGroup* m_group;

	private slots:
		void personNew();
		void personEdit();
		void personRemove();
	};
}

#endif /* _KKALISTVIEW_H_ */
