/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkalistview.h"
#include "kkagroup.h"
#include "kkaperson.h"
#include "kkacontactdata.h"

#include <klocale.h>
#include <kdebug.h>
#include <kmainwindow.h>
#include <kaction.h>
#include <kinputdialog.h>

using namespace KKAddressBook;

KKAListView::KKAListView( QWidget* parent, const char* name )
	: KListView( parent, name ), m_group( NULL )
{
	addColumn( i18n( "FullName" ) );
	addColumn( i18n( "ZipCode" ) );
	setFullWidth( true );
	setRootIsDecorated( true );
	setAllColumnsShowFocus( true );
	setDefaultRenameAction( Accept );

	KAction* act;

	QString str( i18n( "&Person" ) );	// to translate menu item
	
	act = new KAction( i18n( "&New" ), "person_new", 0, this, SLOT( personNew() ), actionCollection(), "person_new" );
	act->setToolTip( i18n( "Add new personal data" ) );
// 	new KAction( i18n( "&Edit" ), "person_edit", 0, this, SLOT( personEdit() ), actionCollection(), "person_edit" );

	act = new KAction( i18n( "&Remove" ), "person_del", 0, this, SLOT( personRemove() ), actionCollection(), "person_del" );
	act->setToolTip( i18n( "Remove current personal data" ) );
}

KKAListView::~KKAListView()
{
}

KActionCollection* KKAListView::actionCollection()
{
	QPtrList< KMainWindow >* list = KMainWindow::memberList;
	return ((KMainWindow*)list->at(0))->actionCollection();
}

void KKAListView::groupChanged( QListViewItem* group )
{
	if( m_group != NULL )
	{
		m_group->unplug( this );
	}
	m_group = (KKAGroup*)group;
	if( m_group != NULL )
	{
		m_group->plug( this );
	}
	emit currentChanged( firstChild() );
}

void KKAListView::personNew()
{
	KKAContactData* data = new KKAContactData( this );
	if( data == NULL ) return;
	KKAPerson* person = new KKAPerson( this, data );
	setCurrentItem( person );
	if( childCount() == 1 ) emit currentChanged( firstChild() );
}

void KKAListView::personEdit()
{
// 	rename( currentItem(), 0 );
}

void KKAListView::personRemove()
{
	if( !selectedItem() ) return;
	KKAContactData* data = ((KKAPerson*)selectedItem())->data();
	delete currentItem();
	delete data;
}
