/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKWIDGETBASE_H_
#define _KKWIDGETBASE_H_

#include "kkglobal.h"

#include <qsplitter.h>

class KActionCollection;
class KAction;
class KCommandHistory;

/**
 * @short Base Class of each base widget on tab.
 * @author SUZUKI Tasuku <tasuku@linux-life.net>
 * @see KKTemplate::KKTWidget
 * @see KKDesigner::KKDWidget
 * @see KKAddressBook::KKAWidget
 */
class KKWidgetBase : public QSplitter
{
	Q_OBJECT
public:
	/**
	 * Constructor
	 *
	 * @param cmdHistory The pointer of KCommandHistory shared by all actions.
	 * @param parent The parent object of this widget.
	 * @param name the name of this widget.
	 */
	KKWidgetBase( KCommandHistory* cmdHistory, QWidget* parent = 0, const char* name = 0 );

	/**
	 * Destructor
	 */
	virtual ~KKWidgetBase();

	/**
	 * Xml file for createGUI
	 */
	virtual const char* xmlFile() = 0;

	/**
	 * Return each tab is closable.<br>
	 * If false, KreetingKard does not close.
	 */
	virtual bool closable() = 0;

	/**
	 * @english
	 * Read Configuration
	 *
	 * @param conf Configuration class
	 * @endenglish
	 * @japanese
	 * 設定を読み込む。
	 *
	 * @param conf 設定ファイル
	 * @endjapanese
	 */
	virtual void readConfig( KConfig* conf ) = 0;

	/**
	 * @english
	 * Save Configuration
	 *
	 * @param conf Configuration class
	 * @endenglish
	 * @japanese
	 * 設定を保存する。
	 *
	 * @param conf 設定ファイル
	 * @endjapanese
	 */
	virtual void saveConfig( KConfig* conf ) = 0;

public slots:
	virtual void tabChanged( QWidget* wgt ) = 0;

signals:
	void captionChanged( const QString& );

protected:
	KActionCollection* actionCollection();
	KAction* action( const QString& name );
	void setActionEnabled( const QString& strName, bool blEnabled );

	KCommandHistory* commandHistory();

private:
	KCommandHistory* m_cmdHistory;
};

#endif /* _KKWIDGETBASE_H_ */
