/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDCANVAS_H_
#define _KKDCANVAS_H_

#include <qwidget.h>
#include <qmap.h>

#include <qpixmap.h>

#include "kkditembase.h"

class QPoint;
class QSize;
class QFrame;
class KAction;

namespace KKDesigner
{
	class KKDDoc;
	class KKDPaper;
	class KKDSizeHandler;

	class KKDCanvas : public QWidget
	{
		Q_OBJECT
	public:
		enum DragMode
		{
			None,
			Select,
			Move,
			InsertText,
			InsertImage,
			InsertAddressee,
			InsertAddress,
			InsertZipcode
		};
		KKDCanvas( KKDItemBase::DrawMode m, KKDPaper* item, QWidget* parent = 0, const char* name = 0 );
		~KKDCanvas();

		//BEGIN Properties

		const QSize size();
		double zoom();

		//END   Properties

	signals:
		void resized();
		void popup( const QPoint&, bool );

	public slots:
		void setZoom( int z );
		void draw( const QPaintDevice* device );
		void insertText();
		void insertImage();
		void insertAddressee();
		void insertAddress();
		void insertZipcode();
		void setContactData( const KKAddressBook::KKAContactData* d );

	protected:
		void paintEvent( QPaintEvent* );
		void mousePressEvent( QMouseEvent* e );
		void mouseMoveEvent( QMouseEvent* e );
		void mouseReleaseEvent( QMouseEvent* e );
		void mouseDoubleClickEvent( QMouseEvent* e );

	private slots:
		void draw( const QPaintDevice* device, QRect rect );
		void slotRepaint( const QRect &r ){ if( r.isValid()) repaint( r, false ); }
		void drawData();
		void imageChanged();
		void itemInserted( KKDItemBase* item, KKDPaper* paper = 0 );
		void itemRemoved( KKDItemBase* item, KKDPaper* paper = 0 );
		void currentChanged( KKDPaper* );

	private:
		KKDPaper* m_paper;
		DragMode m_dragMode;
		int m_zoom;
		KKDItemBase::DrawMode m_mode;
		const KKAddressBook::KKAContactData* m_data;

		QPoint m_fraSelectPos;
		QRect m_overlay;

		void resetGeometry();
		QMap<KKDItemBase*,KKDSizeHandler*> m_sizeHandles;

		KKDDoc* document();
		void setDragMode( DragMode m );
		int selectItem( QRect rect, bool add );
		QPixmap m_buffer;
		KAction* action( const QString& name );

	};
}

#endif /* _KKDCANVAS_H_ */
