/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkawidget.h"

#include "kkatreeview.h"
#include "kkalistview.h"
#include "kkadetailview.h"
#include "kkaperson.h"

#include "../kkdesigner/kkddoc.h"
#include "../kkdesigner/kkdview.h"

#include <qhbox.h>

#include <klistview.h>
#include <kurl.h>
#include <kdebug.h>
#include <kaction.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kiconloader.h>

using namespace KKAddressBook;

KKAWidget::KKAWidget( KKDesigner::KKDDoc* doc, KCommandHistory* cmdHistory, QWidget* parent, const char* name )
	: KKWidgetBase( cmdHistory, parent, name )
{
	m_tvwGroup = new KKATreeView( this );
	m_spl = new QSplitter( Qt::Vertical, this );
	m_lvwPerson = new KKAListView( m_spl );
	QSplitter* hbox = new QSplitter( m_spl );
	m_dvwPerson = new KKADetailView( hbox );
	m_preview = new KKDesigner::KKDView( KKDesigner::KKDItemBase::AddressMode, doc, hbox );
	if( m_tvwGroup->currentItem() )
	{
		m_lvwPerson->groupChanged( m_tvwGroup->currentItem() );
	}
	if( m_lvwPerson->currentItem() )
	{
		m_dvwPerson->setData( m_lvwPerson->currentItem() );
		setContactData( m_lvwPerson->currentItem() );
	}
	connect( m_tvwGroup, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( groupChanged( QListViewItem* ) ) );
	groupChanged( m_tvwGroup->currentItem() );
}

KKAWidget::~KKAWidget()
{
	m_lvwPerson->groupChanged( NULL );
}

void KKAWidget::readConfig( KConfig* conf )
{
	conf->setGroup("AddressBook");

	if( conf->hasKey( "HSplit" ) )
	{
		setSizes( conf->readIntListEntry( "HSplit" ) );
	}

	if( conf->hasKey( "VSplit" ) )
	{
		m_spl->setSizes( conf->readIntListEntry( "VSplit" ) );
	}
}

void KKAWidget::saveConfig( KConfig* conf )
{
	conf->setGroup("AddressBook");
	conf->writeEntry( "HSplit", sizes() );
	conf->writeEntry( "VSplit", m_spl->sizes() );
}

bool KKAWidget::closable()
{
	return true;
}

void KKAWidget::tabChanged( QWidget* /*wgt*/ )
{
// 	bool blEnabled = ( wgt == this );
/*	for( QStringList::ConstIterator it = m_strlActions.begin(); it != m_strlActions.end(); ++it )
	{
		setActionEnabled( *it, blEnabled );
	}
	if( blEnabled ) setEditActionEnabled();*/
}

void KKAWidget::groupChanged( QListViewItem* g )
{
	disconnect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), m_dvwPerson, SLOT( setData( QListViewItem* ) ) );
	disconnect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( setContactData( QListViewItem* ) ) );
	m_lvwPerson->groupChanged( g );
	connect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), m_dvwPerson, SLOT( setData( QListViewItem* ) ) );
	connect( m_lvwPerson, SIGNAL( currentChanged( QListViewItem* ) ), this, SLOT( setContactData( QListViewItem* ) ) );
	if( m_lvwPerson->firstChild() )
	{
		m_lvwPerson->setSelected( m_lvwPerson->firstChild(), true );
	}
	m_dvwPerson->setData( m_lvwPerson->firstChild() );
	setContactData( m_lvwPerson->firstChild() );
}

void KKAWidget::setContactData( QListViewItem* d )
{
	m_preview->setContactData( d ? ((KKAPerson*)d)->data() : NULL );
}

QPtrList<KKAContactData> KKAWidget::printData()
{
	return m_tvwGroup->printData();
}
