/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkaaddressmanagerjp.h"

#include <qregexp.h>
#include <qfile.h>
#include <qtextcodec.h>
#include <qfileinfo.h>

#include <kprocess.h>
#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <kprogress.h>

using namespace KKAddressBook;

KKAAddressManagerJP::KKAAddressManagerJP()
 : KKAAddressManager()
{
	m_datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/" + DATAFILE );
}


KKAAddressManagerJP::~KKAAddressManagerJP()
{
}

QString KKAAddressManagerJP::mask()
{
	return "999-9999; ";
}

bool KKAAddressManagerJP::isEmpty( QString zipcode )
{
	return zipcode.replace( "-", "" ).isEmpty();
}

bool KKAAddressManagerJP::available()
{
	return QFile::exists( m_datafile );
}

QString KKAAddressManagerJP::zipcode2address( QString zipcode )
{
	if( zipcode.length() != 8 ) return QString::null;
	QString str = zipcode.replace( "-", "" );
	QFile file( m_datafile );
	if( !file.open( IO_ReadOnly ) ){
		return false;
	}

	QTextStream ts( &file );
	while( !ts.atEnd() )
	{
		QString line = ts.readLine();
		if( line.left(7) == str )
		{
			file.close();
			return line.remove( 0, 8 /* 7 + strlen(" ") */ );
		}
	}
	file.close();
	return QString::null;
}

void KKAAddressManagerJP::readConfig( KConfig* conf )
{
	conf->setGroup( "KKAAddressManagerJP" );
}

void KKAAddressManagerJP::saveConfig( KConfig* conf )
{
	conf->setGroup( "KKAAddressManagerJP" );
}

/**
 * @japanese
 * LHA の存在チェック
 * @endjapanese
 */
bool KKAAddressManagerJP::checkLha( QWidget* parent )
{
	KProcess* proc = new KProcess( parent );
	*proc << "which" << "lha";
	proc->start();
	while( proc->isRunning() )
	{
		kapp->processEvents();
	}
	if( proc->exitStatus() != 0 )
	{
		KMessageBox::error( parent, i18n( "Japanese zipcode dictionary is lzh archive\nPlease install lha." ) );
		return false;
	}
	return true;
}

bool KKAAddressManagerJP::setup( QWidget* parent )
{
	if( !checkLha( parent ) ) return false;

	int ans = KMessageBox::questionYesNo( parent, i18n( "Do you want to download zipcode data?" ), i18n( "setup" ), KStdGuiItem::yes(), KStdGuiItem::no(), "kk_zipcode_setup_jp" );
	if( ans != KMessageBox::Yes ) return false;
	QString tmpfile;
	KProgressDialog* dlg = new KProgressDialog( parent, "", i18n( "ZipCode Update" ), "Test", true );
	dlg->setAllowCancel( true );
	dlg->progressBar()->setTotalSteps( 47 );
	dlg->setLabel( i18n( "download zipcode archive" ) );
	dlg->show();

	if( !KIO::NetAccess::download( JAPANPOST, tmpfile, parent ) )
	{
		delete dlg;
		KMessageBox::sorry( parent, KIO::NetAccess::lastErrorString() );
		return false;
	}
	dlg->setLabel( i18n( "expand zipcode archive" ) );

	KProcess* proc = new KProcess( parent );
	*proc << "lha" << "xq2" << tmpfile;
	proc->start();
	while( proc->isRunning() )
	{
		kapp->processEvents();
	}
	KIO::NetAccess::removeTempFile( tmpfile );

	QFile org( "ken_all.csv" );
	QFile local( m_datafile );
	if( !org.open( IO_ReadOnly ) ){
		KMessageBox::sorry( parent, i18n( "Could not open %1" ).arg( org.name() ) );
		return false;
	}
	if( !local.open( IO_WriteOnly ) ){
		KMessageBox::sorry( parent, i18n( "Could not open %1" ).arg( m_datafile ) );
		org.close();
		return false;
	}

	QTextStream in( &org );
	QTextStream out( &local );
	in.setCodec( QTextCodec::codecForName("Shift-JIS") );

	QString pref = QString::null;
	int i = -1;
	while( !in.atEnd() )
	{
		kapp->processEvents();
		if( dlg->wasCancelled() ) break;
		QStringList fields = QStringList::split( ',', in.readLine() );
		QString code = fields[2].replace( "\"", "" );
		QString address = fields[6] + fields[7];
		if( fields[8] == QString::fromUtf8( "\"以下に掲載がない場合\"" ) )
		{
			// exception
		}
		else if( fields[8].find( QString::fromUtf8( "（" ) ) != -1 )
		{
			// exception
		}
		else
		{
			address += fields[8];
		}
		address = address.replace( "\"", "" );
		out << code << '\t' << address << endl;
		if( pref != fields[6] )
		{
			pref = fields[6];
			dlg->setLabel( fields[6].replace( "\"", "" ) );
			kapp->processEvents();
			dlg->progressBar()->setProgress( i++ );
		}
	}
	kapp->processEvents();
	dlg->close();
	org.close();
	local.close();
	org.remove();
	return true;
}

KKAAddressManagerJPDialog::KKAAddressManagerJPDialog( QWidget* parent, const char* name )
	: KDialogBase( parent, name, true, i18n( "setup" ), Ok|Cancel )
{
}

KKAAddressManagerJPDialog::~KKAAddressManagerJPDialog()
{
}
