/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKDESIGNERKKDITEMDIALOG_H
#define KKDESIGNERKKDITEMDIALOG_H

#include <kdialogbase.h>

namespace KKDesigner
{
	class KKDItemBase;

	/**
	 * @english
	 * Item create/edit dialog.
	 * When create, any item type is selectable.
	 * When edit selected item's type is enabled.
	 *
	 * @author SUZUKI Tasuku
	 * @endenglish
	 *
	 * @japanese
	 * アイテム作成／編集ダイアログ
	 * 作成時にはアイテムの種類が選べる
	 * 編集時には選択されたアイテムの種類のみ有効
	 *
	 * @author 鈴木　佑
	 * @endjapanese
	 */
	class KKDItemDialog : public KDialogBase
	{
		Q_OBJECT
	public:
		KKDItemDialog( QWidget *parent = 0, const char *name = 0 );
		KKDItemDialog( QPtrList<KKDItemBase> items, QWidget *parent = 0, const char *name = 0 );
		~KKDItemDialog();

	private:
		void addBase();
		void addTextBase();
		void addText();
		void addImage();
		void addPaper();
		void addAddressee();
		void addAddress();
		void addZipcode();

		QFrame* m_base;
		QFrame* m_textbase;
		QFrame* m_text;
		QFrame* m_image;
		QFrame* m_paper;
		QFrame* m_addressee;
		QFrame* m_address;
		QFrame* m_zipcode;
	};
}

#endif
