/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkditemdialog.h"

#include "kkditembase.h"
#include "kkdtextitem.h"
#include "kkdimageitem.h"

#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKDesigner;

/**
 * @english
 * Constructor for insert mode
 * Create all type pane.
 * @endenglish
 */
KKDItemDialog::KKDItemDialog( QWidget *parent, const char *name )
	: KDialogBase( TreeList, i18n( "Create Item" ), Ok|Cancel, Ok, parent, name )
	, m_base( 0 )
	, m_text( 0 )
	, m_image( 0 )
	, m_paper( 0 )
	, m_addressee( 0 )
	, m_address( 0 )
	, m_zipcode( 0 )
{
	setRootIsDecorated( false );

	addBase();
	addText();
	addImage();
	addAddressee();
	addAddress();
	addZipcode();
	unfoldTreeList( false );
	resize( configDialogSize( "ItemDialog" ) );
}

/**
 * @english
 * Constructor for edit mode
 * Create type pane of selected items's.
 * @endenglish
 */
KKDItemDialog::KKDItemDialog( QPtrList<KKDItemBase> items, QWidget *parent, const char *name )
	: KDialogBase( TreeList, i18n( "Edit Item" ), Ok|Cancel, Ok, parent, name )
	, m_base( 0 )
	, m_text( 0 )
	, m_image( 0 )
	, m_paper( 0 )
	, m_addressee( 0 )
	, m_address( 0 )
	, m_zipcode( 0 )
{
	setRootIsDecorated( false );

	addBase();
	for( KKDItemBase* item = items.first(); item; item = items.next() )
	{
		switch( item->type() )
		{
			case KKDItemBase::TextItem:
				addText();
				break;
			case KKDItemBase::ImageItem:
				addImage();
				break;
			case KKDItemBase::Paper:
				addPaper();
				break;
			case KKDItemBase::Addressee:
				addAddressee();
				break;
			case KKDItemBase::Address:
				addAddress();
				break;
			case KKDItemBase::Zipcode:
				addZipcode();
				break;
		}
	}
	unfoldTreeList( false );
	resize( configDialogSize( "ItemDialog" ) );
}

KKDItemDialog::~KKDItemDialog()
{
	saveDialogSize( "ItemDialog" );
}

void KKDItemDialog::addBase()
{
	if( m_base ) return;
	m_base = addPage( QStringList() << i18n( "Common" ), i18n( "Common" ) );
}

void KKDItemDialog::addTextBase()
{
	if( m_textbase ) return;
	m_textbase = addPage( QStringList() << i18n( "Common" ) << i18n( "Text Common" ), i18n( "Text Common" ) );
}

void KKDItemDialog::addText()
{
	if( m_text ) return;
	addTextBase();
	m_textbase = addPage( QStringList() << i18n( "Common" ) << i18n( "Text Common" ) << i18n( "Text" ), i18n( "Text" ) );
}

void KKDItemDialog::addImage()
{
	if( m_image ) return;
	m_image = addPage( QStringList() << i18n( "Common" ) << i18n( "Image" ), i18n( "Image" ) );
}

void KKDItemDialog::addPaper()
{
	if( m_paper ) return;
kdDebug() << "void KKDItemDialog::addPaper()" << endl;
	addImage();
	m_paper = addPage( QStringList() << i18n( "Common" ) << i18n( "Image" ) << i18n( "Paper" ), i18n( "Paper" ) );
}

void KKDItemDialog::addAddressee()
{
	if( m_addressee ) return;
	addTextBase();
	m_addressee = addPage( QStringList() << i18n( "Common" ) << i18n( "Text Common" ) << i18n( "Addressee" ), i18n( "Addressee" ) );
}

void KKDItemDialog::addAddress()
{
	if( m_address ) return;
	addTextBase();
	m_address = addPage( QStringList() << i18n( "Common" ) << i18n( "Text Common" ) << i18n( "Address" ), i18n( "Address" ) );
}

void KKDItemDialog::addZipcode()
{
	if( m_zipcode ) return;
	addTextBase();
	m_zipcode = addPage( QStringList() << i18n( "Common" ) << i18n( "Text Common" ) << i18n( "Zipcode" ), i18n( "Zipcode" ) );
}
