/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkadetailview.h"
#include "kkaperson.h"
#include "kkacontactdata.h"
#include "kkapersonaldata.h"
#include "kkapersonwidget.h"
#include "kkaaddresswidget.h"
#include "kkahomeaddress.h"
#include "kkaofficeaddress.h"
#include "kkaprintstatuswidget.h"

#include <ktabwidget.h>
#include <klineedit.h>
#include <qhbox.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qlabel.h>
#include <qgrid.h>
#include <kdebug.h>

using namespace KKAddressBook;

KKADetailView::KKADetailView( QWidget* parent, const char* name )
	: QVBox( parent, name )
	, m_data( NULL )
{
	setupWidgets();
}

KKADetailView::~KKADetailView()
{
}

void KKADetailView::setupWidgets()
{
	m_person = new KKAPersonWidget( this );
	m_tab = new KTabWidget( this );

	// Home tab
	QVBox* vbox = new QVBox( m_tab );
	m_tab->addTab( vbox, SmallIcon( "kk_home" ), i18n( "Home" ) );
	QHBox* hbox = new QHBox( vbox );
	(new QLabel( i18n( "Print" ), hbox ))->setAlignment( AlignTop );
	m_homePrintStatus = new KKAPrintStatusWidget( hbox );

	m_home = new KKAAddressWidget( vbox );
	hbox = new QHBox( vbox );
	(new QLabel( i18n( "Joint name" ), hbox ))->setAlignment( AlignTop );
	vbox = new QVBox( hbox );
	for( uint i = 0; i != KKAHomeAddress::JointNameCount; i++ )
	{
		m_jointNames.push_back( new KKAPersonWidget( vbox ) );
	}

	// Office tab
	vbox = new QVBox( m_tab );
	m_tab->addTab( vbox, SmallIcon( "kk_office" ), i18n( "Office" ) );
	hbox = new QHBox( vbox );
	(new QLabel( i18n( "Print" ), hbox ))->setAlignment( AlignTop );
	m_officePrintStatus = new KKAPrintStatusWidget( hbox );
	QGrid* grid = new QGrid( 2, vbox );
	new QLabel( i18n( "Corporation" ), grid );
	m_corporation = new KLineEdit( grid );
	new QLabel( i18n( "Section" ), grid );
	m_section = new KLineEdit( grid );
	new QLabel( i18n( "Post" ), grid );
	m_post = new KLineEdit( grid );
	m_office = new KKAAddressWidget( vbox );

	connect( m_person, SIGNAL( nameChanged( const QString& ) ), this, SLOT( setName( const QString& ) ) );

	KTabWidget* tab = new KTabWidget( this );
	vbox = new QVBox( tab );
	tab->addTab( vbox, SmallIcon( "kk_history" ), i18n( "History" ) );

}

void KKADetailView::setData( QListViewItem* data )
{
	if( m_data )
	{
		m_data->data()->home()->setPrintStatus( m_homePrintStatus->status() );
		disconnect( m_homePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->data()->home(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
		disconnect( m_data->data()->home(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_homePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );

		m_data->data()->office()->setPrintStatus( m_officePrintStatus->status() );
		disconnect( m_officePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->data()->office(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
		disconnect( m_data->data()->office(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_officePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );

		m_data->data()->office()->setCorporation( m_corporation->text() );
		m_data->data()->office()->setSection( m_section->text() );
		m_data->data()->office()->setPost( m_post->text() );
		disconnect( m_tab, SIGNAL( currentChanged ( QWidget* ) ), this, SLOT( setPreference() ) );
		disconnect( m_corporation, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setCorporation( const QString& ) ) );
		disconnect( m_section, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setSection( const QString& ) ) );
		disconnect( m_post, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setPost( const QString& ) ) );
	}
	if( !data )
	{
		m_data = 0;
		m_person->setData( 0 );
		m_home->setData( 0 );
		m_office->setData( 0 );

		for( uint i = 0; i != m_jointNames.count(); i++ )
		{
			(*m_jointNames.at( i ))->setData( 0 );
		}
		m_corporation->setText( "" );
		m_section->setText( "" );
		m_post->setText( "" );
	}
	else
	{
		m_data = ((KKAPerson*)data);
		m_person->setData( m_data->data() );
		m_home->setData( m_data->data()->home() );
		m_office->setData( m_data->data()->office() );

		for( uint i = 0; i != m_jointNames.count(); i++ )
		{
			(*m_jointNames.at( i ))->setData( m_data->data()->home()->at(i) );
		}

		m_homePrintStatus->setStatus( m_data->data()->home()->printStatus() );
		connect( m_homePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->data()->home(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
		connect( m_data->data()->home(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_homePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );


		m_officePrintStatus->setStatus( m_data->data()->office()->printStatus() );
		connect( m_officePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->data()->office(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
		disconnect( m_data->data()->office(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_officePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );


		m_corporation->setText( m_data->data()->office()->corporation() );
		m_section->setText( m_data->data()->office()->section() );
		m_post->setText( m_data->data()->office()->post() );
		m_tab->setCurrentPage( (int)m_data->data()->current()->locationType() );
		connect( m_tab, SIGNAL( currentChanged ( QWidget* ) ), this, SLOT( setPreference() ) );
		connect( m_corporation, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setCorporation( const QString& ) ) );
		connect( m_section, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setSection( const QString& ) ) );
		connect( m_post, SIGNAL( textChanged( const QString& ) ), m_data->data()->office(), SLOT( setPost( const QString& ) ) );
	}
	setEnabled( m_data );
}

void KKADetailView::setName( const QString& str )
{
	if( m_data )
	{
		m_data->setText( 0, str );
	}
}

void KKADetailView::setPreference()
{
	if( m_data )
	{
		m_data->data()->setCurrent( (KKAAddressData::LocationType)m_tab->currentPageIndex() );
	}
}
