/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KREETINGKARD_H_
#define _KREETINGKARD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdom.h>
#include <qsplitter.h>

#include <kmainwindow.h>
#include <kdockwidget.h>
#include <kdebug.h>
#include <kurl.h>

class KKView;
class KKDoc;
class KKProperty;

class KreetingKard : public KDockMainWindow
{
	Q_OBJECT
public:
	enum InsertMode
	{
		None = 0,
		Text,
		Pixmap,
	};
	KreetingKard();
	virtual ~KreetingKard();

	void fileOpen( const QString &filename, bool checkModified = false );

public slots:
	void popup( const QPoint& pos, bool base );

protected:
	virtual bool queryClose();

private:
	void readConfig();
	void saveConfig();
	void setupWidgets();
	void setupActions();
	KKView* m_view;
	QSplitter* m_spl;
	KKDoc* m_doc;
	KKProperty* m_property;
	QString m_filename;
	QString m_directory;
	bool checkChangedAndSaved();
	void setEnabledEditAction( bool bl );

private slots:
	void fileNew();
	void fileOpen();
	void openRecent( const KURL& );
	bool fileSave();
	bool fileSaveAs();
	void fileClose();
	void print();
	void address();
	void preferences();
};

#endif // _KREETINGKARD_H_
