/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKWIDGET_H
#define KKWIDGET_H

#include <qwidget.h>
#include <qdom.h>
#include <qpixmap.h>
#include <qmap.h>

#include "kkitem.h"

class KKDoc;
class KKSizeHandler;

class KKWidget : public QWidget
{
	Q_OBJECT
public:
	enum DragMode
	{
		None,
		Select,
		Move,
		Insert,
	};
	KKWidget( KKItem* item, QWidget* parent = 0, bool readonly = false, const char* name = 0 );
	~KKWidget();

	// BEGIN Properties

	// BEGIN Location
		QPoint location(){ return m_item->location(); }
		void setLocation( QPoint l );
		void setLocation( int x, int y ){ setLocation( QPoint( x, y ) ); }
	// END

	// BEGIN Size
		QSize size(){ return m_size; }
		void setSize( QSize s );
		void setSize( int w, int h ){ setSize( QSize( w, h ) ); }
	// END

	// BEGIN Zoom
		double zoom();
		void setZoom( int z );
	// END

	// END   Properties

signals:
	void selectionChanged( KKWidget* );
	void resized();
	void popup( const QPoint&, bool );

public slots:
	void draw( const QPaintDevice* device );
	void insert();

protected:
	void paintEvent( QPaintEvent* );
	void mousePressEvent( QMouseEvent* e );
	void mouseMoveEvent( QMouseEvent* e );
	void mouseReleaseEvent( QMouseEvent* e );

private slots:
	void draw( const QPaintDevice* device, QRect rect );
	void slotRepaint( QRect r ){ repaint( r, false ); }
	void selectionChanged( bool b );
	void selectionChanged( KKItem*, bool b );
	void imageChanged();
	void itemInserted( QListViewItem* parent, KKItem* item );
	void itemRemoved( QListViewItem* parent, KKItem* item );
	void orientationChanged();

private:
	QFrame* m_fraSelectLeft;
	QFrame* m_fraSelectTop;
	QFrame* m_fraSelectRight;
	QFrame* m_fraSelectBottom;
	DragMode m_dragMode;
	QPoint m_fraSelectPos;

	KKItem* m_item;
	bool m_readonly;
	bool m_isBase;
	int m_zoom;
	QPoint m_location;
	QSize m_size;
	QColor m_foregroundColor;
	unsigned int m_borderWidth;
	QString m_text;
	int m_textAlign;
	Orientation m_textOrientation;
	QPixmap m_pixmap;
	bool m_selected;
	void resetGeometry();

	QPoint m_dragPos;
	QMap<KKItem*,KKSizeHandler*> m_sizeHandles;

	KKDoc* document();
	void setDragMode( DragMode m ){ m_dragMode = m; }
	DragMode dragMode(){ return m_dragMode; }
	void startDrag();
	int selectItem( QRect rect, bool blAdd );

};

#endif //KKWIDGET_H
