/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKPROPERTYITEMTEXTORIENTATION_H
#define KKPROPERTYITEMTEXTORIENTATION_H

#include <qcheckbox.h>
#include <qhbox.h>

#include <kcombobox.h>

#include "kkpropertyitembase.h"

class KKPropertyItemTextOrientation : public KKPropertyItemBase
{
	Q_OBJECT
public:
	KKPropertyItemTextOrientation( KKPropertyItemBase* parent, const QString &text );

	~KKPropertyItemTextOrientation();

public slots:
	void reset();
	void start();
	void accept();

private:
	QHBox* hbox;
	QCheckBox* chkEnabled;
	KComboBox* cbxOrientation;
};

#endif //KKPROPERTYITEMTEXTORIENTATION_H
