/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlabel.h>

#include "kkpropertyitemsize.h"

#define SPLITTER "x"

KKPropertyItemSize::KKPropertyItemSize( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	hbox = new QHBox( viewport() );
	chkWidth = new QCheckBox( hbox );
	numWidth = new KIntSpinBox( hbox );
	numWidth->setRange( 0, 1000 );
	new QLabel( SPLITTER, hbox );
	chkHeight = new QCheckBox( hbox );
	numHeight = new KIntSpinBox( hbox );
	numHeight->setRange( 0, 1000 );

	connect( chkWidth, SIGNAL( toggled( bool ) ), numWidth, SLOT( setEnabled( bool ) ) );
	connect( chkHeight, SIGNAL( toggled( bool ) ), numHeight, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemSize::~KKPropertyItemSize()
{
}

void KKPropertyItemSize::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.count() == 0 )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() );
	}

	int width = ((KKItem*)selectedItems.first())->size().width();
	int height = ((KKItem*)selectedItems.first())->size().height();
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		setVisible( item->parent() );
		if( width != -1 && width != item->size().width() )
		{
			width = -1;
		}
		if( height != -1 && height != item->size().height() )
		{
			height = -1;
		}
	}
	setText( 1, QString("%1 %2 %3").arg( width != -1 ? QString::number( width ) : "" ).arg( SPLITTER ).arg( height != -1 ? QString::number( height ) : "" ) );
}

void KKPropertyItemSize::accept()
{
	if( !hbox->isVisible() ) return;
	int width = numWidth->value();
	int height = numHeight->value();
    document()->setSize( chkWidth->isChecked() ? width : -1, chkHeight->isChecked() ? height : -1 );
	KKPropertyItemBase::accept();
}

void KKPropertyItemSize::start()
{
	KKPropertyItemBase::start();

	QStringList list = QStringList::split( QString(" %1 ").arg( SPLITTER ), text( 1 ), true );
	chkWidth->setChecked( !list[0].isEmpty() );
	if( document()->selectedItems().count() > 1 ) chkWidth->show(); else chkWidth->hide();
	numWidth->setEnabled( chkWidth->isChecked() );
	numWidth->setValue( list[0].toInt() );
	chkHeight->setChecked( !list[1].isEmpty() );
	if( document()->selectedItems().count() > 1 ) chkHeight->show(); else chkHeight->hide();
	numHeight->setEnabled( chkHeight->isChecked() );
	numHeight->setValue( list[1].toInt() );
	numWidth->setFocus();
}
