/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kkpropertyitemname.h"

KKPropertyItemName::KKPropertyItemName( KKProperty* parent, const QString &name )
	: KKPropertyItemBase( parent, name )
{
	txtName = new KLineEdit( viewport() );
	connect( txtName, SIGNAL( returnPressed( const QString& ) ), this, SLOT( accept() ) );
	setVisible( false );
}

KKPropertyItemName::~KKPropertyItemName()
{
}

void KKPropertyItemName::start()
{
	KKPropertyItemBase::start();
	txtName->setText( text( 1 ) );
	txtName->home( true );
	txtName->setFocus();
}

void KKPropertyItemName::accept()
{
	if( !txtName->isVisible() ) return;
	if( !txtName->text().isEmpty() )
	{
		document()->setName( txtName->text() );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemName::reset()
{
	KKPropertyItemBase::reset();
	QString name = QString::null;
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	setVisible( selectedItems.count() );
	for( KKItem* item = (KKItem*)selectedItems.first(); item; item = (KKItem*)selectedItems.next() )
	{
		if( name != QString::null && name != item->name() )
		{
			name = QString::null;
			break;
		}
		name = item->name();
	}
	setText( 1, name );
}
