/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlabel.h>

#include "kkpropertyitemlocation.h"

#define SPLITTER "/"

KKPropertyItemLocation::KKPropertyItemLocation( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	hbox = new QHBox( viewport() );
	chkX = new QCheckBox( hbox );
	numX = new KIntSpinBox( hbox );
	numX->setRange( -100, 1000 );
	new QLabel( SPLITTER, hbox );
	chkY = new QCheckBox( hbox );
	numY = new KIntSpinBox( hbox );
	numY->setRange( -100, 1000 );

	connect( chkX, SIGNAL( toggled( bool ) ), numX, SLOT( setEnabled( bool ) ) );
	connect( chkY, SIGNAL( toggled( bool ) ), numY, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemLocation::~KKPropertyItemLocation()
{
}

void KKPropertyItemLocation::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.count() == 0 )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() != NULL );
	}
	int* x = new int( ((KKItem*)selectedItems.first())->location().x() );
	int* y = new int( ((KKItem*)selectedItems.first())->location().y() );
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( x != NULL && *x != item->location().x() )
		{
			delete x;
			x = NULL;
		}
		if( y != NULL && *y != item->location().y() )
		{
			delete y;
			y = NULL;
		}
	}
	setText( 1, QString("%1 %2 %3").arg( x ? QString::number( *x ) : "" ).arg( SPLITTER ).arg( y ? QString::number( *y ) : "" ) );
	if( x != NULL ) delete x;
	if( y != NULL ) delete y;
}

void KKPropertyItemLocation::accept()
{
	if( !hbox->isVisible() ) return;
	int x = numX->value();
	int y = numY->value();
    document()->setLocation( chkX->isChecked() ? &x : NULL, chkY->isChecked() ? &y : NULL );
	KKPropertyItemBase::accept();
}

void KKPropertyItemLocation::start()
{
	KKPropertyItemBase::start();

	QStringList list = QStringList::split( QString(" %1 ").arg( SPLITTER ), text( 1 ), true );
	chkX->setChecked( !list[0].isEmpty() );
	if( document()->selectedItems().count() > 1 ) chkX->show(); else chkX->hide();
	numX->setEnabled( chkX->isChecked() );
	numX->setValue( list[0].toInt() );
	chkY->setChecked( !list[1].isEmpty() );
	if( document()->selectedItems().count() > 1 ) chkY->show(); else chkY->hide();
	numY->setEnabled( chkY->isChecked() );
	numY->setValue( list[1].toInt() );
	numX->setFocus();
}
