/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitemimageprint.h"

KKPropertyItemImagePrint::KKPropertyItemImagePrint( KKPropertyItemBase* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	hbox = new QHBox( viewport() );
	chkEnabled = new QCheckBox( "", hbox );
	chkEnabled->setFixedSize( 16, 16 );

	cbxImagePrint = new KComboBox( hbox );
	cbxImagePrint->insertItem( i18n( "True" ) );
	cbxImagePrint->insertItem( i18n( "False" ) );
	connect( cbxImagePrint, SIGNAL( returnPressed( const QString& ) ), this, SLOT( accept() ) );
	connect( chkEnabled, SIGNAL( toggled( bool ) ), cbxImagePrint, SLOT( setEnabled( bool ) ) );
	setVisible( false );
}

KKPropertyItemImagePrint::~KKPropertyItemImagePrint()
{
}

void KKPropertyItemImagePrint::start()
{
	KKPropertyItemBase::start();
	chkEnabled->setChecked( !text( 1 ).isEmpty() );
	cbxImagePrint->setEnabled( chkEnabled->isChecked() );
	if( chkEnabled->isChecked() )
	{
		cbxImagePrint->setCurrentText( text( 1 ) );
	}
	cbxImagePrint->setFocus();
}

void KKPropertyItemImagePrint::accept()
{
	if( !cbxImagePrint->isVisible() ) return;
	if( cbxImagePrint->currentText() != text( 1 ) && chkEnabled->isChecked() )
	{
		document()->setImagePrint( cbxImagePrint->currentItem() == 0 );
	}
	KKPropertyItemBase::accept();
}

void KKPropertyItemImagePrint::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.count() == 0 )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( true );
	}
	int index = ((KKItem*)selectedItems.first())->imagePrint() ? 1 : 0;
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( ( index == 1 ) != item->imagePrint() )
		{
			index = -1;
			break;
		}
	}
	switch( index )
	{
		case -1:
			setText( 1, "" );
			break;
		case 0:
			setText( 1, i18n( "False" ) );
			break;
		case 1:
			setText( 1, i18n( "True" ) );
			break;
	}
	chkEnabled->setChecked( index != -1 );
	if( document()->selectedItems().count() > 1 ) chkEnabled->show(); else chkEnabled->hide();
}
