/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qvbox.h>
#include <qimage.h>

#include <kiconloader.h>
#include <kfiledialog.h>

#include "kkpropertyitemimage.h"

KKPropertyItemImage::KKPropertyItemImage( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
//	setViewPortHeight( 4 );

	btnRequest = new KPushButton( viewport() );
	connect( btnRequest, SIGNAL( clicked() ), this, SLOT( imageRequest() ) );
	btnErase = new KPushButton( SmallIcon( "eraser" ), "", viewport() );
	btnErase->setFixedWidth( 20 );
	connect( btnErase, SIGNAL( clicked() ), this, SLOT( imageErase() ) );
	setVisible( false );
}

KKPropertyItemImage::~KKPropertyItemImage()
{
}

void KKPropertyItemImage::start()
{
	KKPropertyItemBase::start();
	if( pixmap( 1 ) )
	{
		btnRequest->setPixmap( *pixmap( 1 ) );
	}
	else
	{
		btnRequest->setPixmap( QPixmap() );
	}
	btnRequest->setFocus();
}

void KKPropertyItemImage::accept()
{
	if( !btnRequest->isVisible() ) return;
	document()->setImage( pixmap( 2 ) ? *pixmap( 2 ) : QPixmap() );
	KKPropertyItemBase::accept();
}

void KKPropertyItemImage::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	setVisible( selectedItems.count() );
	if( selectedItems.count() == 0 ) return;
	QPixmap pix = ((KKItem*)selectedItems.first())->image();
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( pix.isNull() != item->image().isNull() && pix.convertToImage() != item->image().convertToImage() )
		{
			pix = QPixmap();
			break;
		}
	}
	setPixmap( 2, pix );
	if( !pix.isNull() )
	{
		QImage img = pix.convertToImage().smoothScale( 80, 80, QImage::ScaleMin );
		pix.convertFromImage( img );
	}
	setPixmap( 1, pix );
}

void KKPropertyItemImage::imageRequest()
{
	KURL url = KFileDialog::getOpenFileName( QString::null, i18n( "image/png image/jpeg image/gif image/tiff image/x-bmp|All Supported File" ) );
	if( url.isEmpty() )
	{
		abort();
		return;
	}
	setPixmap( 2, QPixmap( url.path() ) );
	accept();
}

void KKPropertyItemImage::imageErase()
{
	setPixmap( 2, QPixmap() );
	accept();
}
