/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkpropertyitemdatafield.h"

KKPropertyItemDataField::KKPropertyItemDataField( KKProperty* parent, const QString &text )
	: KKPropertyItemBase( parent, text )
{
	cbxDataField = new KComboBox( viewport() );
	cbxDataField->insertItem( "" );
	for( int i = 1; i != 8; i++ )
	{
		cbxDataField->insertItem( i18n( "Zipcode %1" ).arg( i ) );
	}
	cbxDataField->insertItem( i18n( "Direction" ) );
	cbxDataField->insertItem( i18n( "Address" ) );
	cbxDataField->insertItem( i18n( "Comment" ) );
	setVisible( false );
}

KKPropertyItemDataField::~KKPropertyItemDataField()
{
}

void KKPropertyItemDataField::start()
{
	KKPropertyItemBase::start();
	cbxDataField->setFocus();
}

void KKPropertyItemDataField::accept()
{
	if( !cbxDataField->isVisible() ) return;
	document()->setDataField( cbxDataField->currentItem() );
	KKPropertyItemBase::accept();
}

void KKPropertyItemDataField::reset()
{
	KKPropertyItemBase::reset();
	QPtrList<QListViewItem> selectedItems = document()->selectedItems();
	if( selectedItems.count() == 0 )
	{
		setVisible( false );
		return;
	}
	else
	{
		setVisible( ((KKItem*)selectedItems.first())->parent() != NULL );
	}
	int datafield = ((KKItem*)selectedItems.first())->datafield();
	for( KKItem* item = (KKItem*)selectedItems.next(); item; item = (KKItem*)selectedItems.next() )
	{
		if( datafield != item->datafield() )
		{
			datafield = -1;
			break;
		}
	}
	cbxDataField->setCurrentItem( datafield );
	setText( 1, cbxDataField->currentText() );
}
