/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKPROPERTYITEMBASE_H
#define KKPROPERTYITEMBASE_H

#include <kpushbutton.h>
#include <klistview.h>
#include <klocale.h>
#include <kdebug.h>

#include "kkproperty.h"
#include "kkdoc.h"
#include "kkitem.h"

class KKPropertyItemBase : public QObject, public KListViewItem
{
	Q_OBJECT
public:
	KKPropertyItemBase( KKProperty* parent, const QString &text );
	KKPropertyItemBase( KKPropertyItemBase* parent, const QString &text );
	~KKPropertyItemBase();
	void setSelected( bool selected );

public slots:
	virtual void reset();
	virtual void start();
	virtual void accept();
	virtual void abort();

protected:
	QWidget* viewport(){ return m_viewport; }
	void setViewPortHeight( int height ){ m_height = height; }
	KKDoc* document(){ return m_parent->document(); }

private:
	KKProperty* m_parent;
	int m_height;
	QWidget* m_viewport;
	void setupWidget( KKProperty* parent );
	KPushButton* btnCancel;
};

#endif //KKPROPERTYITEMBASE_H
