/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qheader.h>

#include <kdebug.h>
#include <klocale.h>

#include "kkproperty.h"
#include "kkdoc.h"
#include "kkpropertyitembase.h"
#include "kkpropertyitemname.h"
#include "kkpropertyitemlocation.h"
#include "kkpropertyitemsize.h"
#include "kkpropertyitemtext.h"
#include "kkpropertyitemtextalign.h"
#include "kkpropertyitemtextorientation.h"
#include "kkpropertyitemtextcolor.h"
#include "kkpropertyitemtextfont.h"
#include "kkpropertyitemdatafield.h"
#include "kkpropertyitemimage.h"
#include "kkpropertyitemimageprint.h"
#include "kkpropertyitemorientation.h"

KKProperty::KKProperty( QWidget *parent, const char *name )
	: KListView( parent, name )
{
	setRootIsDecorated( true );
	header()->setMovingEnabled( false );
	setFullWidth( true );
	setSortColumn( -1 );
	setAllColumnsShowFocus( true );
	addColumn( i18n( "Property" ) );
	addColumn( i18n( "Value" ) );
	setItemsRenameable( true );
	setRenameable( 1, true );

	m_properties["Orientation"] = new KKPropertyItemOrientation( this, i18n( "Orientation" ) );
	m_properties["Image"] = new KKPropertyItemImage( this, i18n( "Image" ) );
		m_properties["ImagePrint"] = new KKPropertyItemImagePrint( m_properties["Image"], i18n( "Print" ) );
	m_properties["Image"]->setOpen( true );
	m_properties["DataField"] = new KKPropertyItemDataField( this, i18n( "DataField" ) );
	m_properties["Text"] = new KKPropertyItemText( this, i18n( "Text" ) );
		m_properties["TextOrientation"] = new KKPropertyItemTextOrientation( m_properties["Text"], i18n( "Orientation" ) );
		m_properties["TextAlign"] = new KKPropertyItemTextAlign( m_properties["Text"], i18n( "Align" ) );
		m_properties["TextFont"] = new KKPropertyItemTextFont( m_properties["Text"], i18n( "Font" ) );
		m_properties["TextColor"] = new KKPropertyItemTextColor( m_properties["Text"], i18n( "Color" ) );
	m_properties["Text"]->setOpen( true );
	m_properties["Size"] = new KKPropertyItemSize( this, i18n( "Size" ) );
	m_properties["Location"] = new KKPropertyItemLocation( this, i18n( "Location" ) );
	m_properties["Name"] = new KKPropertyItemName( this, i18n( "Name" ) );
}


KKProperty::~KKProperty()
{
}

void KKProperty::setDocument( KKDoc* doc )
{
	m_doc = doc;
	QMap<QString,KKPropertyItemBase*>::Iterator it;
	for ( it = m_properties.begin(); it != m_properties.end(); ++it )
	{
		connect( m_doc, SIGNAL( selectionChanged() ), m_properties[it.key()], SLOT( reset() ) );
		connect( m_doc, SIGNAL( inserted() ), m_properties[it.key()], SLOT( reset() ) );
		connect( m_doc, SIGNAL( removed() ), m_properties[it.key()], SLOT( reset() ) );
		connect( m_doc, SIGNAL( documentChanged() ), m_properties[it.key()], SLOT( reset() ) );
	}

	connect( m_doc, SIGNAL( nameChanged() ), m_properties["Name"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( locationChanged() ), m_properties["Location"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( sizeChanged() ), m_properties["Size"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( textChanged() ), m_properties["Text"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( textAlignChanged() ), m_properties["TextAlign"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( textOrientationChanged() ), m_properties["TextOrientation"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( textColorChanged() ), m_properties["TextColor"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( textFontChanged() ), m_properties["TextFont"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( datafieldChanged() ), m_properties["DataField"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( imageChanged() ), m_properties["Image"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( imagePrintChanged() ), m_properties["ImagePrint"], SLOT( reset() ) );
	connect( m_doc, SIGNAL( orientationChanged() ), m_properties["Orientation"], SLOT( reset() ) );
}

void KKProperty::rename( QListViewItem* item, int c )
{
	if( c != 1 ) return;
	((KKPropertyItemBase*)item)->start();
}

void KKProperty::doneEditing( QListViewItem* item, int row )
{
	((KKPropertyItemBase*)item)->accept();
	KListView::doneEditing( item, row );
}

void KKProperty::selectionChanged()
{
	((KKPropertyItemBase*)currentItem())->abort();
}
/*
void KKProperty::focusOutEvent( QFocusEvent* e )
{
	if( e->lostFocus() )
	{
		((KKPropertyItemBase*)currentItem())->abort();
	}
}*/
