/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKITEM_H
#define KKITEM_H

#include <qdom.h>
#include <qpixmap.h>
#include <qpainter.h>

#include <klistview.h>

class Address;

class KKItem : public QObject, public KListViewItem
{
	Q_OBJECT
public:
	KKItem( QListViewItem* parent, KKItem* item );
	KKItem( QListViewItem* parent = 0, const char *name = 0 );
	KKItem( QDomElement doc, KListViewItem *parent = 0, const char *name = 0 );
	KKItem( QDomElement doc, KListView *parent = 0, const char *name = 0 );
	~KKItem();

	// BEGIN Properties
		QString name(){ return text( 0 ); }
		QPoint location(){ return m_location; }
		QSize size(){ return m_size; }
		QString text(){ return m_text; }
		unsigned int textAlign(){ return m_textAlign; }
		Orientation textOrientation(){ return m_textOrientation; }
		QColor textColor(){ return m_textColor; }
		QFont textFont(){ return m_textFont; }
		int datafield(){ return m_datafield; }
		QPixmap image(){ return m_image; }
		QPixmap imageResized(){ return m_imageresized; }
		bool imagePrint(){ return m_imagePrint; }
		Orientation orientation(){ return ( size().width() > size().height() ) ? Horizontal : Vertical; }

	// END   Properties

	QRect rect(){ return QRect( location(), size() ); }
	void drawItem( QPainter& p, double zoom = 1.0, Address* addr = 0 );
	QString text( int c ){ return KListViewItem::text( c ); }

	QListViewItem* parent(){ return QListViewItem::parent(); }

public slots:
	// BEGIN Properties
		void setName( const QString &n );
		void setLocation( const QPoint &l );
		void setLocation( int x, int y ){ setLocation( QPoint( x, y ) ); }
		void setSize( const QSize &s );
		void setSize( unsigned int w, unsigned int h ){ setSize( QSize( w, h ) ); }
		void setText( const QString &t );
		void setTextAlign( unsigned int a );
		void setTextOrientation( Orientation o );
		void setTextColor( const QColor &c );
		void setTextFont( const QFont &f );
		void setDataField( int d );
		void setImage( const QPixmap &i );
		void setImagePrint( bool p );
		void setOrientation( Orientation o );
	// END   Properties
	void setSelected( bool b );
	QDomElement toElement( QDomDocument& doc );
	void setText( int c, const QString &text ){ KListViewItem::setText( c, text ); }

signals:
	void inserted( KKItem* );
	void removed( KKItem* );
	// BEGIN Properties
		void nameChanged();
		void locationChanged();
		void sizeChanged();
		void textChanged();
		void textAlignChanged();
		void textOrientationChanged();
		void textColorChanged();
		void textFontChanged();
		void datafieldChanged();
		void imageChanged();
		void imagePrintChanged();
		void orientationChanged();
	// END   Properties
	void repaint( QRect );
	void selectionChanged( bool );
	void selectionChanged( KKItem*, bool );

private:
	void drawText( QPainter& p, QRect r, const QString &text );
	bool m_isBase;
	QPoint m_location;
	QSize m_size;
	QString m_text;
	unsigned int m_textAlign;
	Orientation m_textOrientation;
	QColor m_textColor;
	QFont m_textFont;
	int m_datafield;
	QPixmap m_image;
	QPixmap m_imageresized;
	bool m_imagePrint;

	bool m_selected;

	void parse( QDomElement& e );
};

#endif //KKITEM_H
