/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KKDOC_H
#define KKDOC_H

#include <qdom.h>

#include <klistview.h>
#include <kactioncollection.h>
#include <kcommand.h>

struct Address;
class KKCmdBase;
class KKItem;
class KAction;

class KKDoc : public KListView
{
	Q_OBJECT
public:
	KKDoc( KActionCollection* actionCollection, QWidget* parent, const char *name = 0);
	KKDoc( QWidget* parent, const char *name = 0);
	~KKDoc();

	void setDocument( const QDomDocument &doc );
	void clearDocument();
	QDomDocument document();
	KCommandHistory* commandHistory(){ return m_cmdHistory; }
	bool print( QPainter& p, Address addr );
	void setSelected( QListViewItem* item, bool selected );
	bool pastable(){ return m_clipboard.count(); }

	void insertByCommand( QListViewItem* parent, KKItem* item );
	void removeByCommand( QListViewItem* parent, KKItem* item );

	KAction *actionCut() const   { return m_actionCollection->action( "edit_cut" ); }
	KAction *actionCopy() const  { return m_actionCollection->action( "edit_copy" ); }
	KAction *actionPaste() const { return m_actionCollection->action( "edit_paste" ); }
	
public slots:
	void cut();
	void copy();
	void paste();
	void selectAll();
	void insert();
	void remove();
	void setName( const QString &name );
	void setLocation( int* x, int* y );
	void moveStart();
	void moving();
	void moveEnd();
	void setSize( int width, int height );
	void resizeStart();
	void resizing();
	void resizeEnd();
	void setText( const QString &text );
	void setTextAlign( int align );
	void setTextOrientation( Orientation orientation );
	void setTextColor( const QColor &color );
	void setTextFont( const QFont &font );
	void setDataField( int datafield );
	void setImage( const QPixmap &p );
	void setImagePrint( bool p );
	void setOrientation( Orientation orientation );

signals:
	void documentChanged();
	void inserted();
	void inserted( QListViewItem*, KKItem* );
	void removed();
	void removed( QListViewItem*, KKItem* );
	// BEGIN Properties
		void nameChanged();
		void locationChanged();
		void sizeChanged();
		void textChanged();
		void textAlignChanged();
		void textOrientationChanged();
		void textColorChanged();
		void textFontChanged();
		void datafieldChanged();
		void imageChanged();
		void imagePrintChanged();
		void orientationChanged();
	// END   Properties

private:
	KActionCollection* m_actionCollection;
	KCommandHistory* m_cmdHistory;
	KKCmdBase* m_cmd;
	QPtrList<KKItem> m_clipboard;
	void terminate();

private slots:
	void slotSelectionChanged();
};

#endif //KKDOC_H
