/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kkcmdbase.h"

KKCmdBase::KKCmdBase( KKDoc* doc )
{
	m_doc = doc;
	QPtrList<QListViewItem> selectedItems = doc->selectedItems();
	for( QListViewItem* item = selectedItems.first(); item; item = selectedItems.next() )
	{
		m_items.append( (KKItem*)item );
	}
}

void KKCmdBase::execute()
{
	m_doc->clearSelection();
	for( KKItem* item = items().first(); item; item = items().next() )
	{
		if( item->parent() ) m_doc->setSelected( item, true );
		execute( item );
		if( item->parent() ) m_doc->setSelected( item, true );
	}
	emit executed();
}

void KKCmdBase::unexecute()
{
	m_doc->clearSelection();
	for( KKItem* item = items().first(); item; item = items().next() )
	{
		if( item->parent() ) m_doc->setSelected( item, true );
		unexecute( item );
		if( item->parent() ) m_doc->setSelected( item, true );
	}
	emit unexecuted();
}

void KKCmdBase::begin()
{
	for( KKItem* item = items().first(); item; item = items().next() )
	{
		begin( item );
	}
}

void KKCmdBase::end()
{
	QPtrList<KKItem> remove;
	for( KKItem* item = items().first(); item; item = items().next() )
	{
		if( !end( item ) )
		{
			remove.append( item );
		}
	}
	for( KKItem* item = remove.first(); item; item = remove.next() )
	{
		items().removeRef( item );
	}
	setName( i18n( "Change %1 of %2 item(s)" ).arg( propertyName() ).arg( items().count() ) );
}

QString KKCmdBase::name() const
{
	return m_name;
}

void KKCmdBase::setName( const QString &name )
{
	m_name = name;
}
