/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kksetupgroupdialog.h"
#include "kkaddressbookglobalconfig.h"

#include <qlabel.h>
#include <qtoolbutton.h>
#include <qlayout.h>

#include <kglobal.h>
#include <kconfig.h>
#include <klistview.h>
#include <klocale.h>
#include <kinputdialog.h>
#include <kmessagebox.h>

KKSetupGroupDialog::KKSetupGroupDialog( QWidget *parent, const char *name )
	: KDialog( parent, name ), isGroupModified( false )
{
	readList();
	setupWidgets();
}

KKSetupGroupDialog::~KKSetupGroupDialog()
{
	saveList();
}

void KKSetupGroupDialog::setupWidgets()
{
	/* listview */
	mGroupListView = new KListView( this );
	mGroupListView->addColumn( i18n("Group Name") );
	mGroupListView->setFullWidth( true );
	mGroupListView->setSortColumn( 0 );
	mGroupListView->setAllColumnsShowFocus( true );
	mGroupListView-> setSelectionMode( QListView::Single );
	// add list view items
	QStringList::ConstIterator it = mGroupList.begin();
	const QStringList::ConstIterator end = mGroupList.end();
	for( ; it != end; ++it )
	{
		new KListViewItem( mGroupListView, *it );
	}

	/* buttons */
	mAddButton = new QToolButton( this );
	mAddButton->setText( i18n("Add New Group") );
	QObject::connect( mAddButton, SIGNAL( clicked() ),
			  this, SLOT( addNewGroup() ) );
	mRemoveButton = new QToolButton( this );
	mRemoveButton->setText( i18n("Remove Group") );
	QObject::connect( mRemoveButton, SIGNAL( clicked() ),
			  this, SLOT( removeSelectedGroup() ) );
	mOKButton = new QToolButton( this );
	mOKButton->setText( i18n("OK") );
	QObject::connect( mOKButton, SIGNAL( clicked() ),
			  this, SLOT( slotOK() ) );

	QHBoxLayout *buttonHLayout = new QHBoxLayout;
	buttonHLayout->setMargin( 6 );
	buttonHLayout->setSpacing( 6 );
	buttonHLayout->addWidget( mAddButton );
	buttonHLayout->addWidget( mRemoveButton );
	buttonHLayout->addWidget( mOKButton );

        QVBoxLayout *mainVLayout = new QVBoxLayout( this );
        mainVLayout->addSpacing( 6 );
	mainVLayout->addWidget( mGroupListView );
	mainVLayout->addLayout( buttonHLayout );

	// Choose First Item
	QListViewItem *firstItem = mGroupListView->firstChild();
	if( firstItem )
		mGroupListView->setSelected( firstItem, true );
}


void KKSetupGroupDialog::addNewGroup()
{
	QString newGroupName = KInputDialog::getText( i18n("Add New Group"), i18n("New Group Name") );
	if( !newGroupName.isEmpty() )
	{
		if( !mGroupList.contains( newGroupName ) )
		{
			// add to the StringList
			mGroupList << newGroupName;

			// add to the ListView
			KListViewItem *item = new KListViewItem( mGroupListView, newGroupName );
			mGroupListView->setSelected( item, true );

			isGroupModified = true;
		}
		else
		{
			KMessageBox::error( this, i18n("Group already exits") );
		}
	}
}

void KKSetupGroupDialog::removeSelectedGroup()
{
	QListViewItem *selectedItem = mGroupListView->selectedItem();
	if( selectedItem )
	{
		QListViewItem *nextItem = selectedItem->nextSibling();
		if( nextItem )
		{
			// select next item
			mGroupListView->setSelected( nextItem, true );
		} else
		{
			// if no next item, select first item
			QListViewItem *firstItem = mGroupListView->firstChild();
			if( firstItem )
				mGroupListView->setSelected( firstItem, true );
		}
		
		QString removeGroupName = selectedItem->text( 0 );
		if( mGroupList.contains( removeGroupName ) )
		{
			// remove from StringList
			mGroupList.remove( removeGroupName );

			// remove from ListView
			mGroupListView->takeItem( selectedItem );

			isGroupModified = true;
		}
	}
}

void KKSetupGroupDialog::slotOK()
{
	saveList();
	done( 0 );
}

void KKSetupGroupDialog::readList()
{
	mGroupList = KKAddressBookGlobalConfig::readGroupList();
}

void KKSetupGroupDialog::saveList()
{
	KKAddressBookGlobalConfig::writeGroupList( mGroupList );
}
