/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKNEWCONTACT_DIALOG_H_
#define _KKNEWCONTACT_DIALOG_H_

#include <kdialog.h>

class KKContactData;

class QToolButton;

class KLineEdit;
class KComboBox;
class KTabWidget;

class KKNewContactDialog : public KDialog {
	Q_OBJECT

public:
	enum DialogCode { Cancel, OK, AddNext };

	KKNewContactDialog( QWidget *parent = 0, const char *name = 0 );
	virtual ~KKNewContactDialog();

	// pre
	void setContactData( const KKContactData & d );

	// after
	KKContactData getContactData();

protected:
	void init();
	void setupWidgets();
	QWidget *setupPageGeneral();
	QWidget *setupPageDetail();	

	bool isValidData();

	void checkZipCodeData();

protected slots:
	void slotZipCodeChanged( const QString &str );

	void slotAddNext();
	void slotOK();
	void slotCancel();

protected:
	KTabWidget *mTabWidget;
	QWidget *mPageGeneral;
	QWidget *mPageDetail;
	KLineEdit *mFuriganaEdit;
	KLineEdit *mNameEdit;
	KComboBox *mNamePostfixCombo;
	KComboBox *mGroupCombo;
	// General
	KLineEdit *mZipCodeEdit;
	KLineEdit *mAddress1Edit;
	KLineEdit *mAddress2Edit;
	// Detail
	KLineEdit *mMailEdit;
	KLineEdit *mPhoneNumberEdit;
	KLineEdit *mFaxNumberEdit;
	KLineEdit *mMobilePhoneNumberEdit;
	KLineEdit *mMobilePhoneMailEdit;	

	QToolButton *addNextButton;
	QToolButton *okButton;
	QToolButton *cancelButton;

	static QString lastSelectedGroup;	
};

#endif /* Not def: _KKNEWCONTACT_DIALOG_H_ */
