/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKCONTACT_QUICK_SEARCHLINE_H_
#define _KKCONTACT_QUICK_SEARCHLINE_H_

#include <klistviewsearchline.h>

class KComboBox;
class KListView;
class KActionCollection;

class KKContactQuickSearchLine : public KListViewSearchLine
{
	Q_OBJECT
public:
	KKContactQuickSearchLine( QWidget *parent,
                                  KListView *listView,
                                  const char *name = 0 );
	virtual ~KKContactQuickSearchLine();

	void updateGroups();
	
public slots:
	void reset();
	void slotGroupChanged( int );

protected:
	virtual bool itemMatches( const QListViewItem *item, const QString &s ) const;

private:
	KComboBox *mGroupCombo;
	int mSelectedGroupIndex;
};

#endif /* _KKCONTACT_QUICK_SEARCHLINE_H_ */
