/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkcontactquicksearchline.h"
#include "kkaddressbookdialog.h"
#include "kkcontactdata.h"
#include "kkaddressbookglobalconfig.h"

#include <qapplication.h>
#include <qlabel.h>
#include <qtimer.h>

#include <kglobal.h>
#include <kconfig.h>
#include <kaction.h>
#include <kiconloader.h>
#include <klistview.h>
#include <klocale.h>
#include <kcombobox.h>

KKContactQuickSearchLine::KKContactQuickSearchLine( QWidget *parent,
					    KListView *listView,
					    const char *name )
	: KListViewSearchLine(parent, listView, name), mGroupCombo(0), mSelectedGroupIndex(0)
{
	QLabel *label = new QLabel( i18n("Group:"), parent );

	mGroupCombo = new KComboBox( parent );
	mGroupCombo->insertItem( i18n("Any Group") );
        // insert groups
        QStringList groupList = KKAddressBookGlobalConfig::readGroupList();
        QStringList::ConstIterator it = groupList.begin();
	const QStringList::ConstIterator end = groupList.end();
	for( ; it != end; ++it )
	{
		mGroupCombo->insertItem( *it );		
	}
                                
	connect( mGroupCombo, SIGNAL ( activated( int ) ),
		 this, SLOT( slotGroupChanged( int ) ) );

	label->setBuddy( mGroupCombo );
}

KKContactQuickSearchLine::~KKContactQuickSearchLine()
{
}

void KKContactQuickSearchLine::updateGroups()
{
	QString currentText = mGroupCombo->currentText();
	QStringList newGroupList = KKAddressBookGlobalConfig::readGroupList();

	// delete
	mGroupCombo->clear();

        // any group should always available
        mGroupCombo->insertItem( i18n("Any Group") );

	// add new
	QStringList::ConstIterator it = newGroupList.begin();
	const QStringList::ConstIterator end = newGroupList.end();
	for( ; it != end; ++it )
	{
		mGroupCombo->insertItem( *it );		
	}

	// select
	if( mGroupCombo->contains( currentText ) )
	{
		mGroupCombo->setCurrentItem( currentText );
	}

	// update
	updateSearch();
}

bool KKContactQuickSearchLine::itemMatches(const QListViewItem *item, const QString &s) const
{
	if( mSelectedGroupIndex != 0 )
	{
		// Matching By Group
		const KKContactListViewItem *item = static_cast<const KKContactListViewItem*>( item );
		const KKContactData *d = item->contactData();
		QString targetGroup = mGroupCombo->text( mSelectedGroupIndex );

		if( !d || !d->getGroup().isEmpty() || d->getGroup() != targetGroup )
			return false;
	}
	return KListViewSearchLine::itemMatches( item, s );
}

void KKContactQuickSearchLine::reset()
{
	clear();
	mGroupCombo->setCurrentItem( 0 );
	slotGroupChanged( 0 );
}

void KKContactQuickSearchLine::slotGroupChanged( int index )
{
    mSelectedGroupIndex = index;

    updateSearch();
}
