/***************************************************************************
 *   Copyright (C) 2004 by Kazuki Ohta                                     *
 *   mover@hct.zaq.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KK_CONTACT_DATA_H_
#define _KK_CONTACT_DATA_H_

class QString;

// 2004-11-11 Kazuki Ohta <mover@hct.zaq.ne.jp>
// Experimental Format
class KKContactData {
public:
	// 2004-11-11 Kazuki Ohta <mover@hct.zaq.ne.jp>
	// The way creating KKContactData object is restricted
	// to constructor. This aims to detect all the location
	// which relates to KKContactData creation on compilation
	// time when format is changed
	KKContactData( const QString &furi,
		       const QString &fname,
		       const QString &postfix,
		       const QString &gr,
		       const QString &zipc,
		       const QString &addr1,
		       const QString &addr2)
	{
		furigana = furi;
		fullname = fname;
		namepostfix  = postfix;
		group    = gr;
		zipcode  = zipc;
		address1 = addr1;
		address2 = addr2;
	}

	QString getFurigana() const { return furigana; }
	QString getFullname() const { return fullname; }
	QString getNamePostfix() const { return namepostfix; }
	QString getGroup() const { return group; }
	QString getZipCode() const { return zipcode; }
	QString getAddress1() const { return address1; }
	QString getAddress2() const { return address2; }

	/*
	bool isValid() const {
		if( fullname.isEmpty() )
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	*/
private:
	QString furigana;
	QString fullname;
	QString namepostfix;
	QString group;
	QString zipcode;
	QString address1;
	QString address2;
};

#endif /* Not def: _KK_CONTACT_DATA_H_ */
