/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qdom.h>
#include <qlayout.h>
#include <qheader.h>
#include <qfile.h>
#include <qpainter.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kprinter.h>

#include "kkdoc.h"
#include "kkitem.h"
#include "dlgprint.h"

dlgPrint::dlgPrint( KKDoc* document, QWidget* parent, const char* name )
	: KDialogBase( KDialogBase::Plain, i18n("Print"), Ok|Cancel, Ok, parent, name )
{
	m_doc = document;
	setupWidgets();
	resize( configDialogSize( "dlgPrint" ) );
	readData();
}

dlgPrint::~dlgPrint()
{
	saveDialogSize( "dlgPrint" );
}

void dlgPrint::setupWidgets()
{
	QFrame* page = plainPage();
	(new QHBoxLayout( page ))->setAutoAdd( true );
	lvwAddress = new KListView( page );
	lvwAddress->addColumn( "" );
	lvwAddress->header()->hide();
	lvwAddress->setRootIsDecorated( true );
	lvwAddress->setFullWidth( true );
	lvwAddress->setSortColumn( -1 );
	lvwAddress->setAllColumnsShowFocus( true );

	setMainWidget( lvwAddress);
}

void dlgPrint::slotOk()
{
	if( print() ) KDialogBase::slotOk();
}

void dlgPrint::readData()
{
	QListViewItem* selectedItem = NULL;
	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/address.xml" );
	QDomDocument doc( "kkaddress" );
	QFile file( datafile );
	if( file.open( IO_ReadOnly ) )
	{
		if( !doc.setContent( &file ) )
		{
			file.close();
			return;
		}
		file.close();
	}
	else
	{
		return;
	}

	for( QDomNode np = doc.documentElement().firstChild(); !np.isNull(); np = np.nextSibling() )
	{
		QDomElement group = np.toElement();

		QCheckListItem* parent = new QCheckListItem( lvwAddress, group.attribute( "title" ), QCheckListItem::CheckBoxController );
		parent->setOpen( group.hasAttribute( "isopen" ) );
		parent->setPixmap( 0, SmallIcon( "folder" ) );
// 		if( group.hasAttribute( "isselected" ) ) selectedItem = parent;

		for( QDomNode nc = np.firstChild(); !nc.isNull(); nc = nc.nextSibling() )
		{
			QDomElement person = nc.toElement();
			Address doc;
			doc.direction = person.attribute( "direction" );
			doc.zipcode = person.attribute( "zipcode" );
			doc.address = person.attribute( "address" );
			doc.comment = person.attribute( "comment" );

			QCheckListItem* child = new QCheckListItem( parent, person.attribute( "direction" ).replace( "\n", " / " ), QCheckListItem::CheckBox );
			child->setPixmap( 0, SmallIcon( "kuser" ) );
// 			if( person.hasAttribute( "isselected" ) ) selectedItem = child;
			m_document[child] = doc;
		}
	}
	if( selectedItem )
	{
		lvwAddress->setSelected( selectedItem, true );
	}
	else
	{
		lvwAddress->setSelected( lvwAddress->firstChild(), true );
	}
}

bool dlgPrint::print()
{
	KPrinter printer;

	printer.setDocName( "KreetingKard" );
	printer.setPageSize( KPrinter::A6 );
	printer.setFullPage( true );

	KKItem* item = (KKItem*)m_doc->selectedItems().first();
	if( !item ) item = (KKItem*)m_doc->firstChild();
	if( item->parent() != NULL ) item = (KKItem*)item->parent();
	printer.setOrientation( ( item->orientation() == Horizontal ) ?  KPrinter::Landscape : KPrinter::Portrait );

	if( !printer.setup( this ) ) return false;
	printer.setColorMode( KPrinter::Color );

	bool newPage = false;
	QPainter p;
	p.begin( &printer );
	QListViewItem* parent = lvwAddress->firstChild();
	while( parent )
	{
		QListViewItem* child = parent->firstChild();
		while( child )
		{
			if( ((QCheckListItem*)child)->isOn() )
			{
				if( newPage )
				{
					printer.newPage();
				}
				else
				{
					newPage = true;
				}
				m_doc->print( p, m_document[child] );
			}
			child = child->nextSibling();
		}
		parent = parent->nextSibling();
	}
	p.end();
	return true;
}
