/***************************************************************************
 *   Copyright (C) 2004 by Tasuku Suzuki                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DLGADDRESSBOOK_H
#define DLGADDRESSBOOK_H

#include <qdom.h>
#include <qsplitter.h>
#include <qtable.h>
#include <qvbox.h>
#include <qlistview.h>
#include <qwidgetstack.h>
#include <qmap.h>

#include <klineedit.h>
#include <ktextedit.h>
#include <kdialogbase.h>
#include <kpushbutton.h>
#include <klistview.h>

#include "address.h"

class dlgAddressBook : public KDialogBase
{
	Q_OBJECT
public:
	dlgAddressBook( QWidget* parent = 0, const char* name = 0 );
	~dlgAddressBook();

public slots:
	void slotApply();
	void slotOk();

private slots:
	void selectionChanged( QListViewItem* item );
	void zipcode2address();
	void updateZipCode();
	void addGroup();
	void delGroup();
	void addPerson();
	void delPerson();
	void directionChanged();

private:
	QMap<QListViewItem*,Address> m_document;
	QSplitter* splBase;
	KListView* lvwLeft;
	KPushButton* btnGroupAdd;
	KPushButton* btnGroupDel;
	KPushButton* btnPersonAdd;
	KPushButton* btnPersonDel;
	QWidgetStack* stkRight;
	QTable* tblList;
	QVBox* vbxDetail;
	KLineEdit* txtZipCode;
	QListViewItem* m_currentItem;
	KTextEdit* txtDirection;
	KTextEdit* txtAddress;
	KTextEdit* txtComment;
	KPushButton* btnZipCode2Address;

	void setupWidgets();
	void readData();
	bool saveData();
	void createData( QDomDocument& doc );
	void cache();
};

#endif //DLGADDRESSBOOK_H
