/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [CLASS_DECL] */

static
Mapper* new_Mapper__interface(Ctx *ctx, knh_class_t scid, knh_class_t tcid)
{
	return new_Mapper(ctx, KNH_FLAG_MMF_INTERFACE, scid, tcid, knh_Mapper_fInterface, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

static
void knh_class_addInterface(Ctx *ctx, knh_class_t cid, knh_class_t icid)
{
	KNH_ASSERT(!knh_class_isInterface(icid));
	if(knh_class_instanceof(ctx, cid, icid)) {
		return ;
	}
	else {
		knh_class_t isupcid = icid;
		int allchecked = 1;
		while(isupcid != CLASS_Object) {
			ClassStruct *cs = ctx->tClass[isupcid].cstruct;
			size_t i;
			for(i = 0; i < knh_Array_size(cs->methods); i++) {
				Method *imtd = (Method*)knh_Array_n(cs->methods, i);
				if(knh_Method_isPrivate(imtd)) {
					continue;
				}
				else {
					Method *mtd = knh_Class_getMethod(ctx, cid, DP(imtd)->mn);
					if(IS_NOTNULL(mtd)) {
						if(!knh_MethodField_equalsType(DP(mtd)->mf, DP(imtd)->mf)) {
							char bufcm[CLASSNAME_BUFSIZ];
							knh_format_cmethodn(ctx, bufcm, sizeof(bufcm), DP(imtd)->cid, DP(imtd)->mn);
							DBG2_P("mismatch!! %s", bufcm);
							allchecked = 0;
						}
					}
				}
			}
			isupcid = ctx->tClass[isupcid].supcid;
		}
		if(allchecked) {
			isupcid = icid;
			while(isupcid != CLASS_Object) {
				ClassStruct *cs = ctx->tClass[isupcid].cstruct;
				size_t i;
				for(i = 0; i < knh_Array_size(cs->methods); i++) {
					Method *imtd = (Method*)knh_Array_n(cs->methods, i);
					if(knh_Method_isPrivate(imtd)) {
						continue;
					}
					else {
						Method *mtd = knh_Class_getMethod(ctx, cid, DP(imtd)->mn);
						if(IS_NULL(mtd)) {
							mtd = new_Method(ctx, 0, cid, DP(imtd)->mn, NULL);
							KNH_SETv(ctx, DP(mtd)->mf, DP(imtd)->mf);
							KNH_ASSERT(IS_NOTNULL(DP(mtd)->mf));
							knh_Class_addMethod(ctx, cid, mtd);
						}
					}
				}
				isupcid = ctx->tClass[isupcid].supcid;
			}
			DBG2_P("add interface %s to %s", CLASSN(icid), CLASSN(cid));
			knh_ClassMap_add(ctx, ctx->tClass[cid].cmap, new_Mapper__interface(ctx, cid, icid));
		}
	}
}

/* ------------------------------------------------------------------------ */

static
Object *knh_tClass_fdefault__OBJECT(Ctx *ctx, knh_class_t cid)
{
	return new_Object_init(ctx, ctx->tClass[cid].oflag, cid, 0);
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtCLASS_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	char bufn[CLASSNAME_BUFSIZ];
	knh_snprintf(bufn, sizeof(bufn), "%s.%s", knh_String_tochar(DP(ns)->nsname),
			sToken(StmtCLASS_class(stmt)));
	{
		knh_tClass_t *TC = NULL;
		knh_class_t cid  = knh_NameSpace_getClass(ctx, ns, B(bufn));
		knh_class_t supcid = CLASS_unknown, oldcid = CLASS_Object;
		if(SP(StmtCLASS_superclass(stmt))->tt == TT_ASIS) {
			supcid = CLASS_Object;
		}
		else {
			supcid = knh_NameSpace_getClass(ctx, ns, knh_Token_tobytes(ctx, StmtCLASS_superclass(stmt)));
			if(supcid == CLASS_unknown && cid == CLASS_unknown) {
				knh_Asm_perror(ctx, abr, KMSG_UCLASSN, NULL);
				supcid = CLASS_Object;
				knh_Token_perrata(ctx, StmtCLASS_superclass(stmt), CLASSN(supcid));
			}
			if(supcid != CLASS_unknown) {
				if(knh_class_isFinal(supcid)) {
					knh_Asm_perror(ctx, abr, KMSG_EEXTENDS, CLASSN(supcid));
					knh_Stmt_done(ctx, stmt);
					return 0;
				}
			}
		}
		if(cid == CLASS_unknown) {
			cid = knh_tClass_newId(ctx);
			KNH_ASSERT(ctx->tClass[cid].class_cid == NULL);
		}
		else {
			DEBUG3("redefine %s", CLASSN(cid));
			KNH_ASSERT_cid(cid);
			if(ctx->tClass[cid].bcid != CLASS_Object) {
				knh_Asm_perror(ctx, abr, KMSG_EOVERRIDE, CLASSN(cid));
				knh_Stmt_done(ctx, stmt);
				return 0;
			}
			if(!knh_StmtMETA_isOverride(ctx, stmt)) {
				knh_Asm_perror(ctx, abr, KMSG_AOVERRIDE, CLASSN(cid));
				knh_Stmt_done(ctx, stmt);
				return 0;
			}
			if(ctx->tClass[cid].supcid != supcid) {
				knh_Asm_perror(ctx, abr, KMSG_DIFFCLASSN, NULL);
				supcid = ctx->tClass[cid].supcid;
				knh_Token_perrata(ctx, StmtCLASS_superclass(stmt), CLASSN(supcid));
			}
			oldcid = cid;
			cid = knh_tClass_newId(ctx);
			KNH_ASSERT(ctx->tClass[cid].class_cid == NULL);
		}

		DP(StmtCLASS_class(stmt))->cid = cid;
		TC = (knh_tClass_t*)&(ctx->tClass[cid]);
		TC->cflag  = knh_StmtCLASS_flag(ctx, stmt);
		TC->oflag  = KNH_FLAG_CF2OF(TC->cflag);

		TC->bcid   = CLASS_Object;
		TC->supcid = supcid;
		if(supcid == CLASS_Object) {
			TC->offset = 0;
		}else {
			KNH_ASSERT(supcid < cid);
			TC->offset = ctx->tClass[supcid].bsize;
		}

		KNH_ASSERT(TC->class_cid == NULL);
		konoha_setClassName(ctx, cid, new_String(ctx, B(bufn), NULL));
		KNH_INITv(TC->cstruct, new_ClassStruct0(ctx, 0, 8));
		KNH_INITv(TC->cmap, new_ClassMap0(ctx, 0));
		KNH_INITv(TC->cspec, KNH_NULL);
		knh_NameSpace_setLocalName(ctx, ns, cid);

		if(oldcid != CLASS_Object) {
			knh_class_addInterface(ctx, cid, oldcid);
		}
		TC->fdefault = knh_tClass_fdefault__OBJECT;
		/* implements */ {
			Stmt *istmt = StmtCLASS_interface(stmt);
			if(SP(istmt)->stt != STT_DONE) {
				int i, n = DP(istmt)->size;
				for(i = 0; i < n; i++) {
					Token *tk = DP(stmt)->tokens[i];
					knh_class_t icid = knh_NameSpace_getClass(ctx, ns, knh_Token_tobytes(ctx, tk));
					if(icid == CLASS_unknown) {
						knh_Token_perror(ctx, tk, KMSG_UCLASSN);
						continue;
					}
					if(!knh_class_isInterface(icid)) {
						knh_Token_perror(ctx, tk, KMSG_EIMPLEMENTS);
						continue;
					}
					knh_class_addInterface(ctx, cid, icid);
				}
			}
		}
	}
	return 1;
}

/* ------------------------------------------------------------------------ */
/* [declc] */

static
int knh_StmtIMPORT_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	String *fname = (String*)DP(StmtIMPORT_file(stmt))->data;
	char bufp[FILENAME_BUFSIZ], buff[FILENAME_BUFSIZ];
	String *cfname = knh_tfileid_name(ctx, SP(stmt)->fileid);
	KNH_ASSERT(IS_String(fname));
	if(knh_String_endsWith(cfname, STEXT(".k"))) {
		knh_format_parentpath(bufp, sizeof(bufp), knh_String_tobytes(cfname), 1);
	}
	else {
		bufp[0]=0;
	}
	knh_format_catpath(buff, sizeof(buff), B(bufp), knh_String_tobytes(fname));
	if(!knh_isfile(ctx, B(buff))) {
		knh_Asm_perror(ctx, abr, KMSG_UPATH, buff);
		return 0;
	}
	knh_fileid_t fileid = knh_tName_getFileId(ctx, B(buff));
	if(!knh_NameSpace_isLoaded(ctx, ns, fileid)) {
		knh_NameSpace_loaded(ctx, ns, fileid);
		InputStream *in = new_FileInputStream(ctx, B(buff));
		if(knh_InputStream_isClosed(in)) {
			knh_Asm_perror(ctx, abr, KMSG_UPATH, buff);
			return 0;
		}
		DP(in)->fileid = fileid;
		knh_InputStream_setEncoding(ctx, in, knh_systemEncoding);
		konohac_eval(ctx, DP(ns)->nsname, in);
	}
	else {
		DEBUG3("already imported %s", buff);
	}
	return 1;
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUIMPORT_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	Token *tk = DP(stmt)->tokens[0];
	knh_bytes_t name = knh_Token_tobytes(ctx, tk);
	knh_index_t loc = knh_bytes_rindex(name, '.');
	if(loc != -1) {
		if(knh_System_using(ctx, knh_bytes_first(name, loc))) {
			knh_class_t newcid = knh_NameSpace_getClass(ctx, knh_rootNameSpace, name);
			if(newcid == CLASS_unknown) {
				knh_Token_perror(ctx, tk, KMSG_UCLASSN);
				return 0;
			}
			knh_class_t oldcid = knh_NameSpace_getClass(ctx, ns, knh_bytes_last(name, loc+1));
			if(oldcid != CLASS_unknown && newcid != oldcid) {
				KNH_WARNING(ctx, "ovrriding.. %s => %s", CLASSN(oldcid), CLASSN(newcid));
			}
			knh_NameSpace_setLocalName(ctx, ns, newcid);
			return 1;
		}
	}else {
		if(knh_System_using(ctx, name)) {
			if(knh_Token_isTailWildCard(tk)) {
				knh_NameSpace_import(ctx, ns, name);
			}
			return 1;
		}
	}
	knh_Token_perror(ctx, tk, KMSG_UPACKAGE);
	return 0;
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUALIAS_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	DBG2_DUMP(ctx, stmt, KNH_NULL, "decl");
	TODO();
	return 1;
}

/* ------------------------------------------------------------------------ */

static
char *knh_format_classurn(Ctx *ctx, char *buf, size_t bufsiz, knh_class_t bcid, knh_bytes_t urn)
{
	knh_snprintf(buf, bufsiz, KNH_CLASSSPEC_FMT, CLASSN(bcid), urn.buf);
	return buf;
}

/* ------------------------------------------------------------------------ */

static
void knh_NameSpace_setTagName(Ctx *ctx, NameSpace *o, String *name, knh_class_t cid)
{
	KNH_ASSERT(IS_NameSpace(o));
	KNH_ASSERT_cid(cid);
	knh_DictSet_set(ctx, DP(o)->name2cidDictSet, name, (knh_uint_t)(cid+1));
	knh_bytes_t n = knh_String_tobytes(name);
	knh_index_t loc = knh_bytes_index(n, ':');
	if(loc != -1) {
		n = knh_bytes_last(n, loc+1);
		if(isupper(n.buf[0])) {
			TODO();
			knh_DictSet_set(ctx, DP(o)->name2cidDictSet, new_String(ctx, n, name), (knh_uint_t)(cid+1));
		}
	}
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtXCLASS_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns, knh_class_t bcid)
{
	Token *tkclassn = DP(stmt)->tokens[0];
	Token *tkurn = DP(stmt)->tokens[1];

	char bufcu[CLASSNAME_BUFSIZ];
	knh_format_classurn(ctx, bufcu, sizeof(bufcu), bcid, knh_Token_tobytes(ctx, tkurn));
	knh_class_t cid = knh_tClass_findcid(ctx, B(bufcu));
	if(cid == bcid || cid == CLASS_unknown) {
		knh_Token_perror(ctx, tkurn, KMSG_UPATH);
		cid = bcid;
	}

	knh_class_t oldcid = knh_NameSpace_getClass(ctx, ns, knh_Token_tobytes(ctx, tkclassn));
	if(oldcid != CLASS_unknown && cid != oldcid) {
		KNH_WARNING(ctx, "Overriding %s", knh_Token_tobytes(ctx, tkclassn));
	}

	KNH_ASSERT(IS_String(DP(tkclassn)->data));
	knh_NameSpace_setTagName(ctx, ns, (String*)DP(tkclassn)->data, cid);
	return 1;
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUVOCAB_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	return knh_StmtXCLASS_decl(ctx, stmt, abr, ns, CLASS_String);
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUENUM_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	return knh_StmtXCLASS_decl(ctx, stmt, abr, ns, CLASS_Int);
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUUNIT_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	return knh_StmtXCLASS_decl(ctx, stmt, abr, ns, CLASS_Float);
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUFUNC_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	Token *tk = DP(stmt)->tokens[0];
	knh_bytes_t name = knh_Token_tobytes(ctx, tk);
	if(SP(tk)->tt == TT_CMETHODN) {
		knh_index_t loc = knh_bytes_rindex(name, '.');
		knh_class_t cid = knh_NameSpace_getClass(ctx, ns, knh_bytes_first(name, loc));
		if(cid == CLASS_unknown) {
			knh_Token_perror(ctx, tk, KMSG_UCLASSN);
			return 0;
		}
		knh_methodn_t mn = knh_tName_getMethodn(ctx, knh_bytes_last(name, loc+1), METHODN_NONAME);
		if(mn == METHODN_NONAME) {
			knh_Token_perror(ctx, tk, KMSG_UMETHODN);
			return 0;
		}
		knh_NameSpace_setFuncClass(ctx, ns, mn, cid);
	}
	else {
		knh_class_t cid = knh_NameSpace_getClass(ctx, ns, name);
		if(cid == CLASS_unknown) {
			knh_Token_perror(ctx, tk, KMSG_UCLASSN);
			return 0;
		}
		else {
			KNH_ASSERT_cid(cid);
			Array *a = (ctx->tClass[cid].cstruct)->methods;
			size_t i;
			for(i = 0; i < knh_Array_size(a); i++) {
				Method *mtd = (Method*)knh_Array_n(a, i);
				KNH_ASSERT(IS_Method(mtd));
				if(!knh_Method_isStatic(mtd)) continue;
				knh_NameSpace_setFuncClass(ctx, ns, DP(mtd)->mn, cid);
				if(knh_Context_isVerbose(ctx)) {
					char bufcm[CLASSNAME_BUFSIZ];
					knh_format_cmethodn(ctx, bufcm, sizeof(bufcm), cid, DP(mtd)->mn);
					KNH_NOTICE(ctx, "using %s", bufcm);
				}
			}
		}
	}
	return 1;
}

/* ------------------------------------------------------------------------ */

static
int knh_StmtUMAPMAP_decl(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns)
{
	DBG2_DUMP(ctx, stmt, KNH_NULL, "decl");
	TODO();
	return 1;
}

///* ------------------------------------------------------------------------ */
//
//void knh_stmtvisit_declc__weave(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns, int level)
//{
//	//DEBUG_STMT(ctx, stmt);
//	//Asm *mc = (Asm*)v;
//	/* ['weave', 'ANY', 'METHODFN'] */
//	fprintf(stdout, "weaving %s into %s..\n", sToken((Token*)stmt->terms[1]), sToken((Token*)stmt->terms[2]));
//	Method *mtd = knh_Class_getMethod(ctx, CLASS_Amazon, METHODN_placeOrder);
//	if(IS_Method(mtd)) {
//		String *aspect = ((Token*)stmt->terms[1])->data;
//		if(IS_NULL(aspect)) {
//			knh_weave(ctx, NULL, mtd);
//		}
//		else if(knh_String_equals(aspect, STEXT("null"))) {
//			knh_weave(ctx, NULL, mtd);
//		}
//		else if(knh_String_equals(aspect, STEXT("RBAC"))) {
//			knh_weave(ctx, knh_security_RBAC, mtd);
//		}
//		else if(knh_String_equals(aspect, STEXT("Audit"))) {
//			knh_weave(ctx, knh_security_Audit, mtd);
//		}
//		else {
//			KNH_THROWf(ctx, "NoSuchAspect!!: %s", knh_String_tochar(aspect));
//		}
//	}
//	else{
//		DEBUG("what?");
//	}
//	knh_Stmt_done(ctx, stmt);
//}

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

static
int knh_Stmt_eval(Ctx *ctx, Stmt *stmt, Asm *abr, NameSpace *ns, int isEval)
{
	Script *scr = knh_Asm_getScript(ctx, abr);
	Method *mtd = knh_Class_getMethod(ctx, knh_Object_cid(scr), METHODN_lambda);
	knh_sfp_t *lsfp = KNH_LOCAL(ctx);

	int isExpr = knh_stmt_isExpr(SP(stmt)->stt);
	knh_methodn_t mt = SP(stmt)->stt == STT_MT ? METHODN__s : METHODN__k ;
	if(isExpr) {
		if(SP(stmt)->stt == STT_CALL1) {
			SP(stmt)->stt = STT_RETURN;
		}
		else if(SP(stmt)->stt == STT_LET) {
			isExpr = 0;
		}
		else {
			Stmt *newstmt = new_Stmt(ctx, 0, STT_RETURN);
			knh_Stmt_add(ctx, newstmt, UP(stmt));
			stmt = newstmt;
		}
	}
	KNH_LPUSH(ctx, stmt);
	KNH_ASM_METHOD(ctx, abr, mtd, NULL, stmt, 0 /* isIteration */);

	if(knh_Method_isAbstract(mtd)) {
		KNH_LOCALBACK(ctx, lsfp);
		return 0;
	}

	if(isEval) {
		ExceptionHandler *hdr = new_ExceptionHandler(ctx);
		KNH_MOV(ctx, lsfp[0].o, hdr);
		KNH_TRY(ctx, L_CATCH, lsfp, 0);
		{
			KNH_MOV(ctx, lsfp[2].o, scr);
			KNH_SCALL(ctx, lsfp, 1, mtd, 0/*args*/);
			if(isExpr && !knh_Stmt_isVOID(stmt)) {
				DBG2_P("returning %s %lld", CTXCLASSN(knh_Object_cid(lsfp[1].o)), lsfp[1].ivalue);
				knh_sfp_format(ctx, lsfp+1, mt, KNH_STDOUT, KNH_NULL);
				knh_write_EOL(ctx, KNH_STDOUT);
			}
		}
		KNH_LOCALBACK(ctx, lsfp);
		return 1;

		/* catch */
		L_CATCH:;
		KNH_PRINT_STACKTRACE(ctx, lsfp, 0);
	}
	return 1;
}

/* ------------------------------------------------------------------------ */

int
konohac_compile(Ctx *ctx, String *nsname, Stmt *stmt_head, int isEval)
{
	Asm *abr = knh_Context_getAsm(ctx);
	NameSpace *ns = knh_Context_setNameSpace(ctx, nsname);
	Stmt *cur = stmt_head;

	DP(abr)->fileid = SP(stmt_head)->fileid;
	while(IS_Stmt(cur)) {
		knh_stmt_t stt = SP(cur)->stt;
		DP(abr)->line = SP(cur)->line;
		DP(abr)->level = 0;
		int res = 1;
		switch(stt) {
		case STT_CLASS:
			res = knh_StmtCLASS_decl(ctx, cur, abr, ns);
			break;
		case STT_IMPORT:
			res = knh_StmtIMPORT_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UIMPORT:
			res = knh_StmtUIMPORT_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UALIAS:
			res = knh_StmtUALIAS_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UVOCAB:
			res = knh_StmtUVOCAB_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UENUM:
			res = knh_StmtUENUM_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UUNIT:
			res = knh_StmtUUNIT_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UFUNC:
			res = knh_StmtUFUNC_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		case STT_UMAPMAP:
			res = knh_StmtUMAPMAP_decl(ctx, cur, abr, ns);
			knh_Stmt_done(ctx, cur);
			break;
		}
		if(res == 0) {
			return 0;
		}
		cur = DP(cur)->next;
	}

	cur = stmt_head;
	while(IS_Stmt(cur)) {
		knh_stmt_t stt = SP(cur)->stt;
		DP(abr)->line = SP(cur)->line;
		DP(abr)->level = 0;
		Term *tm = TM(cur);
		switch(stt) {
		case STT_CLASS:
			tm = knh_StmtCLASS_typing(ctx, cur, abr, ns);
			break;
		case STT_METHOD:
			tm = knh_StmtMETHOD_typing(ctx, cur, abr, ns);
			break;
//		case STT_FORMAT:
//			tm = knh_StmtFORMAT_typing(ctx, cur, abr, ns);
//			break;
		case STT_DECL: {
			knh_Asm_initThisScript(ctx, abr);
			tm = knh_StmtDECL_typing(ctx, cur, abr, ns);
			break;
		}
		case STT_LET: {
			knh_Asm_initThisScript(ctx, abr);
			tm = knh_StmtLET_typing(ctx, cur, abr, ns, TYPE_void);
			break;
		}
		}
		if(tm == NULL) return 0;
		cur = DP(cur)->next;
	}

	cur = stmt_head;
	while(IS_Stmt(cur)) {
		knh_stmt_t stt = SP(cur)->stt;
		KNH_ASM_SETLINE(ctx, abr, SP(cur)->line);
		DP(abr)->level = 0;
		switch(stt) {
		case STT_CLASS:
			knh_StmtCLASS_asm(ctx, cur, abr); break;
		case STT_METHOD:
			knh_StmtMETHOD_asm(ctx, cur, abr); break;
		case STT_FORMAT:
			knh_StmtFORMAT_asm(ctx, cur, abr); break;
		case STT_DONE:
			break;
		default:
			if(!knh_Stmt_eval(ctx, cur, abr, ns, isEval)) {
				return 0;
			}
		}
		knh_Stmt_done(ctx, cur);
		cur = DP(cur)->next;
	}
	return 1;
}

/* ======================================================================== */
/* [main] */

static
Stmt *konohac_parse(Ctx *ctx, InputStream *in)
{
	Token *tk = new_Token(ctx, 0, DP(in)->fileid, 0, knh_char_totoken('{'));
	KNH_LPUSH(ctx, tk);
	KNH_LPUSH(ctx, in);
	knh_Token_parse(ctx, tk, in);
	DBG2_DUMP(ctx, tk, KNH_NULL, "tokens");
	Stmt *stmt = new_StmtINSTMT(ctx, tk); // new_StmtDONE(ctx);
	return stmt;
}

/* ------------------------------------------------------------------------ */

void konohac_eval(Ctx *ctx, String *nsname, InputStream *in)
{
	knh_sfp_t *lsfp = KNH_LOCAL(ctx);
	KNH_LPUSH(ctx, new_ExceptionHandler(ctx));
	KNH_TRY(ctx, L_CATCH, lsfp, 0);
	{
		Stmt *stmt = konohac_parse(ctx, in);
		KNH_LPUSH(ctx, stmt);
		DBG2_DUMP(ctx, stmt, KNH_NULL, "stmt");
		konohac_compile(ctx, nsname, stmt, !knh_Context_isCompiling(ctx) /* isrun 1 */);
	}
	KNH_LOCALBACK(ctx, lsfp);
	return;

	/* catch */
	L_CATCH:;
	KNH_PRINT_STACKTRACE(ctx, lsfp, 0);
	return;
}

/* ------------------------------------------------------------------------ */

Stmt *konoha_parse(Ctx *ctx, char *kscript)
{
	knh_cwb_t cwb = new_cwb(ctx);
	knh_Bytes_write(ctx, cwb.ba, B(kscript));
	knh_Bytes_putc(ctx, cwb.ba, ';');
	InputStream *in = new_BytesInputStream(ctx, cwb.ba, cwb.pos, knh_Bytes_size(cwb.ba));
	DP(in)->fileid = 0;
	DP(in)->line = 0;
	Stmt *stmt = konohac_parse(ctx, in);
	knh_cwb_clear(cwb);
	return stmt;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
