/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [structs] */

static
knh_hashsetentry_t *new_hashsetentry(Ctx *ctx, HashSet *o)
{
	knh_hashsetentry_t *e = DP(o)->unused;
	if(e != NULL) {
		DP(o)->unused = e->next;
		return e;
	}
	else if(DP(o)->table_size == 0) {
		TODO()
		KNH_ABORT();
//		knh_HashSet_init(ctx, DP(o), KNH_HASHMAP_INITSIZE, NULL);
//		e = DP(o)->unused;
//		DP(o)->unused = e->next;
//		return e;
		return NULL;
	}
	else {
		knh_HashSet_struct *b = DP(o);
		knh_hashsetentry_t *newtable = (knh_hashsetentry_t*)KNH_MALLOC(ctx, sizeof(knh_hashsetentry_t) * b->table_size);
		size_t i;
		for(i = 0; i < b->table_size; i++) {
			newtable[i].hcode = 0;
			newtable[i].key = NULL;
			newtable[i].value = 0;
			newtable[i].next = (i == b->table_size - 1) ? NULL : &(newtable[i+1]);
		}
		e = &(newtable[0]);
		b->unused = &(newtable[1]);

		if(b->ex_size  == b->ex_capacity) {
			if(b->ex_capacity == 0) {
				b->ex_capacity = 8;
				b->ex_tables = (knh_hashsetentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashsetentry_t*) * b->ex_capacity);
			}
			else {
				b->ex_capacity *= 2;
				knh_hashsetentry_t **newtbll = (knh_hashsetentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashsetentry_t*) * b->ex_capacity);
				knh_memcpy(newtbll, b->ex_tables, sizeof(knh_hashsetentry_t*) * b->ex_size);
				KNH_FREE(ctx, b->ex_tables, sizeof(knh_hashsetentry_t*) * b->ex_size);
				b->ex_tables = newtbll;
			}
		}
		b->ex_tables[b->ex_size] = newtable;
		b->ex_size++;

		if(b->ex_size * (b->table_size+1) > b->capacity) {
			size_t nc = b->capacity * 2 + 1;
			knh_hashsetentry_t **newarray = (knh_hashsetentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashsetentry_t*) * nc);
			knh_bzero(newarray, sizeof(knh_hashsetentry_t*) * nc);

			size_t i, j;
			knh_hashsetentry_t *t = b->table;
			for(i = 0; i < b->table_size; i++) {
				knh_uint_t h = t[i].hcode % nc;
				t[i].next = newarray[h];
				newarray[h] = &(t[i]);
			}
			for(j = 0; j < b->ex_size - 1; j++) {
				t = b->ex_tables[j];
				for(i = 0; i < b->table_size; i++) {
					knh_uint_t h = t[i].hcode % nc;
					t[i].next = newarray[h];
					newarray[h] = &(t[i]);
				}
			}
			KNH_FREE(ctx, b->array, sizeof(knh_hashsetentry_t*) * b->capacity);
			b->array = newarray;
			b->capacity = nc;
		}
		return e;
	}
}

/* ======================================================================== */
/* [constructors] */

HashSet* new_HashSet(Ctx *ctx, char *name, size_t capacity)
{
	if(capacity == 0) capacity = KNH_HASHMAP_INITSIZE;
	HashSet* o = (HashSet*)new_Object_bcid(ctx, CLASS_HashSet, capacity);
	if(name != NULL) {
		DP(o)->DBG_name = name;
	}
	return o;
}

/* ======================================================================== */
/* [methods] */

knh_uint_t knh_HashSet_get__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashsetentry_t *cur = DP(o)->array[h];
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			return cur->value;
		}
		cur = cur->next;
	}
	return 0;
}

/* ------------------------------------------------------------------------ */

void knh_HashSet_set__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode, knh_uint_t value)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashsetentry_t *cur = DP(o)->array[h];
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			cur->value = value;
			return ;
		}
		cur = cur->next;
	}
	cur = new_hashsetentry(ctx, o);
	cur->hcode = hcode;
	KNH_INITv(cur->key, KNH_NULL);
	cur->value = value;
	cur->next = DP(o)->array[h];
	DP(o)->array[h] = cur;
	DP(o)->size++;
}

/* ------------------------------------------------------------------------ */

void knh_HashSet_add__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashsetentry_t *cur = DP(o)->array[h];
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			cur->value++;
			return ;
		}
		cur = cur->next;
	}
	cur = new_hashsetentry(ctx, o);
	cur->hcode = hcode;
	KNH_INITv(cur->key, KNH_NULL);
	cur->value = 1;
	cur->next = DP(o)->array[h];
	DP(o)->array[h] = cur;
	DP(o)->size++;
}

/* ------------------------------------------------------------------------ */

void knh_HashSet_remove__hcode(Ctx *ctx, HashSet *o, knh_hcode_t hcode)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashsetentry_t *cur = DP(o)->array[h];
	knh_hashsetentry_t **prev_next = &(DP(o)->array[h]);
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			prev_next[0] = cur->next;
			cur->next = DP(o)->unused;
			DP(o)->unused = cur;
			cur->hcode = 0;
			cur->key = NULL;
			cur->value = 0;
			DP(o)->size--;
			return ;
		}
		prev_next = &(cur->next);
		cur = cur->next;
	}
}

///* ------------------------------------------------------------------------ */
//
//void knh_HashSet_clear(Ctx *ctx, HashSet *o)
//{
//	int init = DP(o)->capacity;
//	knh_HashSet_traverse(ctx, DP(o), knh_Object_sweep);
//	knh_HashSet_init(ctx, DP(o), init, NULL);
//}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
