/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef STRUCT__H
#define STRUCT__H

#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

static knh_StringData_t StringData[] = {
	{"", TSN_EMPTY}, 
	{"\t", TSN_TAB}, 
	{"\n", TSN_LF}, 
	{" ", TSN_SPC}, 
	{"EOL", TSN_EOL}, 
	{"BEGIN", TSN_BEGIN}, 
	{"END", TSN_END}, 
	{"void", TSN_void}, 
	{"true", TSN_true}, 
	{"false", TSN_false}, 
	{"null", TSN_null}, 
	{"main", TSN_main}, 
	{""KONOHA_ENCODING"", TSN_ENCODING}, 
	{"/dev/null", TSN_DEVNULL}, 
	{"/dev/stdin", TSN_DEVSTDIN}, 
	{"/dev/stderr", TSN_DEVSTDERR}, 
	{"/dev/stdout", TSN_DEVSTDOUT}, 
	{"@label", TSN_ATlabel}, 
	{"Security!!", TSN_SecurityException}, 
	{"(", TSN_LP}, 
	{")", TSN_RP}, 
	{"{", TSN_LB}, 
	{"}", TSN_RB}, 
	{"[", TSN_LS}, 
	{"]", TSN_RS}, 
	{NULL}
};

static char* StructName[] =  {
	"Object",
	"Any",
	"Nue",
	"Boolean",
	"Number",
	"Int",
	"Float",
	"String",
	"Bytes",
	"Tuple2",
	"Range",
	"Array",
	"IArray",
	"FArray",
	"Iterator",
	"DictMap",
	"DictSet",
	"HashMap",
	"HashSet",
	"LRUHashMap",
	"DictIdx",
	"Class",
	"ClassStruct",
	"MethodField",
	"Method",
	"Mapper",
	"ClassMap",
	"Closure",
	"AffineConv",
	"IntUnit",
	"FloatUnit",
	"Regex",
	"BytesConv",
	"StringUnit",
	"InputStream",
	"OutputStream",
	"Connection",
	"ResultSet",
	"Exception",
	"ExceptionHandler",
	"Script",
	"NameSpace",
	"System",
	"Context",
	"Token",
	"Stmt",
	"Asm",
	"KLRCode",
};

static knh_StructData_t StructData[] = {
	{
		"Object", STRUCT_Object, FLAG_Object, 0,
		(knh_fstruct_init)knh_ObjectField_init,
		(knh_fstruct_copy)knh_ObjectField_copy, 
		(knh_fstruct_traverse)knh_ObjectField_traverse,
		(knh_fstruct_compareTo)knh_ObjectField_compareTo,
		(knh_fstruct_hashCode)knh_ObjectField_hashCode,
		(knh_fstruct_newClass)knh_ObjectField_newClass
	},
	{
		"Any", STRUCT_Any, FLAG_Any, 0,
		(knh_fstruct_init)knh_Any_init,
		(knh_fstruct_copy)knh_Any_copy, 
		(knh_fstruct_traverse)knh_Any_traverse,
		(knh_fstruct_compareTo)knh_Any_compareTo,
		(knh_fstruct_hashCode)knh_Any_hashCode,
		(knh_fstruct_newClass)knh_Any_newClass
	},
	{
		"Nue", STRUCT_Nue, FLAG_Nue, 0,
		(knh_fstruct_init)knh_Nue_init,
		(knh_fstruct_copy)knh_Nue_copy, 
		(knh_fstruct_traverse)knh_Nue_traverse,
		(knh_fstruct_compareTo)knh_Nue_compareTo,
		(knh_fstruct_hashCode)knh_Nue_hashCode,
		(knh_fstruct_newClass)knh_Nue_newClass
	},
	{
		"Boolean", STRUCT_Boolean, FLAG_Boolean, 0,
		(knh_fstruct_init)knh_Boolean_init,
		(knh_fstruct_copy)knh_Boolean_copy, 
		(knh_fstruct_traverse)knh_Boolean_traverse,
		(knh_fstruct_compareTo)knh_Boolean_compareTo,
		(knh_fstruct_hashCode)knh_Boolean_hashCode,
		(knh_fstruct_newClass)knh_Boolean_newClass
	},
	{
		"Number", STRUCT_Number, FLAG_Number, 0,
		(knh_fstruct_init)knh_Number_init,
		(knh_fstruct_copy)knh_Number_copy, 
		(knh_fstruct_traverse)knh_Number_traverse,
		(knh_fstruct_compareTo)knh_Number_compareTo,
		(knh_fstruct_hashCode)knh_Number_hashCode,
		(knh_fstruct_newClass)knh_Number_newClass
	},
	{
		"Int", STRUCT_Int, FLAG_Int, 0,
		(knh_fstruct_init)knh_Int_init,
		(knh_fstruct_copy)knh_Int_copy, 
		(knh_fstruct_traverse)knh_Int_traverse,
		(knh_fstruct_compareTo)knh_Int_compareTo,
		(knh_fstruct_hashCode)knh_Int_hashCode,
		(knh_fstruct_newClass)knh_Int_newClass
	},
	{
		"Float", STRUCT_Float, FLAG_Float, 0,
		(knh_fstruct_init)knh_Float_init,
		(knh_fstruct_copy)knh_Float_copy, 
		(knh_fstruct_traverse)knh_Float_traverse,
		(knh_fstruct_compareTo)knh_Float_compareTo,
		(knh_fstruct_hashCode)knh_Float_hashCode,
		(knh_fstruct_newClass)knh_Float_newClass
	},
	{
		"String", STRUCT_String, FLAG_String, 0,
		(knh_fstruct_init)knh_String_init,
		(knh_fstruct_copy)knh_String_copy, 
		(knh_fstruct_traverse)knh_String_traverse,
		(knh_fstruct_compareTo)knh_String_compareTo,
		(knh_fstruct_hashCode)knh_String_hashCode,
		(knh_fstruct_newClass)knh_String_newClass
	},
	{
		"Bytes", STRUCT_Bytes, FLAG_Bytes, 0,
		(knh_fstruct_init)knh_Bytes_init,
		(knh_fstruct_copy)knh_Bytes_copy, 
		(knh_fstruct_traverse)knh_Bytes_traverse,
		(knh_fstruct_compareTo)knh_Bytes_compareTo,
		(knh_fstruct_hashCode)knh_Bytes_hashCode,
		(knh_fstruct_newClass)knh_Bytes_newClass
	},
	{
		"Tuple2", STRUCT_Tuple2, FLAG_Tuple2, 0,
		(knh_fstruct_init)knh_Tuple2_init,
		(knh_fstruct_copy)knh_Tuple2_copy, 
		(knh_fstruct_traverse)knh_Tuple2_traverse,
		(knh_fstruct_compareTo)knh_Tuple2_compareTo,
		(knh_fstruct_hashCode)knh_Tuple2_hashCode,
		(knh_fstruct_newClass)knh_Tuple2_newClass
	},
	{
		"Range", STRUCT_Range, FLAG_Range, 0,
		(knh_fstruct_init)knh_Range_init,
		(knh_fstruct_copy)knh_Range_copy, 
		(knh_fstruct_traverse)knh_Range_traverse,
		(knh_fstruct_compareTo)knh_Range_compareTo,
		(knh_fstruct_hashCode)knh_Range_hashCode,
		(knh_fstruct_newClass)knh_Range_newClass
	},
	{
		"Array", STRUCT_Array, FLAG_Array, 0,
		(knh_fstruct_init)knh_Array_init,
		(knh_fstruct_copy)knh_Array_copy, 
		(knh_fstruct_traverse)knh_Array_traverse,
		(knh_fstruct_compareTo)knh_Array_compareTo,
		(knh_fstruct_hashCode)knh_Array_hashCode,
		(knh_fstruct_newClass)knh_Array_newClass
	},
	{
		"IArray", STRUCT_IArray, FLAG_IArray, 0,
		(knh_fstruct_init)knh_IArray_init,
		(knh_fstruct_copy)knh_IArray_copy, 
		(knh_fstruct_traverse)knh_IArray_traverse,
		(knh_fstruct_compareTo)knh_IArray_compareTo,
		(knh_fstruct_hashCode)knh_IArray_hashCode,
		(knh_fstruct_newClass)knh_IArray_newClass
	},
	{
		"FArray", STRUCT_FArray, FLAG_FArray, 0,
		(knh_fstruct_init)knh_FArray_init,
		(knh_fstruct_copy)knh_FArray_copy, 
		(knh_fstruct_traverse)knh_FArray_traverse,
		(knh_fstruct_compareTo)knh_FArray_compareTo,
		(knh_fstruct_hashCode)knh_FArray_hashCode,
		(knh_fstruct_newClass)knh_FArray_newClass
	},
	{
		"Iterator", STRUCT_Iterator, FLAG_Iterator, sizeof(knh_Iterator_struct),
		(knh_fstruct_init)knh_Iterator_init,
		(knh_fstruct_copy)knh_Iterator_copy, 
		(knh_fstruct_traverse)knh_Iterator_traverse,
		(knh_fstruct_compareTo)knh_Iterator_compareTo,
		(knh_fstruct_hashCode)knh_Iterator_hashCode,
		(knh_fstruct_newClass)knh_Iterator_newClass
	},
	{
		"DictMap", STRUCT_DictMap, FLAG_DictMap, 0,
		(knh_fstruct_init)knh_DictMap_init,
		(knh_fstruct_copy)knh_DictMap_copy, 
		(knh_fstruct_traverse)knh_DictMap_traverse,
		(knh_fstruct_compareTo)knh_DictMap_compareTo,
		(knh_fstruct_hashCode)knh_DictMap_hashCode,
		(knh_fstruct_newClass)knh_DictMap_newClass
	},
	{
		"DictSet", STRUCT_DictSet, FLAG_DictSet, 0,
		(knh_fstruct_init)knh_DictSet_init,
		(knh_fstruct_copy)knh_DictSet_copy, 
		(knh_fstruct_traverse)knh_DictSet_traverse,
		(knh_fstruct_compareTo)knh_DictSet_compareTo,
		(knh_fstruct_hashCode)knh_DictSet_hashCode,
		(knh_fstruct_newClass)knh_DictSet_newClass
	},
	{
		"HashMap", STRUCT_HashMap, FLAG_HashMap, sizeof(knh_HashMap_struct),
		(knh_fstruct_init)knh_HashMap_init,
		(knh_fstruct_copy)knh_HashMap_copy, 
		(knh_fstruct_traverse)knh_HashMap_traverse,
		(knh_fstruct_compareTo)knh_HashMap_compareTo,
		(knh_fstruct_hashCode)knh_HashMap_hashCode,
		(knh_fstruct_newClass)knh_HashMap_newClass
	},
	{
		"HashSet", STRUCT_HashSet, FLAG_HashSet, sizeof(knh_HashSet_struct),
		(knh_fstruct_init)knh_HashSet_init,
		(knh_fstruct_copy)knh_HashSet_copy, 
		(knh_fstruct_traverse)knh_HashSet_traverse,
		(knh_fstruct_compareTo)knh_HashSet_compareTo,
		(knh_fstruct_hashCode)knh_HashSet_hashCode,
		(knh_fstruct_newClass)knh_HashSet_newClass
	},
	{
		"LRUHashMap", STRUCT_LRUHashMap, FLAG_LRUHashMap, sizeof(knh_LRUHashMap_struct),
		(knh_fstruct_init)knh_LRUHashMap_init,
		(knh_fstruct_copy)knh_LRUHashMap_copy, 
		(knh_fstruct_traverse)knh_LRUHashMap_traverse,
		(knh_fstruct_compareTo)knh_LRUHashMap_compareTo,
		(knh_fstruct_hashCode)knh_LRUHashMap_hashCode,
		(knh_fstruct_newClass)knh_LRUHashMap_newClass
	},
	{
		"DictIdx", STRUCT_DictIdx, FLAG_DictIdx, 0,
		(knh_fstruct_init)knh_DictIdx_init,
		(knh_fstruct_copy)knh_DictIdx_copy, 
		(knh_fstruct_traverse)knh_DictIdx_traverse,
		(knh_fstruct_compareTo)knh_DictIdx_compareTo,
		(knh_fstruct_hashCode)knh_DictIdx_hashCode,
		(knh_fstruct_newClass)knh_DictIdx_newClass
	},
	{
		"Class", STRUCT_Class, FLAG_Class, 0,
		(knh_fstruct_init)knh_Class_init,
		(knh_fstruct_copy)knh_Class_copy, 
		(knh_fstruct_traverse)knh_Class_traverse,
		(knh_fstruct_compareTo)knh_Class_compareTo,
		(knh_fstruct_hashCode)knh_Class_hashCode,
		(knh_fstruct_newClass)knh_Class_newClass
	},
	{
		"ClassStruct", STRUCT_ClassStruct, FLAG_ClassStruct, 0,
		(knh_fstruct_init)knh_ClassStruct_init,
		(knh_fstruct_copy)knh_ClassStruct_copy, 
		(knh_fstruct_traverse)knh_ClassStruct_traverse,
		(knh_fstruct_compareTo)knh_ClassStruct_compareTo,
		(knh_fstruct_hashCode)knh_ClassStruct_hashCode,
		(knh_fstruct_newClass)knh_ClassStruct_newClass
	},
	{
		"MethodField", STRUCT_MethodField, FLAG_MethodField, 0,
		(knh_fstruct_init)knh_MethodField_init,
		(knh_fstruct_copy)knh_MethodField_copy, 
		(knh_fstruct_traverse)knh_MethodField_traverse,
		(knh_fstruct_compareTo)knh_MethodField_compareTo,
		(knh_fstruct_hashCode)knh_MethodField_hashCode,
		(knh_fstruct_newClass)knh_MethodField_newClass
	},
	{
		"Method", STRUCT_Method, FLAG_Method, sizeof(knh_Method_struct),
		(knh_fstruct_init)knh_Method_init,
		(knh_fstruct_copy)knh_Method_copy, 
		(knh_fstruct_traverse)knh_Method_traverse,
		(knh_fstruct_compareTo)knh_Method_compareTo,
		(knh_fstruct_hashCode)knh_Method_hashCode,
		(knh_fstruct_newClass)knh_Method_newClass
	},
	{
		"Mapper", STRUCT_Mapper, FLAG_Mapper, sizeof(knh_Mapper_struct),
		(knh_fstruct_init)knh_Mapper_init,
		(knh_fstruct_copy)knh_Mapper_copy, 
		(knh_fstruct_traverse)knh_Mapper_traverse,
		(knh_fstruct_compareTo)knh_Mapper_compareTo,
		(knh_fstruct_hashCode)knh_Mapper_hashCode,
		(knh_fstruct_newClass)knh_Mapper_newClass
	},
	{
		"ClassMap", STRUCT_ClassMap, FLAG_ClassMap, sizeof(knh_ClassMap_struct),
		(knh_fstruct_init)knh_ClassMap_init,
		(knh_fstruct_copy)knh_ClassMap_copy, 
		(knh_fstruct_traverse)knh_ClassMap_traverse,
		(knh_fstruct_compareTo)knh_ClassMap_compareTo,
		(knh_fstruct_hashCode)knh_ClassMap_hashCode,
		(knh_fstruct_newClass)knh_ClassMap_newClass
	},
	{
		"Closure", STRUCT_Closure, FLAG_Closure, sizeof(knh_Closure_struct),
		(knh_fstruct_init)knh_Closure_init,
		(knh_fstruct_copy)knh_Closure_copy, 
		(knh_fstruct_traverse)knh_Closure_traverse,
		(knh_fstruct_compareTo)knh_Closure_compareTo,
		(knh_fstruct_hashCode)knh_Closure_hashCode,
		(knh_fstruct_newClass)knh_Closure_newClass
	},
	{
		"AffineConv", STRUCT_AffineConv, FLAG_AffineConv, 0,
		(knh_fstruct_init)knh_AffineConv_init,
		(knh_fstruct_copy)knh_AffineConv_copy, 
		(knh_fstruct_traverse)knh_AffineConv_traverse,
		(knh_fstruct_compareTo)knh_AffineConv_compareTo,
		(knh_fstruct_hashCode)knh_AffineConv_hashCode,
		(knh_fstruct_newClass)knh_AffineConv_newClass
	},
	{
		"IntUnit", STRUCT_IntUnit, FLAG_IntUnit, sizeof(knh_IntUnit_struct),
		(knh_fstruct_init)knh_IntUnit_init,
		(knh_fstruct_copy)knh_IntUnit_copy, 
		(knh_fstruct_traverse)knh_IntUnit_traverse,
		(knh_fstruct_compareTo)knh_IntUnit_compareTo,
		(knh_fstruct_hashCode)knh_IntUnit_hashCode,
		(knh_fstruct_newClass)knh_IntUnit_newClass
	},
	{
		"FloatUnit", STRUCT_FloatUnit, FLAG_FloatUnit, sizeof(knh_FloatUnit_struct),
		(knh_fstruct_init)knh_FloatUnit_init,
		(knh_fstruct_copy)knh_FloatUnit_copy, 
		(knh_fstruct_traverse)knh_FloatUnit_traverse,
		(knh_fstruct_compareTo)knh_FloatUnit_compareTo,
		(knh_fstruct_hashCode)knh_FloatUnit_hashCode,
		(knh_fstruct_newClass)knh_FloatUnit_newClass
	},
	{
		"Regex", STRUCT_Regex, FLAG_Regex, 0,
		(knh_fstruct_init)knh_Regex_init,
		(knh_fstruct_copy)knh_Regex_copy, 
		(knh_fstruct_traverse)knh_Regex_traverse,
		(knh_fstruct_compareTo)knh_Regex_compareTo,
		(knh_fstruct_hashCode)knh_Regex_hashCode,
		(knh_fstruct_newClass)knh_Regex_newClass
	},
	{
		"BytesConv", STRUCT_BytesConv, FLAG_BytesConv, sizeof(knh_BytesConv_struct),
		(knh_fstruct_init)knh_BytesConv_init,
		(knh_fstruct_copy)knh_BytesConv_copy, 
		(knh_fstruct_traverse)knh_BytesConv_traverse,
		(knh_fstruct_compareTo)knh_BytesConv_compareTo,
		(knh_fstruct_hashCode)knh_BytesConv_hashCode,
		(knh_fstruct_newClass)knh_BytesConv_newClass
	},
	{
		"StringUnit", STRUCT_StringUnit, FLAG_StringUnit, sizeof(knh_StringUnit_struct),
		(knh_fstruct_init)knh_StringUnit_init,
		(knh_fstruct_copy)knh_StringUnit_copy, 
		(knh_fstruct_traverse)knh_StringUnit_traverse,
		(knh_fstruct_compareTo)knh_StringUnit_compareTo,
		(knh_fstruct_hashCode)knh_StringUnit_hashCode,
		(knh_fstruct_newClass)knh_StringUnit_newClass
	},
	{
		"InputStream", STRUCT_InputStream, FLAG_InputStream, sizeof(knh_InputStream_struct),
		(knh_fstruct_init)knh_InputStream_init,
		(knh_fstruct_copy)knh_InputStream_copy, 
		(knh_fstruct_traverse)knh_InputStream_traverse,
		(knh_fstruct_compareTo)knh_InputStream_compareTo,
		(knh_fstruct_hashCode)knh_InputStream_hashCode,
		(knh_fstruct_newClass)knh_InputStream_newClass
	},
	{
		"OutputStream", STRUCT_OutputStream, FLAG_OutputStream, sizeof(knh_OutputStream_struct),
		(knh_fstruct_init)knh_OutputStream_init,
		(knh_fstruct_copy)knh_OutputStream_copy, 
		(knh_fstruct_traverse)knh_OutputStream_traverse,
		(knh_fstruct_compareTo)knh_OutputStream_compareTo,
		(knh_fstruct_hashCode)knh_OutputStream_hashCode,
		(knh_fstruct_newClass)knh_OutputStream_newClass
	},
	{
		"Connection", STRUCT_Connection, FLAG_Connection, sizeof(knh_Connection_struct),
		(knh_fstruct_init)knh_Connection_init,
		(knh_fstruct_copy)knh_Connection_copy, 
		(knh_fstruct_traverse)knh_Connection_traverse,
		(knh_fstruct_compareTo)knh_Connection_compareTo,
		(knh_fstruct_hashCode)knh_Connection_hashCode,
		(knh_fstruct_newClass)knh_Connection_newClass
	},
	{
		"ResultSet", STRUCT_ResultSet, FLAG_ResultSet, sizeof(knh_ResultSet_struct),
		(knh_fstruct_init)knh_ResultSet_init,
		(knh_fstruct_copy)knh_ResultSet_copy, 
		(knh_fstruct_traverse)knh_ResultSet_traverse,
		(knh_fstruct_compareTo)knh_ResultSet_compareTo,
		(knh_fstruct_hashCode)knh_ResultSet_hashCode,
		(knh_fstruct_newClass)knh_ResultSet_newClass
	},
	{
		"Exception", STRUCT_Exception, FLAG_Exception, sizeof(knh_Exception_struct),
		(knh_fstruct_init)knh_Exception_init,
		(knh_fstruct_copy)knh_Exception_copy, 
		(knh_fstruct_traverse)knh_Exception_traverse,
		(knh_fstruct_compareTo)knh_Exception_compareTo,
		(knh_fstruct_hashCode)knh_Exception_hashCode,
		(knh_fstruct_newClass)knh_Exception_newClass
	},
	{
		"ExceptionHandler", STRUCT_ExceptionHandler, FLAG_ExceptionHandler, sizeof(knh_ExceptionHandler_struct),
		(knh_fstruct_init)knh_ExceptionHandler_init,
		(knh_fstruct_copy)knh_ExceptionHandler_copy, 
		(knh_fstruct_traverse)knh_ExceptionHandler_traverse,
		(knh_fstruct_compareTo)knh_ExceptionHandler_compareTo,
		(knh_fstruct_hashCode)knh_ExceptionHandler_hashCode,
		(knh_fstruct_newClass)knh_ExceptionHandler_newClass
	},
	{
		"Script", STRUCT_Script, FLAG_Script, 0,
		(knh_fstruct_init)knh_Script_init,
		(knh_fstruct_copy)knh_Script_copy, 
		(knh_fstruct_traverse)knh_Script_traverse,
		(knh_fstruct_compareTo)knh_Script_compareTo,
		(knh_fstruct_hashCode)knh_Script_hashCode,
		(knh_fstruct_newClass)knh_Script_newClass
	},
	{
		"NameSpace", STRUCT_NameSpace, FLAG_NameSpace, sizeof(knh_NameSpace_struct),
		(knh_fstruct_init)knh_NameSpace_init,
		(knh_fstruct_copy)knh_NameSpace_copy, 
		(knh_fstruct_traverse)knh_NameSpace_traverse,
		(knh_fstruct_compareTo)knh_NameSpace_compareTo,
		(knh_fstruct_hashCode)knh_NameSpace_hashCode,
		(knh_fstruct_newClass)knh_NameSpace_newClass
	},
	{
		"System", STRUCT_System, FLAG_System, sizeof(knh_System_struct),
		(knh_fstruct_init)knh_System_init,
		(knh_fstruct_copy)knh_System_copy, 
		(knh_fstruct_traverse)knh_System_traverse,
		(knh_fstruct_compareTo)knh_System_compareTo,
		(knh_fstruct_hashCode)knh_System_hashCode,
		(knh_fstruct_newClass)knh_System_newClass
	},
	{
		"Context", STRUCT_Context, FLAG_Context, 0,
		(knh_fstruct_init)knh_Context_init,
		(knh_fstruct_copy)knh_Context_copy, 
		(knh_fstruct_traverse)knh_Context_traverse,
		(knh_fstruct_compareTo)knh_Context_compareTo,
		(knh_fstruct_hashCode)knh_Context_hashCode,
		(knh_fstruct_newClass)knh_Context_newClass
	},
	{
		"Token", STRUCT_Token, FLAG_Token, sizeof(knh_Token_struct),
		(knh_fstruct_init)knh_Token_init,
		(knh_fstruct_copy)knh_Token_copy, 
		(knh_fstruct_traverse)knh_Token_traverse,
		(knh_fstruct_compareTo)knh_Token_compareTo,
		(knh_fstruct_hashCode)knh_Token_hashCode,
		(knh_fstruct_newClass)knh_Token_newClass
	},
	{
		"Stmt", STRUCT_Stmt, FLAG_Stmt, sizeof(knh_Stmt_struct),
		(knh_fstruct_init)knh_Stmt_init,
		(knh_fstruct_copy)knh_Stmt_copy, 
		(knh_fstruct_traverse)knh_Stmt_traverse,
		(knh_fstruct_compareTo)knh_Stmt_compareTo,
		(knh_fstruct_hashCode)knh_Stmt_hashCode,
		(knh_fstruct_newClass)knh_Stmt_newClass
	},
	{
		"Asm", STRUCT_Asm, FLAG_Asm, sizeof(knh_Asm_struct),
		(knh_fstruct_init)knh_Asm_init,
		(knh_fstruct_copy)knh_Asm_copy, 
		(knh_fstruct_traverse)knh_Asm_traverse,
		(knh_fstruct_compareTo)knh_Asm_compareTo,
		(knh_fstruct_hashCode)knh_Asm_hashCode,
		(knh_fstruct_newClass)knh_Asm_newClass
	},
	{
		"KLRCode", STRUCT_KLRCode, FLAG_KLRCode, sizeof(knh_KLRCode_struct),
		(knh_fstruct_init)knh_KLRCode_init,
		(knh_fstruct_copy)knh_KLRCode_copy, 
		(knh_fstruct_traverse)knh_KLRCode_traverse,
		(knh_fstruct_compareTo)knh_KLRCode_compareTo,
		(knh_fstruct_hashCode)knh_KLRCode_hashCode,
		(knh_fstruct_newClass)knh_KLRCode_newClass
	},
	{NULL}
};

static knh_ClassData_t ClassData[] = {
	{"konoha.Object", CLASS_Object, CFLAG_Object, STRUCT_Object, CLASS_Object, 0, 33, 0, knh_Object_fdefault},
	{"konoha.Any", CLASS_Any, CFLAG_Any, STRUCT_Any, CLASS_Object, 0, 0, 0, knh_Any_fdefault},
	{"konoha.This", CLASS_This, CFLAG_This, STRUCT_This, CLASS_Any, 0, 0, 0, knh_This_fdefault},
	{"konoha.Any0", CLASS_Any0, CFLAG_Any0, STRUCT_Any0, CLASS_Any, 0, 0, 0, knh_Any0_fdefault},
	{"konoha.Any1", CLASS_Any1, CFLAG_Any1, STRUCT_Any1, CLASS_Any, 0, 0, 0, knh_Any1_fdefault},
	{"konoha.Any2", CLASS_Any2, CFLAG_Any2, STRUCT_Any2, CLASS_Any, 0, 0, 0, knh_Any2_fdefault},
	{"konoha.Any3", CLASS_Any3, CFLAG_Any3, STRUCT_Any3, CLASS_Any, 0, 0, 0, knh_Any3_fdefault},
	{"konoha.Nue", CLASS_Nue, CFLAG_Nue, STRUCT_Nue, CLASS_Object, 0, 2, 0, knh_Nue_fdefault},
	{"konoha.Boolean", CLASS_Boolean, CFLAG_Boolean, STRUCT_Boolean, CLASS_Object, 0, 3, 0, knh_Boolean_fdefault},
	{"konoha.Number", CLASS_Number, CFLAG_Number, STRUCT_Number, CLASS_Object, 0, 0, 0, knh_Number_fdefault},
	{"konoha.Int", CLASS_Int, CFLAG_Int, STRUCT_Int, CLASS_Number, 0, 29, 0, knh_Int_fdefault},
	{"konoha.IntX", CLASS_IntX, CFLAG_IntX, STRUCT_IntX, CLASS_Number, 0, 0, 0, knh_IntX_fdefault},
	{"konoha.Float", CLASS_Float, CFLAG_Float, STRUCT_Float, CLASS_Number, 0, 20, 0, knh_Float_fdefault},
	{"konoha.FloatX", CLASS_FloatX, CFLAG_FloatX, STRUCT_FloatX, CLASS_Number, 0, 0, 0, knh_FloatX_fdefault},
	{"konoha.String", CLASS_String, CFLAG_String, STRUCT_String, CLASS_Object, 0, 23, 0, knh_String_fdefault},
	{"konoha.StringX", CLASS_StringX, CFLAG_StringX, STRUCT_StringX, CLASS_String, 0, 0, 0, knh_StringX_fdefault},
	{"konoha.Bytes", CLASS_Bytes, CFLAG_Bytes, STRUCT_Bytes, CLASS_Object, 0, 9, 0, knh_Bytes_fdefault},
	{"konoha.Tuple2", CLASS_Tuple2, CFLAG_Tuple2, STRUCT_Tuple2, CLASS_Object, 0, 0, 0, knh_Tuple2_fdefault},
	{"konoha.Range", CLASS_Range, CFLAG_Range, STRUCT_Range, CLASS_Object, 0, 0, 0, knh_Range_fdefault},
	{"konoha.Array", CLASS_Array, CFLAG_Array, STRUCT_Array, CLASS_Object, 0, 31, 0, knh_Array_fdefault},
	{"konoha.IArray", CLASS_IArray, CFLAG_IArray, STRUCT_IArray, CLASS_Object, 0, 0, 0, knh_IArray_fdefault},
	{"konoha.FArray", CLASS_FArray, CFLAG_FArray, STRUCT_FArray, CLASS_Object, 0, 0, 0, knh_FArray_fdefault},
	{"konoha.Iterator", CLASS_Iterator, CFLAG_Iterator, STRUCT_Iterator, CLASS_Object, 0, 2, 0, knh_Iterator_fdefault},
	{"konoha.DictMap", CLASS_DictMap, CFLAG_DictMap, STRUCT_DictMap, CLASS_Object, 0, 12, 0, knh_DictMap_fdefault},
	{"konoha.DictSet", CLASS_DictSet, CFLAG_DictSet, STRUCT_DictSet, CLASS_Object, 0, 13, 0, knh_DictSet_fdefault},
	{"konoha.HashMap", CLASS_HashMap, CFLAG_HashMap, STRUCT_HashMap, CLASS_Object, 0, 8, 0, knh_HashMap_fdefault},
	{"konoha.HashSet", CLASS_HashSet, CFLAG_HashSet, STRUCT_HashSet, CLASS_Object, 0, 0, 0, knh_HashSet_fdefault},
	{"konoha.LRUHashMap", CLASS_LRUHashMap, CFLAG_LRUHashMap, STRUCT_LRUHashMap, CLASS_Object, 0, 0, 0, knh_LRUHashMap_fdefault},
	{"konoha.DictIdx", CLASS_DictIdx, CFLAG_DictIdx, STRUCT_DictIdx, CLASS_Object, 0, 6, 0, knh_DictIdx_fdefault},
	{"konoha.Class", CLASS_Class, CFLAG_Class, STRUCT_Class, CLASS_Object, 0, 12, 0, knh_Class_fdefault},
	{"konoha.ClassStruct", CLASS_ClassStruct, CFLAG_ClassStruct, STRUCT_ClassStruct, CLASS_Object, 0, 0, 0, knh_ClassStruct_fdefault},
	{"konoha.MethodField", CLASS_MethodField, CFLAG_MethodField, STRUCT_MethodField, CLASS_Object, 0, 0, 0, knh_MethodField_fdefault},
	{"konoha.Method", CLASS_Method, CFLAG_Method, STRUCT_Method, CLASS_Object, 0, 15, 0, knh_Method_fdefault},
	{"konoha.Mapper", CLASS_Mapper, CFLAG_Mapper, STRUCT_Mapper, CLASS_Object, 0, 12, 0, knh_Mapper_fdefault},
	{"konoha.ClassMap", CLASS_ClassMap, CFLAG_ClassMap, STRUCT_ClassMap, CLASS_Object, 0, 1, 0, knh_ClassMap_fdefault},
	{"konoha.Closure", CLASS_Closure, CFLAG_Closure, STRUCT_Closure, CLASS_Object, 0, 3, 0, knh_Closure_fdefault},
	{"konoha.AffineConv", CLASS_AffineConv, CFLAG_AffineConv, STRUCT_AffineConv, CLASS_Object, 0, 0, 0, knh_AffineConv_fdefault},
	{"konoha.IntUnit", CLASS_IntUnit, CFLAG_IntUnit, STRUCT_IntUnit, CLASS_Object, 0, 1, 0, knh_IntUnit_fdefault},
	{"konoha.FloatUnit", CLASS_FloatUnit, CFLAG_FloatUnit, STRUCT_FloatUnit, CLASS_Object, 0, 0, 0, knh_FloatUnit_fdefault},
	{"konoha.Regex", CLASS_Regex, CFLAG_Regex, STRUCT_Regex, CLASS_Object, 0, 2, 0, knh_Regex_fdefault},
	{"konoha.BytesConv", CLASS_BytesConv, CFLAG_BytesConv, STRUCT_BytesConv, CLASS_Object, 0, 1, 0, knh_BytesConv_fdefault},
	{"konoha.StringUnit", CLASS_StringUnit, CFLAG_StringUnit, STRUCT_StringUnit, CLASS_Object, 0, 0, 0, knh_StringUnit_fdefault},
	{"konoha.InputStream", CLASS_InputStream, CFLAG_InputStream, STRUCT_InputStream, CLASS_Object, 0, 7, 0, knh_InputStream_fdefault},
	{"konoha.OutputStream", CLASS_OutputStream, CFLAG_OutputStream, STRUCT_OutputStream, CLASS_Object, 0, 15, 0, knh_OutputStream_fdefault},
	{"konoha.Connection", CLASS_Connection, CFLAG_Connection, STRUCT_Connection, CLASS_Object, 0, 4, 0, knh_Connection_fdefault},
	{"konoha.ResultSet", CLASS_ResultSet, CFLAG_ResultSet, STRUCT_ResultSet, CLASS_Object, 0, 9, 0, knh_ResultSet_fdefault},
	{"konoha.Exception", CLASS_Exception, CFLAG_Exception, STRUCT_Exception, CLASS_Object, 0, 9, 0, knh_Exception_fdefault},
	{"konoha.ExceptionHandler", CLASS_ExceptionHandler, CFLAG_ExceptionHandler, STRUCT_ExceptionHandler, CLASS_Object, 0, 0, 0, knh_ExceptionHandler_fdefault},
	{"konoha.Script", CLASS_Script, CFLAG_Script, STRUCT_Script, CLASS_Object, 0, 6, 0, knh_Script_fdefault},
	{"konoha.NameSpace", CLASS_NameSpace, CFLAG_NameSpace, STRUCT_NameSpace, CLASS_Object, 0, 0, 0, knh_NameSpace_fdefault},
	{"konoha.System", CLASS_System, CFLAG_System, STRUCT_System, CLASS_Object, 0, 15, 0, knh_System_fdefault},
	{"konoha.Context", CLASS_Context, CFLAG_Context, STRUCT_Context, CLASS_Object, 0, 16, 0, knh_Context_fdefault},
	{"konoha.Token", CLASS_Token, CFLAG_Token, STRUCT_Token, CLASS_Object, 0, 3, 0, knh_Token_fdefault},
	{"konoha.Stmt", CLASS_Stmt, CFLAG_Stmt, STRUCT_Stmt, CLASS_Object, 0, 2, 0, knh_Stmt_fdefault},
	{"konoha.Asm", CLASS_Asm, CFLAG_Asm, STRUCT_Asm, CLASS_Object, 0, 0, 0, knh_Asm_fdefault},
	{"konoha.KLRCode", CLASS_KLRCode, CFLAG_KLRCode, STRUCT_KLRCode, CLASS_Object, 0, 0, 0, knh_KLRCode_fdefault},
	{NULL}
};

static knh_GenericsData_t GenericsData[] = {
	{"String[]", ACLASS_String, CLASS_Array, CLASS_String, CLASS_Nue},
	{"String..", ICLASS_String, CLASS_Iterator, CLASS_String, CLASS_Nue},
	{"Any1..", ICLASS_Any1, CLASS_Iterator, CLASS_Any1, CLASS_Nue},
	{"This..", ICLASS_This, CLASS_Iterator, CLASS_This, CLASS_Nue},
	{NULL}
};

static knh_ExptData_t ExptData[] = {
	{"Exception", 0, EXPT_Exception, NULL},
	{"Fatal", 0, EXPT_Fatal, NULL},
	{"OutOfMemory", 0, EXPT_OutOfMemory, "Fatal"},
	{"Security", 0, EXPT_Security, NULL},
	{"Null", 0, EXPT_Null, NULL},
	{"OutOfIndex", 0, EXPT_OutOfIndex, NULL},
	{"IO", 0, EXPT_IO, NULL},
	{"Script", 0, EXPT_Script, NULL},
	{"Syntax", 0, EXPT_Syntax, "Script"},
	{"Type", 0, EXPT_Type, "Script"},
	{NULL, 0}
};

int knhiroha_load(Ctx *ctx);
int knhunix_load(Ctx *ctx);
int knhsocket_load(Ctx *ctx);
int knhnaruto_load(Ctx *ctx);
int knhcgi_load(Ctx *ctx);
int knhdemo_load(Ctx *ctx);
int knhmath_load(Ctx *ctx);
static knh_FuncData_t FuncData[] = {
#ifdef KONOHA_MONOLITHIC
	{"knhiroha_load", (void*)knhiroha_load},
	{"knhunix_load", (void*)knhunix_load},
	{"knhsocket_load", (void*)knhsocket_load},
	{"knhnaruto_load", (void*)knhnaruto_load},
	{"knhcgi_load", (void*)knhcgi_load},
	{"knhdemo_load", (void*)knhdemo_load},
	{"knhmath_load", (void*)knhmath_load},
#endif/*KONOHA_MONOLITHIC*/
	{NULL}
};

static knh_FieldNameData_t FieldNameData[] = {
	{"", FIELDN_},
	{"2D", FIELDN_2D},
	{"3D", FIELDN_3D},
	{"GLOBAL", FIELDN_GLOBAL},
	{"a", FIELDN_a},
	{"add", FIELDN_add},
	{"add:fast", FIELDN_add__fast},
	{"addHistory", FIELDN_addHistory},
	{"addr", FIELDN_addr},
	{"all", FIELDN_all},
	{"autoFlush", FIELDN_autoFlush},
	{"b", FIELDN_b},
	{"bag", FIELDN_bag},
	{"base", FIELDN_base},
	{"bits", FIELDN_bits},
	{"buf", FIELDN_buf},
	{"c", FIELDN_c},
	{"callcc", FIELDN_callcc},
	{"class", FIELDN_class},
	{"clear", FIELDN_clear},
	{"close", FIELDN_close},
	{"compareTo", FIELDN_compareTo},
	{"concat", FIELDN_concat},
	{"copy", FIELDN_copy},
	{"d", FIELDN_d},
	{"debug", FIELDN_debug},
	{"default", FIELDN_default},
	{"defined", FIELDN_defined},
	{"delegate", FIELDN_delegate},
	{"delim", FIELDN_delim},
	{"dump", FIELDN_dump},
	{"e", FIELDN_e},
	{"empty", FIELDN_empty},
	{"enc", FIELDN_enc},
	{"encoding", FIELDN_encoding},
	{"endsWith", FIELDN_endsWith},
	{"equals", FIELDN_equals},
	{"err", FIELDN_err},
	{"eval", FIELDN_eval},
	{"exec", FIELDN_exec},
	{"exit", FIELDN_exit},
	{"f", FIELDN_f},
	{"file", FIELDN_file},
	{"float", FIELDN_float},
	{"flush", FIELDN_flush},
	{"format", FIELDN_format},
	{"formatted", FIELDN_formatted},
	{"func", FIELDN_func},
	{"g", FIELDN_g},
	{"gCMarked", FIELDN_gCMarked},
	{"gc", FIELDN_gc},
	{"h", FIELDN_h},
	{"hasDir", FIELDN_hasDir},
	{"hasFile", FIELDN_hasFile},
	{"hasLibrary", FIELDN_hasLibrary},
	{"hasMetaData", FIELDN_hasMetaData},
	{"i", FIELDN_i},
	{"in", FIELDN_in},
	{"index", FIELDN_index},
	{"indexOf", FIELDN_indexOf},
	{"init", FIELDN_init},
	{"insert", FIELDN_insert},
	{"int", FIELDN_int},
	{"invoke", FIELDN_invoke},
	{"isAbstract", FIELDN_isAbstract},
	{"isAspect", FIELDN_isAspect},
	{"isAutoFlush", FIELDN_isAutoFlush},
	{"isClosed", FIELDN_isClosed},
	{"isConst", FIELDN_isConst},
	{"isDebug", FIELDN_isDebug},
	{"isDerived", FIELDN_isDerived},
	{"isFatal", FIELDN_isFatal},
	{"isFinal", FIELDN_isFinal},
	{"isFormatted", FIELDN_isFormatted},
	{"isGCMarked", FIELDN_isGCMarked},
	{"isGenerated", FIELDN_isGenerated},
	{"isIgnoreCase", FIELDN_isIgnoreCase},
	{"isImmutable", FIELDN_isImmutable},
	{"isInterface", FIELDN_isInterface},
	{"isLocal", FIELDN_isLocal},
	{"isLogging", FIELDN_isLogging},
	{"isLossLess", FIELDN_isLossLess},
	{"isMetaExtensible", FIELDN_isMetaExtensible},
	{"isModified", FIELDN_isModified},
	{"isNotNull", FIELDN_isNotNull},
	{"isNull", FIELDN_isNull},
	{"isNullBase", FIELDN_isNullBase},
	{"isPartial", FIELDN_isPartial},
	{"isPrivate", FIELDN_isPrivate},
	{"isPublic", FIELDN_isPublic},
	{"isRelease", FIELDN_isRelease},
	{"isSignificant", FIELDN_isSignificant},
	{"isStatement", FIELDN_isStatement},
	{"isStatic", FIELDN_isStatic},
	{"isStoringBuffer", FIELDN_isStoringBuffer},
	{"isSynchronized", FIELDN_isSynchronized},
	{"isSynonym", FIELDN_isSynonym},
	{"isTemporal", FIELDN_isTemporal},
	{"isTotal", FIELDN_isTotal},
	{"isUnsigned", FIELDN_isUnsigned},
	{"isVarArgs", FIELDN_isVarArgs},
	{"isVerbose", FIELDN_isVerbose},
	{"isVerbose2", FIELDN_isVerbose2},
	{"isVirtual", FIELDN_isVirtual},
	{"j", FIELDN_j},
	{"k", FIELDN_k},
	{"key", FIELDN_key},
	{"l", FIELDN_l},
	{"lambda", FIELDN_lambda},
	{"lastIndexOf", FIELDN_lastIndexOf},
	{"len", FIELDN_len},
	{"lib", FIELDN_lib},
	{"linenum", FIELDN_linenum},
	{"listProperties", FIELDN_listProperties},
	{"m", FIELDN_m},
	{"main", FIELDN_main},
	{"man", FIELDN_man},
	{"mode", FIELDN_mode},
	{"modified", FIELDN_modified},
	{"msg", FIELDN_msg},
	{"mtd", FIELDN_mtd},
	{"n", FIELDN_n},
	{"name", FIELDN_name},
	{"new", FIELDN_new},
	{"new:array", FIELDN_new__array},
	{"new:array2D", FIELDN_new__array2D},
	{"new:array3D", FIELDN_new__array3D},
	{"new:init", FIELDN_new__init},
	{"next", FIELDN_next},
	{"o", FIELDN_o},
	{"offset", FIELDN_offset},
	{"opAdd", FIELDN_opAdd},
	{"opDiv", FIELDN_opDiv},
	{"opEq", FIELDN_opEq},
	{"opFill", FIELDN_opFill},
	{"opFmt", FIELDN_opFmt},
	{"opGt", FIELDN_opGt},
	{"opGte", FIELDN_opGte},
	{"opHas", FIELDN_opHas},
	{"opInstanceof", FIELDN_opInstanceof},
	{"opIs", FIELDN_opIs},
	{"opIsa", FIELDN_opIsa},
	{"opItr", FIELDN_opItr},
	{"opLand", FIELDN_opLand},
	{"opLnot", FIELDN_opLnot},
	{"opLor", FIELDN_opLor},
	{"opLshift", FIELDN_opLshift},
	{"opLt", FIELDN_opLt},
	{"opLte", FIELDN_opLte},
	{"opMatch", FIELDN_opMatch},
	{"opMod", FIELDN_opMod},
	{"opMul", FIELDN_opMul},
	{"opNeg", FIELDN_opNeg},
	{"opNeq", FIELDN_opNeq},
	{"opNext", FIELDN_opNext},
	{"opNot", FIELDN_opNot},
	{"opOffset", FIELDN_opOffset},
	{"opPrev", FIELDN_opPrev},
	{"opRshift", FIELDN_opRshift},
	{"opSize", FIELDN_opSize},
	{"opSub", FIELDN_opSub},
	{"opSubset", FIELDN_opSubset},
	{"opSubsete", FIELDN_opSubsete},
	{"opTo", FIELDN_opTo},
	{"opXor", FIELDN_opXor},
	{"out", FIELDN_out},
	{"p", FIELDN_p},
	{"path", FIELDN_path},
	{"pop", FIELDN_pop},
	{"print", FIELDN_print},
	{"println", FIELDN_println},
	{"proceed", FIELDN_proceed},
	{"prompt", FIELDN_prompt},
	{"property", FIELDN_property},
	{"putc", FIELDN_putc},
	{"q", FIELDN_q},
	{"query", FIELDN_query},
	{"r", FIELDN_r},
	{"random", FIELDN_random},
	{"re", FIELDN_re},
	{"readLine", FIELDN_readLine},
	{"release", FIELDN_release},
	{"remove", FIELDN_remove},
	{"replace", FIELDN_replace},
	{"reverse", FIELDN_reverse},
	{"s", FIELDN_s},
	{"script", FIELDN_script},
	{"shuffle", FIELDN_shuffle},
	{"size", FIELDN_size},
	{"sort", FIELDN_sort},
	{"split", FIELDN_split},
	{"startsWith", FIELDN_startsWith},
	{"status", FIELDN_status},
	{"stdErr", FIELDN_stdErr},
	{"storingBuffer", FIELDN_storingBuffer},
	{"string", FIELDN_string},
	{"super", FIELDN_super},
	{"swap", FIELDN_swap},
	{"t", FIELDN_t},
	{"term", FIELDN_term},
	{"this", FIELDN_this},
	{"toLower", FIELDN_toLower},
	{"toUpper", FIELDN_toUpper},
	{"trim", FIELDN_trim},
	{"typeof", FIELDN_typeof},
	{"u", FIELDN_u},
	{"uRN", FIELDN_uRN},
	{"urn", FIELDN_urn},
	{"v", FIELDN_v},
	{"value", FIELDN_value},
	{"vargs", FIELDN_vargs},
	{"verbose", FIELDN_verbose},
	{"verbose2", FIELDN_verbose2},
	{"w", FIELDN_w},
	{"write", FIELDN_write},
	{"x", FIELDN_x},
	{"y", FIELDN_y},
	{"z", FIELDN_z},
	{NULL, 0}
};

/* ------------------------------------------------------------------------ */

static knh_MethodFieldData_t MethodFieldData[] = {
	{MFN_Any_Any_, 1+ 0, TYPE_Any, TYPE_Any, FIELDN_o},
	{MFN_void_OutputStream_Any, 2+ 0, TYPE_void, TYPE_OutputStream, FIELDN_w, TYPE_Any, FIELDN_o},
	{MFN_Any, 0+ 0, TYPE_Any},
	{MFN_nThis_Int, 1+ 0, NNTYPE_This, TYPE_Int, FIELDN_i},
	{MFN_nThis_Any1_, 1+ 0, NNTYPE_This, TYPE_Any1, FIELDN_v},
	{MFN_void_Any1, 1+ 0, TYPE_void, TYPE_Any1, FIELDN_v},
	{MFN_void_Any1_, 1+ 0, TYPE_void, TYPE_Any1, FIELDN_v},
	{MFN_nInt, 0+ 0, NNTYPE_Int},
	{MFN_Any1_nInt, 1+ 0, TYPE_Any1, NNTYPE_Int, FIELDN_n},
	{MFN_void_nInt_Any1, 2+ 0, TYPE_void, NNTYPE_Int, FIELDN_n, TYPE_Any1, FIELDN_v},
	{MFN_nThis_Int_Int, 2+ 0, NNTYPE_This, TYPE_Int, FIELDN_s, TYPE_Int, FIELDN_e},
	{MFN_void_nInt, 1+ 0, TYPE_void, NNTYPE_Int, FIELDN_n},
	{MFN_Any1, 0+ 0, TYPE_Any1},
	{MFN_void, 0+ 0, TYPE_void},
	{MFN_nInt_Any1, 1+ 0, NNTYPE_Int, TYPE_Any1, FIELDN_v},
	{MFN_nBoolean_Any1, 1+ 0, NNTYPE_Boolean, TYPE_Any1, FIELDN_v},
	{MFN_void_nInt_nInt, 2+ 0, TYPE_void, NNTYPE_Int, FIELDN_m, NNTYPE_Int, FIELDN_n},
	{MFN_iAny1, 0+ 0, NNITYPE_Any1},
	{MFN_nThis_nInt_nInt, 2+ 0, NNTYPE_This, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y},
	{MFN_nThis_nInt_nInt_nInt, 3+ 0, NNTYPE_This, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y, NNTYPE_Int, FIELDN_z},
	{MFN_Any1_nInt_nInt, 2+ 0, TYPE_Any1, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y},
	{MFN_Any1_nInt_nInt_nInt, 3+ 0, TYPE_Any1, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y, NNTYPE_Int, FIELDN_z},
	{MFN_void_nInt_nInt_Any1, 3+ 0, TYPE_void, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y, TYPE_Any1, FIELDN_v},
	{MFN_void_nInt_nInt_nInt_Any1, 4+ 0, TYPE_void, NNTYPE_Int, FIELDN_x, NNTYPE_Int, FIELDN_y, NNTYPE_Int, FIELDN_z, TYPE_Any1, FIELDN_v},
	{MFN_nBytes_Int, 1+ 0, NNTYPE_Bytes, TYPE_Int, FIELDN_i},
	{MFN_void_nBytes_Int_Int, 3+ 0, TYPE_void, NNTYPE_Bytes, FIELDN_b, TYPE_Int, FIELDN_n, TYPE_Int, FIELDN_l},
	{MFN_void_nInt_, 1+ 0, TYPE_void, NNTYPE_Int, FIELDN_v},
	{MFN_nInt_nInt, 1+ 0, NNTYPE_Int, NNTYPE_Int, FIELDN_n},
	{MFN_Any1_nString, 1+ 0, TYPE_Any1, NNTYPE_String, FIELDN_k},
	{MFN_nBoolean_nString, 1+ 0, NNTYPE_Boolean, NNTYPE_String, FIELDN_k},
	{MFN_void_nString_Any1, 2+ 0, TYPE_void, NNTYPE_String, FIELDN_k, TYPE_Any1, FIELDN_v},
	{MFN_void_nString, 1+ 0, TYPE_void, NNTYPE_String, FIELDN_k},
	{MFN_void_Any_, 1+ 0, TYPE_void, TYPE_Any, FIELDN_v},
	{MFN_iString, 0+ 0, NNITYPE_String},
	{MFN_nInt_nString, 1+ 0, NNTYPE_Int, NNTYPE_String, FIELDN_k},
	{MFN_void_nString_nInt, 2+ 0, TYPE_void, NNTYPE_String, FIELDN_k, NNTYPE_Int, FIELDN_v},
	{MFN_void_String_, 1+ 0, TYPE_void, TYPE_String, FIELDN_v},
	{MFN_nException_String_Any, 2+ 0, NNTYPE_Exception, TYPE_String, FIELDN_m, TYPE_Any, FIELDN_b},
	{MFN_void_nAny1, 1+ 0, TYPE_void, NNTYPE_Any1, FIELDN_k},
	{MFN_nBoolean_nAny1, 1+ 0, NNTYPE_Boolean, NNTYPE_Any1, FIELDN_k},
	{MFN_void_nAny1_Any2, 2+ 0, TYPE_void, NNTYPE_Any1, FIELDN_k, TYPE_Any2, FIELDN_v},
	{MFN_nConnection_nString, 1+ 0, NNTYPE_Connection, NNTYPE_String, FIELDN_u},
	{MFN_nResultSet_nString, 1+ 0, NNTYPE_ResultSet, NNTYPE_String, FIELDN_q},
	{MFN_nInt_nAny, 1+ 0, NNTYPE_Int, NNTYPE_Any, FIELDN_n},
	{MFN_nString_nInt, 1+ 0, NNTYPE_String, NNTYPE_Int, FIELDN_n},
	{MFN_Int_nAny, 1+ 0, TYPE_Int, NNTYPE_Any, FIELDN_n},
	{MFN_Float_nAny, 1+ 0, TYPE_Float, NNTYPE_Any, FIELDN_n},
	{MFN_String_nAny, 1+ 0, TYPE_String, NNTYPE_Any, FIELDN_n},
	{MFN_Any_nAny, 1+ 0, TYPE_Any, NNTYPE_Any, FIELDN_n},
	{MFN_nBoolean, 0+ 0, NNTYPE_Boolean},
	{MFN_nBoolean_nInt, 1+ 0, NNTYPE_Boolean, NNTYPE_Int, FIELDN_v},
	{MFN_nInt_nInt_, 1+ 0, NNTYPE_Int, NNTYPE_Int, FIELDN_v},
	{MFN_nInt_Int, 1+ 0, NNTYPE_Int, TYPE_Int, FIELDN_n},
	{MFN_nFloat_nFloat, 1+ 0, NNTYPE_Float, NNTYPE_Float, FIELDN_v},
	{MFN_nFloat, 0+ 0, NNTYPE_Float},
	{MFN_nBoolean_Float, 1+ 0, NNTYPE_Boolean, TYPE_Float, FIELDN_v},
	{MFN_nBoolean_nFloat, 1+ 0, NNTYPE_Boolean, NNTYPE_Float, FIELDN_v},
	{MFN_nThis_Any_, 1+ 0, NNTYPE_This, TYPE_Any, FIELDN_v},
	{MFN_nInt_Any, 1+ 0, NNTYPE_Int, TYPE_Any, FIELDN_o},
	{MFN_nBoolean_Any, 1+ 0, NNTYPE_Boolean, TYPE_Any, FIELDN_v},
	{MFN_nBoolean_nClass, 1+ 0, NNTYPE_Boolean, NNTYPE_Class, FIELDN_c},
	{MFN_nClass, 0+ 0, NNTYPE_Class},
	{MFN_iThis, 0+ 0, NNITYPE_This},
	{MFN_InputStream_nString, 1+ 0, TYPE_InputStream, NNTYPE_String, FIELDN_u},
	{MFN_void_String, 1+ 0, TYPE_void, TYPE_String, FIELDN_e},
	{MFN_OutputStream_nString_String, 2+ 0, TYPE_OutputStream, NNTYPE_String, FIELDN_u, TYPE_String, FIELDN_m},
	{MFN_void_Any, 1+ 0, TYPE_void, TYPE_Any, FIELDN_v},
	{MFN_nString_Any, 1+ 0, NNTYPE_String, TYPE_Any, FIELDN_v},
	{MFN_nString_Any_, 1+ 0, NNTYPE_String, TYPE_Any, FIELDN_v},
	{MFN_nString_nString, 1+ 0, NNTYPE_String, NNTYPE_String, FIELDN_t},
	{MFN_nString_nString_nString, 2+ 0, NNTYPE_String, NNTYPE_String, FIELDN_o, NNTYPE_String, FIELDN_n},
	{MFN_nString_String, 1+ 0, NNTYPE_String, TYPE_String, FIELDN_v},
	{MFN_nString_Int_Int, 2+ 0, NNTYPE_String, TYPE_Int, FIELDN_o, TYPE_Int, FIELDN_l},
	{MFN_nString, 0+ 0, NNTYPE_String},
	{MFN_aString_Any, 1+ 0, ATYPE_String, TYPE_Any, FIELDN_d},
	{MFN_nInputStream, 0+ 0, NNTYPE_InputStream},
	{MFN_void_InputStream, 1+ 0, TYPE_void, TYPE_InputStream, FIELDN_i},
	{MFN_nOutputStream, 0+ 0, NNTYPE_OutputStream},
	{MFN_void_OutputStream, 1+ 0, TYPE_void, TYPE_OutputStream, FIELDN_o},
	{MFN_void_Int, 1+ 0, TYPE_void, TYPE_Int, FIELDN_s},
	{MFN_Any_nString, 1+ 0, TYPE_Any, NNTYPE_String, FIELDN_k},
	{MFN_void_nString_Any, 2+ 0, TYPE_void, NNTYPE_String, FIELDN_k, TYPE_Any, FIELDN_v},
	{MFN_naString_String, 1+ 0, NNATYPE_String, TYPE_String, FIELDN_k},
	{MFN_nThis_nAny_nMethod, 2+ 0, NNTYPE_This, NNTYPE_Any, FIELDN_b, NNTYPE_Method, FIELDN_m},
	{MFN_Any0_Any1_Any2_Any3, 3+ 0, TYPE_Any0, TYPE_Any1, FIELDN_x, TYPE_Any2, FIELDN_y, TYPE_Any3, FIELDN_z},
	{MFN_nException_String_String_Object, 3+ 0, NNTYPE_Exception, TYPE_String, FIELDN_e, TYPE_String, FIELDN_m, TYPE_Object, FIELDN_b},
	{MFN_String, 0+ 0, TYPE_String},
	{MFN_nThis, 0+ 0, NNTYPE_This},
	{MFN_nBoolean_nRegex, 1+ 0, NNTYPE_Boolean, NNTYPE_Regex, FIELDN_r},
	{MFN_nBoolean_nString_String, 2+ 0, NNTYPE_Boolean, NNTYPE_String, FIELDN_l, TYPE_String, FIELDN_f},
	{MFN_void_String_String_Int, 3+ 0, TYPE_void, TYPE_String, FIELDN_s, TYPE_String, FIELDN_f, TYPE_Int, FIELDN_l},
	{MFN_String_String, 1+ 0, TYPE_String, TYPE_String, FIELDN_p},
	{MFN_Boolean_nClass, 1+ 0, TYPE_Boolean, NNTYPE_Class, FIELDN_c},
	{MFN_void_Boolean, 1+ 0, TYPE_void, TYPE_Boolean, FIELDN_b},
	{-1, 0}
};

static knh_MethodData_t MethodData[] = {
	{knh__Array_new, 0, CLASS_Array, METHODN_new, 0, MFN_nThis_Int, (void*)NULL},
	{knh__Array_new__array, 0, CLASS_Array, METHODN_new__array, 0, MFN_nThis_Int, (void*)NULL},
	{knh__Array_new__init, KNH_FLAG_MF_VARARGS, CLASS_Array, METHODN_new__init, 0, MFN_nThis_Any1_, (void*)NULL},
	{knh__Array_add, 0, CLASS_Array, METHODN_add, 0, MFN_void_Any1, (void*)NULL},
	{knh__Array_opLshift, KNH_FLAG_MF_VARARGS, CLASS_Array, METHODN_opLshift, 0, MFN_void_Any1_, (void*)NULL},
	{knh__Array_opSize, 0, CLASS_Array, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__Array_get, 0, CLASS_Array, METHODN_get, 0, MFN_Any1_nInt, (void*)NULL},
	{knh__Array_set, 0, CLASS_Array, METHODN_set, 0, MFN_void_nInt_Any1, (void*)NULL},
	{knh__Array_setAll, 0, CLASS_Array, METHODN_setAll, 0, MFN_void_Any1, (void*)NULL},
	{knh__Array_opSubset, 0, CLASS_Array, METHODN_opSubset, 0, MFN_nThis_Int_Int, (void*)NULL},
	{knh__Array_opSubsete, 0, CLASS_Array, METHODN_opSubsete, 0, MFN_nThis_Int_Int, (void*)NULL},
	{knh__Array_opOffset, 0, CLASS_Array, METHODN_opOffset, 0, MFN_nThis_Int_Int, (void*)NULL},
	{knh__Array_insert, 0, CLASS_Array, METHODN_insert, 0, MFN_void_nInt_Any1, (void*)NULL},
	{knh__Array_remove, 0, CLASS_Array, METHODN_remove, 0, MFN_void_nInt, (void*)NULL},
	{knh__Array_pop, 0, CLASS_Array, METHODN_pop, 0, MFN_Any1, (void*)NULL},
	{knh__Array_clear, 0, CLASS_Array, METHODN_clear, 0, MFN_void, (void*)NULL},
	{knh__Array_indexOf, 0, CLASS_Array, METHODN_indexOf, 0, MFN_nInt_Any1, (void*)NULL},
	{knh__Array_lastIndexOf, 0, CLASS_Array, METHODN_lastIndexOf, 0, MFN_nInt_Any1, (void*)NULL},
	{knh__Array_opHas, 0, CLASS_Array, METHODN_opHas, 0, MFN_nBoolean_Any1, (void*)NULL},
	{knh__Array_sort, 0, CLASS_Array, METHODN_sort, 0, MFN_void, (void*)NULL},
	{knh__Array_reverse, 0, CLASS_Array, METHODN_reverse, 0, MFN_void, (void*)NULL},
	{knh__Array_swap, 0, CLASS_Array, METHODN_swap, 0, MFN_void_nInt_nInt, (void*)NULL},
	{knh__Array_shuffle, 0, CLASS_Array, METHODN_shuffle, 0, MFN_void, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Array, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Array__k},
	{knh__Array_opItr, 0, CLASS_Array, METHODN_opItr, 0, MFN_iAny1, (void*)NULL},
	{knh__Array_new__array2D, 0, CLASS_Array, METHODN_new__array2D, 0, MFN_nThis_nInt_nInt, (void*)NULL},
	{knh__Array_new__array3D, 0, CLASS_Array, METHODN_new__array3D, 0, MFN_nThis_nInt_nInt_nInt, (void*)NULL},
	{knh__Array_get2D, 0, CLASS_Array, METHODN_get2D, 0, MFN_Any1_nInt_nInt, (void*)NULL},
	{knh__Array_get3D, 0, CLASS_Array, METHODN_get3D, 0, MFN_Any1_nInt_nInt_nInt, (void*)NULL},
	{knh__Array_set2D, 0, CLASS_Array, METHODN_set2D, 0, MFN_void_nInt_nInt_Any1, (void*)NULL},
	{knh__Array_set3D, 0, CLASS_Array, METHODN_set3D, 0, MFN_void_nInt_nInt_nInt_Any1, (void*)NULL},
	{knh__Bytes_new, 0, CLASS_Bytes, METHODN_new, 0, MFN_nBytes_Int, (void*)NULL},
	{knh__Bytes_putc, 0, CLASS_Bytes, METHODN_putc, 0, MFN_void_nInt, (void*)NULL},
	{knh__Bytes_write, 0, CLASS_Bytes, METHODN_write, 0, MFN_void_nBytes_Int_Int, (void*)NULL},
	{knh__Bytes_opLshift, KNH_FLAG_MF_VARARGS, CLASS_Bytes, METHODN_opLshift, 0, MFN_void_nInt_, (void*)NULL},
	{knh__Bytes_opSize, 0, CLASS_Bytes, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__Bytes_get, 0, CLASS_Bytes, METHODN_get, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Bytes_set, 0, CLASS_Bytes, METHODN_set, 0, MFN_void_nInt_nInt, (void*)NULL},
	{knh__Bytes_opFill, 0, CLASS_Bytes, METHODN_opFill, 0, MFN_void_nInt, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Bytes, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Bytes__dump},
	{knh__DictMap_new, 0, CLASS_DictMap, METHODN_new, 0, MFN_nThis_Int, (void*)NULL},
	{knh__DictMap_new__init, KNH_FLAG_MF_VARARGS, CLASS_DictMap, METHODN_new__init, 0, MFN_nThis_Any1_, (void*)NULL},
	{knh__DictMap_get, 0, CLASS_DictMap, METHODN_get, 0, MFN_Any1_nString, (void*)NULL},
	{knh__DictMap_opHas, 0, CLASS_DictMap, METHODN_opHas, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__DictMap_set, 0, CLASS_DictMap, METHODN_set, 0, MFN_void_nString_Any1, (void*)NULL},
	{knh__DictMap_remove, 0, CLASS_DictMap, METHODN_remove, 0, MFN_void_nString, (void*)NULL},
	{knh__DictMap_clear, 0, CLASS_DictMap, METHODN_clear, 0, MFN_void, (void*)NULL},
	{knh__DictMap_opSize, 0, CLASS_DictMap, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__DictMap_opLshift, KNH_FLAG_MF_VARARGS, CLASS_DictMap, METHODN_opLshift, 0, MFN_void_Any_, (void*)NULL},
	{knh__DictMap_opItr, 0, CLASS_DictMap, METHODN_opItr, 0, MFN_iString, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_DictMap, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_DictMap__k},
	{knh__DictSet_new, 0, CLASS_DictSet, METHODN_new, 0, MFN_nThis_Int, (void*)NULL},
	{knh__DictSet_add, 0, CLASS_DictSet, METHODN_add, 0, MFN_void_nString, (void*)NULL},
	{knh__DictSet_get, 0, CLASS_DictSet, METHODN_get, 0, MFN_nInt_nString, (void*)NULL},
	{knh__DictSet_opHas, 0, CLASS_DictSet, METHODN_opHas, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__DictSet_set, 0, CLASS_DictSet, METHODN_set, 0, MFN_void_nString_nInt, (void*)NULL},
	{knh__DictSet_remove, 0, CLASS_DictSet, METHODN_remove, 0, MFN_void_nString, (void*)NULL},
	{knh__DictSet_clear, 0, CLASS_DictSet, METHODN_clear, 0, MFN_void, (void*)NULL},
	{knh__DictSet_opSize, 0, CLASS_DictSet, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__DictSet_opLshift, KNH_FLAG_MF_VARARGS, CLASS_DictSet, METHODN_opLshift, 0, MFN_void_String_, (void*)NULL},
	{knh__DictSet_opItr, 0, CLASS_DictSet, METHODN_opItr, 0, MFN_iString, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_DictSet, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_DictSet__k},
	{knh_fmethod_movableText, 0, CLASS_DictSet, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_DictSet__dump},
	{knh__Exception_new, 0, CLASS_Exception, METHODN_new, 0, MFN_nException_String_Any, (void*)NULL},
	{knh__Exception_opIsa, 0, CLASS_Exception, METHODN_opIsa, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Exception, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Exception__s},
	{knh_fmethod_movableText, 0, CLASS_Exception, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Exception__k},
	{knh_fmethod_movableText, 0, CLASS_Exception, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Exception__dump},
	{knh__HashMap_new, 0, CLASS_HashMap, METHODN_new, 0, MFN_nThis_Int, (void*)NULL},
	{knh__HashMap_get, 0, CLASS_HashMap, METHODN_get, 0, MFN_void_nAny1, (void*)NULL},
	{knh__HashMap_opHas, 0, CLASS_HashMap, METHODN_opHas, 0, MFN_nBoolean_nAny1, (void*)NULL},
	{knh__HashMap_remove, 0, CLASS_HashMap, METHODN_remove, 0, MFN_void_nAny1, (void*)NULL},
	{knh__HashMap_set, 0, CLASS_HashMap, METHODN_set, 0, MFN_void_nAny1_Any2, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_HashMap, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_HashMap__k},
	{knh_fmethod_movableText, 0, CLASS_HashMap, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_HashMap__dump},
	{knh__HashMap_opItr, 0, CLASS_HashMap, METHODN_opItr, 0, MFN_iAny1, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Iterator, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Iterator__k},
	{knh_fmethod_movableText, 0, CLASS_Iterator, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Iterator__dump},
	{knh__Connection_new, 0, CLASS_Connection, METHODN_new, 0, MFN_nConnection_nString, (void*)NULL},
	{knh__Connection_query, 0, CLASS_Connection, METHODN_query, 0, MFN_nResultSet_nString, (void*)NULL},
	{knh__Connection_exec, 0, CLASS_Connection, METHODN_exec, 0, MFN_void_nString, (void*)NULL},
	{knh__ResultSet_opSize, 0, CLASS_ResultSet, METHODN_opSize, 0, MFN_nInt_nAny, (void*)NULL},
	{knh__ResultSet_getName, 0, CLASS_ResultSet, METHODN_getName, 0, MFN_nString_nInt, (void*)NULL},
	{knh__ResultSet_getInt, 0, CLASS_ResultSet, METHODN_getInt, 0, MFN_Int_nAny, (void*)NULL},
	{knh__ResultSet_getFloat, 0, CLASS_ResultSet, METHODN_getFloat, 0, MFN_Float_nAny, (void*)NULL},
	{knh__ResultSet_getString, 0, CLASS_ResultSet, METHODN_getString, 0, MFN_String_nAny, (void*)NULL},
	{knh__ResultSet_get, 0, CLASS_ResultSet, METHODN_get, 0, MFN_Any_nAny, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_ResultSet, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_ResultSet__dump},
	{knh__Boolean_opNot, KNH_FLAG_MF_CONST, CLASS_Boolean, METHODN_opNot, 0, MFN_nBoolean, (void*)NULL},
	{knh__Int_opAdd, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opAdd, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opNeg, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opNeg, 0, MFN_nInt, (void*)NULL},
	{knh__Int_opSub, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opSub, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opMul, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opMul, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opDiv, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opDiv, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opMod, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opMod, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opEq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Int, METHODN_opEq, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opNeq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Int, METHODN_opNeq, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opLt, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLt, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opLte, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLte, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opGt, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opGt, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opGte, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opGte, 0, MFN_nBoolean_nInt, (void*)NULL},
	{knh__Int_opLand, KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLand, 0, MFN_nInt_nInt_, (void*)NULL},
	{knh__Int_opLor, KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLor, 0, MFN_nInt_nInt_, (void*)NULL},
	{knh__Int_opXor, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opXor, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opLnot, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLnot, 0, MFN_nInt, (void*)NULL},
	{knh__Int_opLshift, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opLshift, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opRshift, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opRshift, 0, MFN_nInt_nInt, (void*)NULL},
	{knh__Int_opNext, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opNext, 0, MFN_nInt, (void*)NULL},
	{knh__Int_opPrev, KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opPrev, 0, MFN_nInt, (void*)NULL},
	{knh__Int_opSize, KNH_FLAG_MF_NULLBASE|KNH_FLAG_MF_CONST, CLASS_Int, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__Int_random, KNH_FLAG_MF_STATIC, CLASS_Int, METHODN_random, 0, MFN_nInt_Int, (void*)NULL},
	{knh__Float_opAdd, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opAdd, 0, MFN_nFloat_nFloat, (void*)NULL},
	{knh__Float_opNeg, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opNeg, 0, MFN_nFloat, (void*)NULL},
	{knh__Float_opSub, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opSub, 0, MFN_nFloat_nFloat, (void*)NULL},
	{knh__Float_opMul, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opMul, 0, MFN_nFloat_nFloat, (void*)NULL},
	{knh__Float_opDiv, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opDiv, 0, MFN_nFloat_nFloat, (void*)NULL},
	{knh__Float_opEq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Float, METHODN_opEq, 0, MFN_nBoolean_Float, (void*)NULL},
	{knh__Float_opNeq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Float, METHODN_opNeq, 0, MFN_nBoolean_Float, (void*)NULL},
	{knh__Float_opLt, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opLt, 0, MFN_nBoolean_nFloat, (void*)NULL},
	{knh__Float_opLte, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opLte, 0, MFN_nBoolean_nFloat, (void*)NULL},
	{knh__Float_opGt, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opGt, 0, MFN_nBoolean_nFloat, (void*)NULL},
	{knh__Float_opGte, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opGte, 0, MFN_nBoolean_nFloat, (void*)NULL},
	{knh__Float_opNext, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opNext, 0, MFN_nFloat, (void*)NULL},
	{knh__Float_opPrev, KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opPrev, 0, MFN_nFloat, (void*)NULL},
	{knh__Float_random, KNH_FLAG_MF_STATIC, CLASS_Float, METHODN_random, 0, MFN_nFloat, (void*)NULL},
	{knh__Float_opSize, KNH_FLAG_MF_NULLBASE|KNH_FLAG_MF_CONST, CLASS_Float, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__Boolean__s, 0, CLASS_Boolean, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Boolean__k, 0, CLASS_Boolean, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__s, 0, CLASS_Int, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__k, 0, CLASS_Int, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__d, 0, CLASS_Int, METHODN__d, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__u, 0, CLASS_Int, METHODN__u, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__f, 0, CLASS_Int, METHODN__f, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__x, 0, CLASS_Int, METHODN__x, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Int__bits, 0, CLASS_Int, METHODN__bits, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Float__s, 0, CLASS_Float, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Float__d, 0, CLASS_Float, METHODN__d, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Float__f, 0, CLASS_Float, METHODN__f, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Float__bits, 0, CLASS_Float, METHODN__bits, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Float__k, 0, CLASS_Float, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)NULL},
	{knh__Object_new__init, KNH_FLAG_MF_VARARGS, CLASS_Object, METHODN_new__init, 0, MFN_nThis_Any_, (void*)NULL},
	{knh__Object_compareTo, 0, CLASS_Object, METHODN_compareTo, 0, MFN_nInt_Any, (void*)NULL},
	{knh__Object_opEq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opEq, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opNeq, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opNeq, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opLt, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opLt, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opLte, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opLte, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opGt, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opGt, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opGte, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_opGte, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opIs, KNH_FLAG_MF_CONST, CLASS_Object, METHODN_opIs, 0, MFN_nBoolean_Any, (void*)NULL},
	{knh__Object_opIsa, KNH_FLAG_MF_CONST, CLASS_Object, METHODN_opIsa, 0, MFN_nBoolean_nClass, (void*)NULL},
	{knh__Object_opTo, KNH_FLAG_MF_CONST, CLASS_Object, METHODN_opTo, 0, MFN_nBoolean_nClass, (void*)NULL},
	{knh__Object_getClass, KNH_FLAG_MF_CONST, CLASS_Object, METHODN_getClass, 0, MFN_nClass, (void*)NULL},
	{knh__Object_isNull, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_isNull, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_isNotNull, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_Object, METHODN_isNotNull, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_opItr, 0, CLASS_Object, METHODN_opItr, 0, MFN_iThis, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Object, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Object__s},
	{knh_fmethod_movableText, 0, CLASS_Object, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Object__k},
	{knh_fmethod_movableText, 0, CLASS_Object, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Object__dump},
	{knh_fmethod_movableText, 0, CLASS_Object, METHODN__empty, 0, MFN_void_OutputStream_Any, (void*)knh_Object__empty},
	{knh_fmethod_movableText, 0, CLASS_Object, METHODN__addr, 0, MFN_void_OutputStream_Any, (void*)knh_Object__addr},
	{knh_fmethod_movableText, 0, CLASS_Nue, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Nue__s},
	{knh_fmethod_movableText, 0, CLASS_Nue, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Nue__k},
	{knh_fmethod_movableText, 0, CLASS_Class, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Class__s},
	{knh_fmethod_movableText, 0, CLASS_Class, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Class__k},
	{knh_fmethod_movableText, 0, CLASS_Class, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Class__dump},
	{knh_fmethod_movableText, 0, CLASS_Class, METHODN__man, 0, MFN_void_OutputStream_Any, (void*)knh_Class__man},
	{knh_fmethod_movableText, 0, CLASS_Method, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Method__s},
	{knh_fmethod_movableText, 0, CLASS_Method, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Method__k},
	{knh_fmethod_movableText, 0, CLASS_Method, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Method__dump},
	{knh__InputStream_new, 0, CLASS_InputStream, METHODN_new, 0, MFN_InputStream_nString, (void*)NULL},
	{knh__InputStream_setEncoding, 0, CLASS_InputStream, METHODN_setEncoding, 0, MFN_void_String, (void*)NULL},
	{knh__InputStream_isClosed, 0, CLASS_InputStream, METHODN_isClosed, 0, MFN_nBoolean, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_InputStream, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_InputStream__dump},
	{knh_fmethod_movableText, 0, CLASS_InputStream, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_InputStream__k},
	{knh__OutputStream_new, 0, CLASS_OutputStream, METHODN_new, 0, MFN_OutputStream_nString_String, (void*)NULL},
	{knh__OutputStream_write, 0, CLASS_OutputStream, METHODN_write, 0, MFN_void_nBytes_Int_Int, (void*)NULL},
	{knh__OutputStream_isClosed, 0, CLASS_OutputStream, METHODN_isClosed, 0, MFN_nBoolean, (void*)NULL},
	{knh__OutputStream_setEncoding, 0, CLASS_OutputStream, METHODN_setEncoding, 0, MFN_void_String, (void*)NULL},
	{knh__OutputStream_print, 0, CLASS_OutputStream, METHODN_print, 0, MFN_void_Any, (void*)NULL},
	{knh__OutputStream_println, 0, CLASS_OutputStream, METHODN_println, 0, MFN_void_Any, (void*)NULL},
	{knh__OutputStream_opLshift, KNH_FLAG_MF_VARARGS, CLASS_OutputStream, METHODN_opLshift, 0, MFN_void_Any_, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_OutputStream, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_OutputStream__k},
	{knh__String_equals, 0, CLASS_String, METHODN_equals, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__String_startsWith, 0, CLASS_String, METHODN_startsWith, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__String_endsWith, 0, CLASS_String, METHODN_endsWith, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__String_indexOf, KNH_FLAG_MF_CONST, CLASS_String, METHODN_indexOf, 0, MFN_nInt_nString, (void*)NULL},
	{knh__String_opSize, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_String, METHODN_opSize, 0, MFN_nInt, (void*)NULL},
	{knh__String_opAdd, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_String, METHODN_opAdd, 0, MFN_nString_Any, (void*)NULL},
	{knh__String_concat, KNH_FLAG_MF_VARARGS|KNH_FLAG_MF_STATIC|KNH_FLAG_MF_NULLBASE, CLASS_String, METHODN_concat, 0, MFN_nString_Any_, (void*)NULL},
	{knh__String_opSub, KNH_FLAG_MF_CONST, CLASS_String, METHODN_opSub, 0, MFN_nString_nString, (void*)NULL},
	{knh__String_replace, KNH_FLAG_MF_CONST, CLASS_String, METHODN_replace, 0, MFN_nString_nString_nString, (void*)NULL},
	{knh__String_opMul, KNH_FLAG_MF_CONST, CLASS_String, METHODN_opMul, 0, MFN_nString_nInt, (void*)NULL},
	{knh__String_opFmt, KNH_FLAG_MF_VARARGS, CLASS_String, METHODN_opFmt, 0, MFN_nString_Any_, (void*)NULL},
	{knh__String_opDiv, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_String, METHODN_opDiv, 0, MFN_nString_String, (void*)NULL},
	{knh__String_opMod, KNH_FLAG_MF_CONST|KNH_FLAG_MF_NULLBASE, CLASS_String, METHODN_opMod, 0, MFN_nString_String, (void*)NULL},
	{knh__String_opHas, KNH_FLAG_MF_CONST, CLASS_String, METHODN_opHas, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__String_get, KNH_FLAG_MF_CONST, CLASS_String, METHODN_get, 0, MFN_nString_nInt, (void*)NULL},
	{knh__String_opOffset, KNH_FLAG_MF_CONST, CLASS_String, METHODN_opOffset, 0, MFN_nString_Int_Int, (void*)NULL},
	{knh__String_toLower, KNH_FLAG_MF_CONST, CLASS_String, METHODN_toLower, 0, MFN_nString, (void*)NULL},
	{knh__String_toUpper, KNH_FLAG_MF_CONST, CLASS_String, METHODN_toUpper, 0, MFN_nString, (void*)NULL},
	{knh__String_trim, KNH_FLAG_MF_CONST, CLASS_String, METHODN_trim, 0, MFN_nString, (void*)NULL},
	{knh__String_split, KNH_FLAG_MF_CONST, CLASS_String, METHODN_split, 0, MFN_aString_Any, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_String, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_String__s},
	{knh_fmethod_movableText, 0, CLASS_String, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_String__k},
	{knh__System_getIn, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_getIn, 0, MFN_nInputStream, (void*)NULL},
	{knh__System_setIn, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_setIn, 0, MFN_void_InputStream, (void*)NULL},
	{knh__System_getOut, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_getOut, 0, MFN_nOutputStream, (void*)NULL},
	{knh__System_setOut, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_setOut, 0, MFN_void_OutputStream, (void*)NULL},
	{knh__System_getErr, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_getErr, 0, MFN_nOutputStream, (void*)NULL},
	{knh__System_setErr, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_setStdErr, 0, MFN_void_OutputStream, (void*)NULL},
	{knh__System_exit, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_exit, 0, MFN_void_Int, (void*)NULL},
	{knh__System_hasDir, 0, CLASS_System, METHODN_hasDir, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__System_hasFile, 0, CLASS_System, METHODN_hasFile, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_System, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_System__k},
	{knh_fmethod_movableText, 0, CLASS_System, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_System__dump},
	{knh__Context_getProperty, 0, CLASS_Context, METHODN_getProperty, 0, MFN_Any_nString, (void*)NULL},
	{knh__Context_setProperty, 0, CLASS_Context, METHODN_setProperty, 0, MFN_void_nString_Any, (void*)NULL},
	{knh__Context_listProperties, 0, CLASS_Context, METHODN_listProperties, 0, MFN_naString_String, (void*)NULL},
	{knh__Context_setEncoding, 0, CLASS_Context, METHODN_setEncoding, 0, MFN_void_String, (void*)NULL},
	{knh__Context_setIn, 0, CLASS_Context, METHODN_setIn, 0, MFN_void_InputStream, (void*)NULL},
	{knh__Context_setOut, 0, CLASS_Context, METHODN_setOut, 0, MFN_void_OutputStream, (void*)NULL},
	{knh__Context_setErr, 0, CLASS_Context, METHODN_setErr, 0, MFN_void_OutputStream, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Context, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Context__dump},
	{knh_fmethod_movableText, 0, CLASS_BytesConv, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_BytesConv__k},
	{knh_fmethod_movableText, 0, CLASS_ClassMap, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_ClassMap__dump},
	{knh__Closure_new, 0, CLASS_Closure, METHODN_new, 0, MFN_nThis_nAny_nMethod, (void*)NULL},
	{knh__Closure_invoke, 0, CLASS_Closure, METHODN_invoke, 0, MFN_Any0_Any1_Any2_Any3, (void*)NULL},
	{knh__Closure_callcc, 0, CLASS_Closure, METHODN_callcc, 0, MFN_Any0_Any1_Any2_Any3, (void*)NULL},
	{knh__Connection_close, 0, CLASS_Connection, METHODN_close, 0, MFN_void, (void*)NULL},
	{knh__DictIdx_size, 0, CLASS_DictIdx, METHODN_size, 0, MFN_nInt, (void*)NULL},
	{knh__DictIdx_index, 0, CLASS_DictIdx, METHODN_index, 0, MFN_nInt_nString, (void*)NULL},
	{knh__DictIdx_add__fast, 0, CLASS_DictIdx, METHODN_add__fast, 0, MFN_nInt_nString, (void*)NULL},
	{knh__DictIdx_add, 0, CLASS_DictIdx, METHODN_add, 0, MFN_nInt_nString, (void*)NULL},
	{knh__DictIdx_clear, 0, CLASS_DictIdx, METHODN_clear, 0, MFN_void, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_DictIdx, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_DictIdx__k},
	{knh__Exception_new__init, 0, CLASS_Exception, METHODN_new__init, 0, MFN_nException_String_String_Object, (void*)NULL},
	{knh__InputStream_readLine, 0, CLASS_InputStream, METHODN_readLine, 0, MFN_String, (void*)NULL},
	{knh__InputStream_close, 0, CLASS_InputStream, METHODN_close, 0, MFN_void, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Mapper, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Mapper__k},
	{knh__Method_isAbstract, 0, CLASS_Method, METHODN_isAbstract, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_getName, 0, CLASS_Method, METHODN_getName, 0, MFN_nString, (void*)NULL},
	{knh__Method_getURN, 0, CLASS_Method, METHODN_getURN, 0, MFN_nString, (void*)NULL},
	{knh__Object_new, KNH_FLAG_MF_VIRTUAL, CLASS_Object, METHODN_new, 0, MFN_nThis, (void*)NULL},
	{knh__OutputStream_flush, 0, CLASS_OutputStream, METHODN_flush, 0, MFN_void, (void*)NULL},
	{knh__OutputStream_clear, 0, CLASS_OutputStream, METHODN_clear, 0, MFN_void, (void*)NULL},
	{knh__OutputStream_close, 0, CLASS_OutputStream, METHODN_close, 0, MFN_void, (void*)NULL},
	{knh__String_opMatch, 0, CLASS_String, METHODN_opMatch, 0, MFN_nBoolean_nRegex, (void*)NULL},
	{knh__Regex_opMatch, 0, CLASS_Regex, METHODN_opMatch, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Regex, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Regex__s},
	{knh__ResultSet_next, 0, CLASS_ResultSet, METHODN_next, 0, MFN_nBoolean, (void*)NULL},
	{knh__ResultSet_close, 0, CLASS_ResultSet, METHODN_close, 0, MFN_void, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Script, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Script__k},
	{knh_fmethod_movableText, 0, CLASS_Script, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Script__dump},
	{knh__System_getProperty, 0, CLASS_System, METHODN_getProperty, 0, MFN_Any_nString, (void*)NULL},
	{knh__System_setProperty, 0, CLASS_System, METHODN_setProperty, 0, MFN_void_nString_Any, (void*)NULL},
	{knh_fmethod_movableText, 0, CLASS_Stmt, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Stmt__s},
	{knh_fmethod_movableText, 0, CLASS_Stmt, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Stmt__dump},
	{knh_fmethod_movableText, 0, CLASS_Token, METHODN__s, 0, MFN_void_OutputStream_Any, (void*)knh_Token__s},
	{knh_fmethod_movableText, 0, CLASS_Token, METHODN__k, 0, MFN_void_OutputStream_Any, (void*)knh_Token__k},
	{knh_fmethod_movableText, 0, CLASS_Token, METHODN__dump, 0, MFN_void_OutputStream_Any, (void*)knh_Token__dump},
	{knh__System_hasLibrary, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_hasLibrary, 0, MFN_nBoolean_nString_String, (void*)NULL},
	{knh__Script_eval, 0, CLASS_Script, METHODN_eval, 0, MFN_void_String_String_Int, (void*)NULL},
	{knh__Script_isStatement, 0, CLASS_Script, METHODN_isStatement, 0, MFN_nBoolean_nString, (void*)NULL},
	{knh__Script_readLine, 0, CLASS_Script, METHODN_readLine, 0, MFN_String_String, (void*)NULL},
	{knh__Script_addHistory, 0, CLASS_Script, METHODN_addHistory, 0, MFN_void_nString, (void*)NULL},
	{knh__System_gc, KNH_FLAG_MF_STATIC, CLASS_System, METHODN_gc, 0, MFN_void, (void*)NULL},
	{knh__Object_opInstanceof, 0, CLASS_Object, METHODN_opInstanceof, 0, MFN_Boolean_nClass, (void*)NULL},
	{knh__Object_isRelease, 0, CLASS_Object, METHODN_isRelease, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_isDebug, 0, CLASS_Object, METHODN_isDebug, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_isImmutable, 0, CLASS_Object, METHODN_isImmutable, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_hasMetaData, 0, CLASS_Object, METHODN_hasMetaData, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_isSynchronized, 0, CLASS_Object, METHODN_isSynchronized, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_isModified, 0, CLASS_Object, METHODN_isModified, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_setModified, 0, CLASS_Object, METHODN_setModified, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Object_isGCMarked, 0, CLASS_Object, METHODN_isGCMarked, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_setGCMarked, 0, CLASS_Object, METHODN_setGCMarked, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Object_isFormatted, 0, CLASS_Object, METHODN_isFormatted, 0, MFN_nBoolean, (void*)NULL},
	{knh__Object_setFormatted, 0, CLASS_Object, METHODN_setFormatted, 0, MFN_void_Boolean, (void*)NULL},
	{knh__DictMap_isIgnoreCase, 0, CLASS_DictMap, METHODN_isIgnoreCase, 0, MFN_nBoolean, (void*)NULL},
	{knh__DictSet_isIgnoreCase, 0, CLASS_DictSet, METHODN_isIgnoreCase, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isRelease, 0, CLASS_Class, METHODN_isRelease, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isDebug, 0, CLASS_Class, METHODN_isDebug, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isImmutable, 0, CLASS_Class, METHODN_isImmutable, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isMetaExtensible, 0, CLASS_Class, METHODN_isMetaExtensible, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isPrivate, 0, CLASS_Class, METHODN_isPrivate, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isPublic, 0, CLASS_Class, METHODN_isPublic, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isFinal, 0, CLASS_Class, METHODN_isFinal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Class_isInterface, 0, CLASS_Class, METHODN_isInterface, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isPrivate, 0, CLASS_Method, METHODN_isPrivate, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isPublic, 0, CLASS_Method, METHODN_isPublic, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isVirtual, 0, CLASS_Method, METHODN_isVirtual, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isFinal, 0, CLASS_Method, METHODN_isFinal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isConst, 0, CLASS_Method, METHODN_isConst, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isStatic, 0, CLASS_Method, METHODN_isStatic, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isNullBase, 0, CLASS_Method, METHODN_isNullBase, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isVarArgs, 0, CLASS_Method, METHODN_isVarArgs, 0, MFN_nBoolean, (void*)NULL},
	{knh__Method_isAspect, 0, CLASS_Method, METHODN_isAspect, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isInterface, 0, CLASS_Mapper, METHODN_isInterface, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isSignificant, 0, CLASS_Mapper, METHODN_isSignificant, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isFinal, 0, CLASS_Mapper, METHODN_isFinal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isSynonym, 0, CLASS_Mapper, METHODN_isSynonym, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isLossLess, 0, CLASS_Mapper, METHODN_isLossLess, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isTotal, 0, CLASS_Mapper, METHODN_isTotal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isPartial, 0, CLASS_Mapper, METHODN_isPartial, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isConst, 0, CLASS_Mapper, METHODN_isConst, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isTemporal, 0, CLASS_Mapper, METHODN_isTemporal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isLocal, 0, CLASS_Mapper, METHODN_isLocal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Mapper_isDerived, 0, CLASS_Mapper, METHODN_isDerived, 0, MFN_nBoolean, (void*)NULL},
	{knh__IntUnit_isUnsigned, 0, CLASS_IntUnit, METHODN_isUnsigned, 0, MFN_nBoolean, (void*)NULL},
	{knh__OutputStream_isAutoFlush, 0, CLASS_OutputStream, METHODN_isAutoFlush, 0, MFN_nBoolean, (void*)NULL},
	{knh__OutputStream_setAutoFlush, 0, CLASS_OutputStream, METHODN_setAutoFlush, 0, MFN_void_Boolean, (void*)NULL},
	{knh__OutputStream_isStoringBuffer, 0, CLASS_OutputStream, METHODN_isStoringBuffer, 0, MFN_nBoolean, (void*)NULL},
	{knh__OutputStream_setStoringBuffer, 0, CLASS_OutputStream, METHODN_setStoringBuffer, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Exception_isFatal, 0, CLASS_Exception, METHODN_isFatal, 0, MFN_nBoolean, (void*)NULL},
	{knh__Exception_isLogging, 0, CLASS_Exception, METHODN_isLogging, 0, MFN_nBoolean, (void*)NULL},
	{knh__Exception_isGenerated, 0, CLASS_Exception, METHODN_isGenerated, 0, MFN_nBoolean, (void*)NULL},
	{knh__Context_isRelease, 0, CLASS_Context, METHODN_isRelease, 0, MFN_nBoolean, (void*)NULL},
	{knh__Context_isDebug, 0, CLASS_Context, METHODN_isDebug, 0, MFN_nBoolean, (void*)NULL},
	{knh__Context_setRelease, 0, CLASS_Context, METHODN_setRelease, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Context_setDebug, 0, CLASS_Context, METHODN_setDebug, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Context_isVerbose, 0, CLASS_Context, METHODN_isVerbose, 0, MFN_nBoolean, (void*)NULL},
	{knh__Context_setVerbose, 0, CLASS_Context, METHODN_setVerbose, 0, MFN_void_Boolean, (void*)NULL},
	{knh__Context_isVerbose2, 0, CLASS_Context, METHODN_isVerbose2, 0, MFN_nBoolean, (void*)NULL},
	{knh__Context_setVerbose2, 0, CLASS_Context, METHODN_setVerbose2, 0, MFN_void_Boolean, (void*)NULL},
	{NULL, 0}
};

static knh_MapperData_t MapperData[] = {
	{knh_Array_Iterator, KNH_FLAG_MMF_TOTAL, CLASS_Array, CLASS_Iterator},
	{knh_Iterator_Array, KNH_FLAG_MMF_TOTAL, CLASS_Iterator, CLASS_Array},
	{knh_Bytes_String, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_Bytes, CLASS_String},
	{knh_String_Bytes, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_String, CLASS_Bytes},
	{knh_DictMap_Iterator, KNH_FLAG_MMF_TOTAL, CLASS_DictMap, CLASS_Iterator},
	{knh_DictMap_Iterator__, KNH_FLAG_MMF_TOTAL, CLASS_DictMap, ICLASS_String},
	{knh_DictSet_Iterator, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_DictSet, CLASS_Iterator},
	{knh_DictSet_String__, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_DictSet, ICLASS_String},
	{knh_String___DictSet, KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, ICLASS_String, CLASS_DictSet},
	{knh_HashMap_Iterator, KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_HashMap, CLASS_Iterator},
	{knh_Boolean_String, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_LOSSLESS|KNH_FLAG_MMF_TOTAL, CLASS_Boolean, CLASS_String},
	{knh_String_Boolean, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_String, CLASS_Boolean},
	{knh_String_Int, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL, CLASS_String, CLASS_Int},
	{knh_Int_String, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_LOSSLESS|KNH_FLAG_MMF_TOTAL, CLASS_Int, CLASS_String},
	{knh_String_Float, KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_CONST, CLASS_String, CLASS_Float},
	{knh_Float_String, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_LOSSLESS|KNH_FLAG_MMF_TOTAL, CLASS_Float, CLASS_String},
	{knh_Int_Float, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_Int, CLASS_Float},
	{knh_Float_Int, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_Float, CLASS_Int},
	{knh_Object_Iterator, KNH_FLAG_MMF_CONST|KNH_FLAG_MMF_TOTAL, CLASS_Object, CLASS_Iterator},
	{knh_Object_String, KNH_FLAG_MMF_TOTAL, CLASS_Object, CLASS_String},
	{knh_InputStream_String__, KNH_FLAG_MMF_FINAL|KNH_FLAG_MMF_TOTAL, CLASS_InputStream, ICLASS_String},
	{knh_Bytes_InputStream, KNH_FLAG_MMF_TOTAL, CLASS_Bytes, CLASS_InputStream},
	{NULL, 0}
};

typedef void (*knh_finit_)(Ctx *);

static knh_finit_ InitFuncData[] = {
	init_DB,
	init_IO,
	init_Regex,
	NULL
};

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*STRUCT__H*/
