/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#define KNH_TSTRUCT_C

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [tContext] */

#define KNH_UNUSEDCTX(ctx)  ((Context*)ctx)->tObjectTable = NULL;
#define KNH_ISUSEDCTX(ctx)  (ctx->tObjectTable != NULL)

void konoha_loadSystemString(Ctx *ctx); /* konoha_data.c */
void konoha_loadSystemData(Ctx *ctx);


/* ======================================================================== */
/* [INITCONST] */

static
Object *new_Nue__T(Ctx *ctx, char *text)
{
	knh_Nue_t *o = (knh_Nue_t*)new_hObject(ctx, FLAG_Nue, CLASS_Nue, CLASS_Nue);
	o->str = (knh_uchar_t*)text;
	o->size = knh_strlen(text);
	o->orign = NULL;
	return (Object*)o;
}

/* ------------------------------------------------------------------------ */

static
knh_Object_t *new_Boolean0(Ctx *ctx, knh_bool_t tf)
{
	knh_Boolean_t *o = (knh_Boolean_t*)new_hObject(ctx, FLAG_Boolean, CLASS_Boolean, CLASS_Boolean);
	o->n.bvalue = tf;
	return (knh_Object_t*)o;
}

/* ------------------------------------------------------------------------ */

static knh_System_t *new_System(Ctx *ctx)
{
	return (knh_System_t*)new_Object_bcid(ctx, CLASS_System, 0);
}

/* ------------------------------------------------------------------------ */

#ifdef KNH_DBGMODE
#define FLAG_CTX(f)      (f|KNH_FLAG_CTXF_VERBOSE)
#else
#define FLAG_CTX(f)      (f)
#endif

void konoha_initContext(Ctx *ctx, knh_Context_t *o, size_t stacksize)
{
	o->recentCreatedObject = NULL;
	o->recentCreatedObjectSize = 0;
	o->fsweep = konoha_getDefaultSweepFunction();
	o->fgchook = NULL;

	if(ctx->tContext == o) { /* knh_initSystemConst */
		KNH_INITv(o->constNull, new_Nue__T(ctx, "Null!!"));
		KNH_INITv(o->constVoid, new_Nue__T(ctx, "Null!!: return void"));
		KNH_INITv(o->constTrue, new_Boolean0(ctx, 1));
		KNH_INITv(o->constFalse, new_Boolean0(ctx, 0));
		KNH_INITv(o->constFloat0, new_hObject(ctx, FLAG_Float, CLASS_Float, CLASS_Float));
		(o->constFloat0)->n.fvalue = 0.0;

		/*TINT*/ {
			knh_int_t i;
			KNH_ASSERT(KNH_TINT_MIN < KNH_TINT_MAX);
			KNH_ASSERT(o->tInt == NULL);
			o->tInt = (knh_Int_t**)KNH_MALLOC(ctx, SIZEOF_TINT);
			for(i = KNH_TINT_MIN; i <= KNH_TINT_MAX; i++) {
				Int *n = (Int*)new_hObject(ctx, FLAG_Int, CLASS_Int, CLASS_Int);
				KNH_INITv(o->tInt[i - KNH_TINT_MIN], n);
				(n)->n.ivalue = i;
			}
		}

		KNH_ASSERT(o->tString == NULL);
		o->tString = (knh_String_t**)KNH_MALLOC(ctx, SIZEOF_TSTRING);
		knh_bzero(o->tString, SIZEOF_TSTRING);
		konoha_loadSystemString(ctx);
		KNH_INITv(o->sys, new_System(ctx));

	}
	else {
		KNH_ASSERT(!KNH_ISUSEDCTX(ctx));
		o->tObjectTable = ctx->tObjectTable;
		o->tStruct = ctx->tStruct;
		o->tClass = ctx->tClass;
		o->tExpt  = ctx->tExpt;

		o->constNull = ctx->constNull;
		o->constVoid = ctx->constVoid;
		o->constTrue = ctx->constTrue;
		o->constFalse = ctx->constFalse;
		o->constFloat0 = ctx->constFloat0;
		o->tInt = ctx->tInt;
		o->tString = ctx->tString;
		o->sys = ctx->sys;
	}

	DP(o->sys)->ctxcount += 1;
	o->flag  = FLAG_CTX(0);
	o->stacksize = (stacksize < 64) ? KONOHA_STACKSIZE : stacksize;
	o->stack = (knh_sfp_t*)KNH_MALLOC(ctx, sizeof(knh_sfp_t) * o->stacksize);
	o->esp = o->stack;
	{
		size_t i;
		for(i = 0; i < o->stacksize; i++) {
			KNH_INITv(o->stack[i].o, KNH_NULL);
			o->stack[i].data = 0;
		}
	}
	o->doing = NULL;

	KNH_INITv(o->bufa, new_Bytes(ctx, o->stacksize * 4));
	KNH_INITv(o->bufw, new_BytesOutputStream(ctx, o->bufa));
	KNH_INITv(o->bconvbuf, new_Bytes(ctx, 256));
	KNH_INITv(o->props, new_DictMap0(ctx, 16));

	KNH_INITv(o->enc, DP(ctx->sys)->enc);
	KNH_INITv(o->in,  DP(ctx->sys)->in);
	KNH_INITv(o->out, DP(ctx->sys)->out);
	KNH_INITv(o->err, DP(ctx->sys)->err);

	KNH_INITv(o->tmapperHashMap, new_HashMap(ctx, "tmapperHashMap", 0));
	KNH_INITv(o->tmethodHashMap, new_HashMap(ctx, "tmethodHashMap", 0));

	KNH_INITv(o->ns,   KNH_NULL);
	KNH_INITv(o->tsymbolDictMap, new_DictMap0(ctx, 256));
	KNH_INITv(o->cmpr, KNH_NULL);

	KNH_INITv(o->parent, ctx);  /* tContext[0] is cycliced */
}

/* ------------------------------------------------------------------------ */

static
void konoha_traverseSystemTable(Ctx *ctx, knh_ftraverse ftr);

/* ------------------------------------------------------------------------ */

void knh_Context_traverse(Ctx *ctx, knh_Context_t *o, knh_ftraverse ftr)
{
	//DBG2_P("ctxid=%d", ctx->ctxid)
	size_t i;
	for(i = 0; i < o->stacksize; i++) {
		ftr(ctx, o->stack[i].o);
	}

	/*local*/
	ftr(ctx, UP(o->bufa));
	ftr(ctx, UP(o->bufw));
	ftr(ctx, UP(o->bconvbuf));
	ftr(ctx, UP(o->props));
	ftr(ctx, UP(o->enc));
	ftr(ctx, UP(o->in));
	ftr(ctx, UP(o->out));
	ftr(ctx, UP(o->err));
	ftr(ctx, UP(o->tmapperHashMap));
	ftr(ctx, UP(o->tmethodHashMap));
	ftr(ctx, UP(o->ns));
	ftr(ctx, UP(o->cmpr));
	ftr(ctx, UP(o->tsymbolDictMap));
	if(ctx != o->parent) {
		ftr(ctx, UP(o->parent));
	}

	if(IS_SWEEP(ftr)) {
		KNH_FREE(ctx, o->stack, sizeof(knh_sfp_t) * o->stacksize);
		o->stack = NULL;
		o->esp = NULL;
		DBG2_P("freeing context %d", (int)o->ctxid);
		DP(o->sys)->ctxcount -= 1;
		if(ctx->tContext != o) KNH_UNUSEDCTX(ctx);
		ctx->share->tContextSize -= 1;
	}

	if(ctx->tContext == o) { /* traverseSystemConnst */
		/*shared*/
		int j;
		for(i = 0; i < KNH_TSTRING_SIZE; i++) {
			ftr(ctx, UP(o->tString[i]));
		}
		for(j = KNH_TINT_MIN; j <= KNH_TINT_MAX; j++) {
			Int *n = o->tInt[j - KNH_TINT_MIN];
			ftr(ctx, UP(n));
		}

		ftr(ctx, UP(o->constFloat0));
		ftr(ctx, UP(o->sys));
		ftr(ctx, UP(o->constTrue));
		ftr(ctx, UP(o->constFalse));
		ftr(ctx, UP(o->constVoid));
		ftr(ctx, UP(o->constNull));

		if(IS_SWEEP(ftr)) {
			KNH_FREE(ctx, o->tString, SIZEOF_TSTRING);
			KNH_FREE(ctx, o->tInt, SIZEOF_TINT);
			o->tString = NULL;
			o->tInt = NULL;
		}
		konoha_traverseSystemTable(ctx, ftr);
		if(IS_SWEEP(ftr)) {
			KNH_UNUSEDCTX(ctx);
		}
	}
	else {
		if(IS_SWEEP(ftr)) {
			o->constFloat0 = NULL;
			o->sys = NULL;
			o->constTrue = NULL;
			o->constFalse = NULL;
			o->constVoid = NULL;
			o->constNull = NULL;

			o->tInt = NULL;
			o->tString = NULL;
			o->tClass = NULL;
			o->tStruct = NULL;
			o->tExpt = NULL;
			KNH_UNUSEDCTX(ctx);
		}
	}

}

/* ======================================================================== */
/* [global] */

static void konoha_initSystemTable(Context *ctx)
{
	KNH_ASSERT(ctx->tObjectTable == NULL);
	ctx->tObjectTable = (knh_ObjectTable_t*)KNH_MALLOC((Ctx*)ctx, sizeof(knh_ObjectTable_t) * ctx->share->maxObjectTableSize);
	knh_bzero(ctx->tObjectTable, sizeof(knh_ObjectTable_t) * ctx->share->maxObjectTableSize);
	ctx->share->tObjectTableSize = 0;

	KNH_ASSERT(ctx->tStruct == NULL);
	ctx->tStruct = (knh_tStruct_t*)KNH_MALLOC((Ctx*)ctx, SIZEOF_TSTRUCT);
	knh_bzero(ctx->tStruct, SIZEOF_TSTRUCT);
	ctx->share->tStructSize = 0;

	KNH_ASSERT(ctx->tClass == NULL);
	size_t i;
	ctx->tClass = (knh_tClass_t*)KNH_MALLOC((Ctx*)ctx, SIZEOF_TCLASS);
	for(i = 0; i < KNH_TCLASS_SIZE; i++) {
		ctx->tClass[i].cflag    = 0;
		ctx->tClass[i].oflag    = 0;
		ctx->tClass[i].bcid     = 0;
		ctx->tClass[i].supcid   = 0;
		ctx->tClass[i].p1       = CLASS_Nue;   /* @deps knh_Class_isGenerics(cid)*/
		ctx->tClass[i].p2       = CLASS_Nue;
		ctx->tClass[i].offset   = 0;
		ctx->tClass[i].sid      = 0;
		ctx->tClass[i].size     = 0;
		ctx->tClass[i].bsize    = 0;
		ctx->tClass[i].keyidx   = -1;
		ctx->tClass[i].keyidx2   = -1;

		ctx->tClass[i].sname     = NULL;
		ctx->tClass[i].lname     = NULL;
		ctx->tClass[i].class_cid    = NULL;
		ctx->tClass[i].cstruct  = NULL;
		ctx->tClass[i].cmap     = NULL;
		ctx->tClass[i].cspec    = NULL;
		ctx->tClass[i].fdefault   = NULL;
	}
	ctx->share->tClassSize = KNH_TSTRUCT_SIZE;

	ctx->tExpt = (knh_tExpt_t*)KNH_MALLOC((Ctx*)ctx, SIZEOF_TEXPT);
	ctx->share->tExptSize = 0;
	for(i = 0; i < KNH_TEXPT_SIZE; i++) {
		(ctx)->tExpt[i].flag     = 0;
		(ctx)->tExpt[i].parent   = 1;
		(ctx)->tExpt[i].name     = NULL;
	}
	konoha_loadSystemData(ctx);
}

/* ------------------------------------------------------------------------ */

static
void knh_ClassStruct_toAbstractAll(Ctx *ctx, ClassStruct *cs)
{
	Array *a = cs->methods;
	if(IS_bArray(a)) {
		size_t i;
		for(i = 0; i < knh_Array_size(a); i++) {
			Method *mtd = (Method*)knh_Array_n(a, i);
			knh_Method_toAbstract(ctx, mtd);
		}
	}
}

/* ------------------------------------------------------------------------ */

static
void knh_Object_finalSweep(Ctx *ctx, Object *o)
{
	// DO Nothing;
}

/* ------------------------------------------------------------------------ */

static
void knh_ObjectTable_free(Ctx *ctx, knh_Object_t *t)
{
	int i;
	for(i = 0; i < KNH_TOBJECT_SIZE; i++) {
		Object *o = &t[i];
		if(o->h.magic != KNH_OBJECT_MAGIC) continue;
#ifdef KNH_HOBJECT_REFC
		DBG_(
		{
			switch(o->h.bcid) {
			case CLASS_Class:
				fprintf(stderr, "\t%s cid=%d\n", STRUCTN(o->h.bcid), (int)((knh_Class_t*)o)->cid);
			break;
			case CLASS_Int:
				fprintf(stderr, "async mem cid=%s(%d), refc=%d ivalue='%d'\n", STRUCTN(o->h.bcid), (int)o->h.cid, (int)o->h.refc, (int)((Int*)o)->n.ivalue);
			break;
			case CLASS_String:
				fprintf(stderr, "async mem cid=%s(%d), refc=%d str='%s'\n", STRUCTN(o->h.bcid), (int)o->h.cid, (int)o->h.refc, (char*)((knh_String_t*)o)->str);
			break;
			case CLASS_Stmt:
				fprintf(stderr, "\t%s stmt='%s'\n", STRUCTN(o->h.bcid), knh_stmt_tochar((SP(Stmt*)o)->stt));
			break;
			default:
				fprintf(stderr, "async mem cid=%s(%d), refc=%d\n", STRUCTN(o->h.bcid), (int)o->h.cid, (int)o->h.refc);
			}
		} )
		o->h.refc = 0;
#endif
		knh_Object_free(ctx, o);
	}
	KNH_FREE(ctx, t, SIZEOF_TOBJECT);
	t = NULL;
}

/* ------------------------------------------------------------------------ */

static
void konoha_traverseSystemTable(Ctx *ctx, knh_ftraverse ftr)
{
	int i;
	for(i = 0; i < (int)(ctx->share->tExptSize); i++) {
		if(ctx->tExpt[i].name != NULL) {
			ftr(ctx, UP(ctx->tExpt[i].name));
		}
	}

	if(IS_SWEEP(ftr)) {
		KNH_FREE(ctx, ctx->tExpt, SIZEOF_TEXPT);
		((Context*)ctx)->tExpt = NULL;
	}

	/* tclass */
	if(IS_SWEEP(ftr)) {
		for(i = ctx->share->tClassSize - 1; i >= 0; i--) {
			if(ctx->tClass[i].sname == NULL) continue;
			knh_ClassStruct_toAbstractAll(ctx, ctx->tClass[i].cstruct);
		}
	}
	konoha_RCcollect(NULL);
	for(i = ctx->share->tClassSize - 1; i >= 0; i--) {
		if(ctx->tClass[i].sname != NULL) {
			//DBG2_P("cid=%d,%s", i,knh_String_tochar(ctx->tClass[i].sname));
			ftr(ctx, UP(ctx->tClass[i].sname));
			ftr(ctx, UP(ctx->tClass[i].lname));
			ftr(ctx, UP(ctx->tClass[i].class_cid));
			ftr(ctx, UP(ctx->tClass[i].cstruct));
			ftr(ctx, UP(ctx->tClass[i].cmap));
			ftr(ctx, UP(ctx->tClass[i].cspec));
			//ctx->tClass[i].sname = NULL;
		}
	}

	if(IS_SWEEP(ftr)) {
		DBG2_P("******** freeing object table ************");
		((Context*)ctx)->fsweep = knh_Object_finalSweep;
		for(i = 0; i < (int)(ctx->share->tObjectTableSize); i++) {
			knh_ObjectTable_free(ctx, ctx->tObjectTable[i].table);
			ctx->tObjectTable[i].table = NULL;
		}

		KNH_FREE(ctx, ctx->tClass, SIZEOF_TCLASS);
		((Context*)ctx)->tClass = NULL;
		ctx->share->tClassSize = 0;

		KNH_FREE(ctx, ctx->tStruct, SIZEOF_TSTRUCT);
		((Context*)ctx)->tStruct = NULL;
		ctx->share->tStructSize = 0;

		KNH_FREE(ctx, ctx->tObjectTable, sizeof(knh_ObjectTable_t) * ctx->share->maxObjectTableSize);
		((Context*)ctx)->tObjectTable = NULL;

	}

}

/* ------------------------------------------------------------------------ */
/* [tContext] */

//static knh_Context_t *new_Context(Ctx *ctx, size_t stacksize)
//{
//	int i;
//	for(i = 1; i < ctx->share->maxContextSize; i++) {
//		knh_Context_t *o = ctx->tContext + i;
//		if(KNH_ISUSEDCTX(ctx)) continue;
//		ctx->share->tContextSize += 1;
//		konoha_initContext(ctx, o, stacksize);
//		return o;
//	}
//	KNH_EXIT("No context!!");
//	return NULL;
//}

/* ------------------------------------------------------------------------ */

static int knh_fmutexlock_nop(knh_mutex_t *lock)
{
	return 0;
}

/* ------------------------------------------------------------------------ */

static int knh_fmutexunlock_nop(knh_mutex_t *lock)
{
	return 0;
}

/* ------------------------------------------------------------------------ */

static
Ctx *konoha_initContextTable(size_t csize, size_t osize)
{
	knh_ContextShare_t *ts =
		(knh_ContextShare_t*)malloc(sizeof(knh_ContextShare_t) + (sizeof(knh_Context_t) * csize));
	ts->maxContextSize = csize;
	ts->maxObjectTableSize = osize;
	ts->statUsedMemorySize = 0;
	ts->statUsedObjectSize = 0;
	ts->tContextSize = 0;
	ts->tStructSize  = 0;
	ts->tClassSize = 0;
	ts->tExptSize  = 0;
	/* lock */
	ts->flock = knh_fmutexlock_nop;
	ts->funlock = knh_fmutexunlock_nop;

	knh_Context_t *table = (knh_Context_t*)(&ts[1]);
	int i;
	for(i = 0; i < csize; i++) {
		knh_Context_t *o = &table[i];
		o->h.magic = KNH_OBJECT_MAGIC;
#ifdef KNH_HOBJECT_REFC
		o->h.refc = 0;
#endif
		o->h.flag = FLAG_Context;
		o->h.bcid = CLASS_Context;
		o->h.cid  = CLASS_Context;

		o->unusedObject = NULL;
		o->unusedObjectSize = 0;

		o->share = ts;
		o->tContext = table;
		KNH_UNUSEDCTX(o);
		o->ctxid = (knh_ushort_t)i;
		o->tInt = NULL;
		o->tString = NULL;
		o->tStruct = NULL;
		o->tClass = NULL;
		o->tExpt = NULL;
	}
	return &table[0];
}

/* ------------------------------------------------------------------------ */

static
void konoha_traverseContextTable(Ctx* ctx, knh_ftraverse ftr)
{
	int i;
	knh_Context_t *table = ctx->tContext;
	for(i = ctx->share->maxContextSize -1; i >= 0; i--) {
		knh_Context_t *o = &table[i];
		if(KNH_ISUSEDCTX(o)) {
			knh_Context_traverse(ctx, o, ftr);
		}
	}

	if(IS_SWEEP(ftr)) {
		if(ctx->share->statUsedMemorySize != 0) {
			fprintf(stderr, "memory leaks: %d bytes", (int)ctx->share->statUsedMemorySize);
		}
		void *p = ctx->share;
		size_t s = sizeof(knh_ContextShare_t) + (sizeof(knh_Context_t) * ctx->share->maxContextSize);
		knh_bzero(p, s);
		free(p);
	}
}

/* ------------------------------------------------------------------------ */

void konoha_traverse(Ctx* ctx, knh_ftraverse ftr)
{
	konoha_traverseContextTable(ctx, ftr);
}

/* ------------------------------------------------------------------------ */
/* [konoha] */

static void konoha_initSystem(Ctx *ctx)
{
	knh_srand(0);
}

/* ------------------------------------------------------------------------ */

KNHAPI(konoha_t) konoha_open(size_t ctxsize, size_t stacksize)
{
	konoha_t k = {KONOHA_MAGIC};
	if(ctxsize == 0) ctxsize = 1;
	if(stacksize < KONOHA_STACKSIZE) stacksize = KONOHA_STACKSIZE;
	Ctx *ctx = konoha_initContextTable(ctxsize, 1024);
	((Context*)ctx)->stacksize = stacksize; /* not beautiful */
	konoha_initSystemTable((Context*)ctx);
	konoha_initSystem(ctx);
	k.ctx = ctx;
	return k;

}

/* ------------------------------------------------------------------------ */

KNHAPI(void) konoha_close(konoha_t konoha)
{
	KONOHA_CHECK_(konoha);
	konoha_traverseContextTable(konoha.ctx, konoha.ctx->fsweep);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
