/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>

#define KNH_PKGNAME "socket"

#ifdef KNH_USING_SOCKET
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [SOCKET] */

#ifdef KNH_USING_SOCKET

static
knh_io_t knh_socket_open(Ctx *ctx, char *ip_or_host, int port)
{
	struct in_addr addr = {0};
	struct hostent	*host;
	struct sockaddr_in	server = {0};
	int sd = -1;

	server.sin_family = AF_INET;

	if ((addr.s_addr = inet_addr(ip_or_host)) == -1) {
		host = gethostbyname(ip_or_host);
		if (host == NULL) {
			KNH_PERRNO(ctx, "Socket!!", "gethostbyname");
			//KNH_THROWf(ctx, "Socket!!: no such host %s", ip_or_host);
			return -1;
		}
		memcpy(&addr, (struct in_addr *)*host->h_addr_list, sizeof(struct in_addr));
	}
	server.sin_family = AF_INET;
	server.sin_addr = addr;
	server.sin_port = htons(port);

	if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		KNH_PERRNO(ctx, "Socket!!", "socket");
		return -1;
	}
	if (connect(sd, (struct sockaddr *)&server, sizeof(server)) == -1) {
		KNH_PERRNO(ctx, "Socket!!", "connect");
		return -1;
	}
	return (knh_io_t)sd;
}

/* ------------------------------------------------------------------------ */
/* 'ip:127.0.0.1:80' */
/* 'host:localhost:80' */
/* 'socket:localhost:80' */

static
knh_io_t knh_iodrv_open__SOCKET(Ctx *ctx, InputStream *in, OutputStream *out, knh_bytes_t file, char *mode)
{
	knh_bytes_t urn = knh_bytes_skipscheme(file);
	knh_index_t loc = knh_bytes_rindex(urn, ':');
	int port = 80; /* default */
	if(loc != -1) {
		port = (int)knh_bytes_toint(knh_bytes_last(urn, loc+1));
		urn = knh_bytes_first(urn, loc);
	}
	char host_or_ip[128];
	knh_format_bytes(host_or_ip, sizeof(host_or_ip), urn);

	KNH_WARNING(ctx, "opening socket host='%s', port=%d", host_or_ip, port);
	KNH_SECURE(ctx);

	knh_io_t sd = knh_socket_open(ctx, host_or_ip, port);
	if(sd != -1) {

	}
	return sd;
}

/* ------------------------------------------------------------------------ */

static
knh_int_t knh_iodrv_read__SOCKET(Ctx *ctx, knh_io_t sd, char *buf, size_t bufsiz)
{
	ssize_t ssize = recv((int)sd, buf, bufsiz, 0);
	return ssize;
}

/* ------------------------------------------------------------------------ */

static
knh_int_t knh_iodrv_write__SOCKET(Ctx *ctx, knh_io_t sd, char *buf, size_t bufsiz)
{
	ssize_t ssize = send((int)sd, buf, bufsiz, 0);
	return ssize;
}

/* ------------------------------------------------------------------------ */

static
void knh_iodrv_close__SOCKET(Ctx *ctx, knh_io_t sd)
{
	close((int)sd);
}

/* ------------------------------------------------------------------------ */
/* @data */

static knh_iodrv_t IO__SOCKET = {
	KNH_DRVAPI_TYPE__IO, "socket",
	1024,
	knh_iodrv_open__SOCKET,
	knh_iodrv_read__SOCKET,
	knh_iodrv_write__SOCKET,
	knh_iodrv_close__SOCKET
};

#endif/*KNH_USING_SOCKET*/

///* ======================================================================== */
///* [structs] */
//
//typedef struct {
//	int sd;
//	int port;
//	struct knh_InputStream_t  *in;
//	struct knh_OutputStream_t *out;
//} knh_Socket_struct ;
//
//typedef struct {
//	knh_hObject_t h;
//	knh_Socket_struct *b;
//} knh_Socket_t;
//
///* ======================================================================== */
///* [structs] */
//
//void knh_Socket_init(Ctx *ctx, Struct *s, int init)
//{
//	knh_Socket_struct *b = (knh_Socket_struct*)s;
//	KNH_INITv(b->urn, knh_String_EMPTY());
//	b->sd = -1;
//	b->port = 0;
//	KNH_INITv(b->in, knh_tClass_defaultValue(ctx, CLASS_InputStream));
//	KNH_INITv(b->out, knh_tClass_defaultValue(ctx, CLASS_OutputStream));
//}
//
///* ------------------------------------------------------------------------ */
//
//#define _knh_Socket_struct_copy   NULL
//
///* ------------------------------------------------------------------------ */
//
//#define _knh_Socket_struct_compare  NULL
//
///* ------------------------------------------------------------------------ */
//
//void
//knh_Socket_traverse(Ctx *ctx, Struct *s, f_traverse gc)
//{
//	knh_Socket *b = (knh_Socket*)s;
//	gc(ctx, b->urn);
//	if(IS_SWEEP(gc)) {
//		if(b->sd != -1) {
//			knh_Socket_close(ctx, b);
//		}
//	}
//	gc(ctx, b->in);
//	gc(ctx, b->out);
//}
//
///* ======================================================================== */
///* [constructors] */
//
//Socket* new_Socket(Ctx *ctx, knh_bytes_t urn, int port)
//{
//	char *ip_or_host = NULL;
//	Socket* b = (Socket*)knh_Object_malloc(ctx, CLASS_Socket);
//	knh_Socket_init(ctx, (Struct*)b, 0, NULL);
//	KNH_SETv(ctx, b->urn, new_StringX__fast(ctx, CLASS_String, urn));
//	b->port = port;
//
//	if(knh_bytes_startsWith(urn, STEXT("socket:"))) {
//		ip_or_host = (char*)(knh_bytes_last(urn, 7)).buf;
//	}
//	else if(knh_bytes_startsWith(urn, STEXT("ip:"))) {
//		ip_or_host = (char*)(knh_bytes_last(urn, 3)).buf;
//	}
//	else {
//		ip_or_host = (char*)urn.buf;
//	}
//	if(knh_Socket_open__deps(ctx, b, ip_or_host, port)) {
//		KNH_SETv(ctx, b->in, new_InputStream(ctx, b->urn, (knh_inptr_t*)b, DRIVERS__sockin));
//		KNH_SETv(ctx, b->out, new_OutputStream(ctx, b->urn, (knh_outptr_t*)b, DRIVERS__sockout));
//	}
//	else {
//		KNH_SETv(ctx, b->in, new_InputStream__NULL(ctx));
//		KNH_SETv(ctx, b->out, new_OutputStream__NULL(ctx));
//	}
//	return b;
//}
//
///* ======================================================================== */
///* [method] */
//
///* ------------------------------------------------------------------------ */
///* @method InputStream! Socket.getInputStream() */
//
//InputStream *knh_Socket_getInputStream(Ctx *ctx, Socket *b)
//{
//	return b->in;
//}
//
///* ------------------------------------------------------------------------ */
///* @method OutputStream! Socket.getOutputStream() */
//
//OutputStream *knh_Socket_getOutputStream(Ctx *ctx, Socket *b)
//{
//	return b->out;
//}
//
///* ------------------------------------------------------------------------ */
///* @method void Socket.close() */
//
//void knh_Socket_close(Ctx *ctx, Socket *b)
//{
//	knh_InputStream_close(ctx, b->in);
//	knh_OutputStream_close(ctx, b->out);
//	if(b->sd != -1) {
//		knh_Socket_close__deps(ctx, b);
//		b->sd = -1;
//	}
//}


/* ======================================================================== */
/* [KNHAPI] */

int knhsocket_init(Ctx *ctx)
{
	KNH_NOTICE(ctx, "loading socket..");
#ifdef KNH_USING_SOCKET
	konoha_addIODriver(ctx, NULL, &IO__SOCKET);
	konoha_addIODriver(ctx, "ip", &IO__SOCKET);
	konoha_addIODriver(ctx, "host", &IO__SOCKET);
#endif
	return 1;
}

/* ------------------------------------------------------------------------ */

void knhsocket_traverse(Ctx *ctx, knh_ftraverse ftr)
{
	if(IS_SWEEP(ftr)) {

	}
}


/* ------------------------------------------------------------------------ */

static knh_pkgmeta_t PKGDATA = {
	KONOHA_BUILDID, /* Don't change this */
	KNH_PKGNAME,    /* package name (not NULL) */
	"1.0",  /* package version (not NULL) */
	NULL,   /* additional information */
	KONOHA_URLBASE "package.socket", /* URL */
	knhsocket_init,
	knhsocket_traverse,
	NULL
};

KNHAPI(knh_pkgmeta_t*) knhsocket_load(Ctx *ctx)
{
	return &(PKGDATA);
}

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
